/****************************************************************
**
** Attal : Lords of Doom
**
** graphicalLord.cpp
** draw a hero on the map
**
** Version : $Id: graphicalLord.cpp,v 1.7 2004/09/12 18:18:17 audoux Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 09/08/2000
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "graphicalLord.h"

 
// generic include files

// include files for QT
#include <qcolor.h>
#include <qimage.h>
#include <qptrlist.h>
#include <qrect.h>
// application specific include
#include "conf.h"

#include "libCommon/genericPlayer.h"
#include "libCommon/log.h"

#include "libClient/imageTheme.h"



/** rtti number for GraphicalLord class */
const int GraphicalLord::RTTI = 1234;

extern QString IMAGE_PATH;
extern ImageTheme ImageTheme;

GraphicalLord::GraphicalLord( QCanvas * canvas )
	: QCanvasSprite( ImageTheme.lords, canvas ) 
{
 	collisions( true );
 	setFrame( 0 );
	setZ( CAN_LORD );
	QPtrList<QPixmap> listPixmapLord;	
	listPixmapLord.setAutoDelete( true );
	listPixmapLord.append( new QPixmap( IMAGE_PATH + "units/lord.png" ) );
	QPtrList<QPoint> listPointLord;
	listPointLord.setAutoDelete( true );
	listPointLord.append( new QPoint(0,0) );
	QCanvasPixmapArray * tryi = new QCanvasPixmapArray( listPixmapLord, listPointLord );
	setSequence( tryi );
	
	_flag = new Flag( canvas );
	
	show();
}

GraphicalLord::~GraphicalLord()
{
	if( _flag ) {
		delete _flag;
	}
}

/** set the hero on the cell */
void GraphicalLord::setPosition( Cell *cell )
{
	QRect rect = cell->boundingRect();
	move( rect.x() , rect.y() + rect.height() - boundingRect().height() );
	if( _flag ) {
		_flag->move( rect.x() , rect.y() + rect.height() - boundingRect().height() );
		_flag->setVisible( true );
		_flag->setZ( CAN_LORD + cell->getRow() + 1 );
	}
	
	setZ( CAN_LORD + cell->getRow() );
	setVisible( true );
	canvas()->update();
}

void GraphicalLord::setVisible( bool state )
{
	QCanvasSprite::setVisible( state );
	if( _flag ) {
		_flag->setVisible( state );
	}
}

void GraphicalLord::goTo( GenericCell *cell )
{
      	QRect rect = ( (Cell *)cell )->boundingRect();
	move( rect.x() , rect.y() + rect.height() - boundingRect().height() );
	if( _flag ) {
		_flag->move( rect.x() , rect.y() + rect.height() - boundingRect().height() );
		_flag->setZ( CAN_LORD + cell->getRow() + 1 );
	}
	
	canvas()->update();
	setZ( CAN_LORD + cell->getRow() );
}

void GraphicalLord::advance( int /*stage*/ )
{
	/// XXX: TODO
	//logEE( "not yet implemented" );
}

void GraphicalLord::setOwner( GenericPlayer * player )
{
	_flag->setOwner( player );
}

/*
void GraphicalLord::setColor( QColor color )
{
	QImage ima = image()->convertToImage();
	uint *p;
	for( int i = 0; i < 8; i++ ) 
		for( int j = 0; j < 8; j++ ) {
			p = (uint *)ima.scanLine(i) + j;
			*p = color.rgb();
		}
	image()->convertFromImage( ima );
}*/

QCanvasPixmap* GraphicalLord::imageAdvanced() const
{
	return image();
}


