/****************************************************************
**
** Attal : Lords of Doom
**
** analyst.h
** analyse the game and play
**
** Version : $Id: analyst.h,v 1.23 2004/12/18 23:25:17 lusum Exp $
**
** Author(s) : Pascal Audoux - Carlo
**
** Date : 06/02/2001
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

 
#ifndef ANALYST_H
#define ANALYST_H
#define DIM 100
 

// generic include files
// include files for QT
// application specific include files
#include "libCommon/artefact.h"
#include "libCommon/attalSocket.h"

#include "libServer/gameData.h"

class AttalSocket;
class FightAnalyst;
class GenericLord;
class GenericPlayer;
class GenericMap;
class Calendar;

enum {
	PL_SAME_LORD,
	PL_PASS_TURN,
	PL_SAME_LORD_NOFIGHT
};

/*              ------------------------------
 *                         Analyst
 *              ------------------------------ */

/** comment for the class */
class Analyst : public GameData
{

public:
	/** Constructor */
	Analyst();
	
	/** Destructor */
	~Analyst();

	void reinitAi();

	/** Set socket for exchanges with server */
	void setSocket( AttalSocket * sock ) {
		_socket = sock;
	}

	/** Handle SO_MSG socket data */
	void socketMsg();

	/** Handle SO_CONNECT socket data */
	void socketConnect();

	/** Handle SO_MVT socket data */
	void socketMvt();
	
	/** Handle SO_TECHNIC socket data */
	void socketTechnic();
	
	/** Handle SO_FIGHT socket data */
	void socketFight();
	
	/** Handle SO_QR socket data */
	void socketQR();
	
	/** Handle SO_EXCH socket data */
	void socketExch();

	void socketGameInfo();
	
	/** Handle SO_MODIF socket data */
	void socketModif();
	void socketModifMap();
	void socketModifCell();
	void socketModifLord();
	void socketModifLordVisit();
	void socketModifLordNew();
	void socketModifLordUnit();
	void socketModifLordRemove();
	void socketModifBase();
	void socketModifBaseNew();
	void socketModifBaseOwner();
	void socketModifBaseName();
	void socketModifBaseBuilding();
	void socketModifBaseUnit();
	void socketModifBasePopulation();
	void socketModifBuilding();
	void socketModifArtefact();
	void socketModifPlayer();
	void socketModifCreature();
	void socketModifEvent();

	/** Handle SO_TURN socket data */
	void socketTurn();
	void socketTurnBegin();

	/** Handle SO_GAME socket data */
	void socketGame();
	
	/* Return random lord power */
	int getRandPower(GenericLord *lord);
	
	/* Return creature power */
	int getCreaturePower(GenericMapCreature * creature);
	
	GenericPlayer * getPlayer( uint num );
	
	/* Return exact lord power */
	int getPower(GenericLord *lord);

	void exchangeStart();

	/** manage exchange units */
	void exchangeUnits();
	
	/** manage exchange artefact */
	void exchangeArtefact();
	
	void exchangeBaseUnits();
	
	void manageBase(GenericBase * base);
	
	void enterBase(GenericLord * lord,GenericBase * base );

	//GenericLord * getLord( uint num );

private:

	struct aiData{
		int rowFlee;
		int colFlee;
		int startApprRow;
		int startApprCol;
		int curPrior;
		int mincost;
		int fightCpt;
		GenericCell * destinationCell;
	} ;


	GenericArtefact * getArtefactById( int id );

	void playLordTurn(int nlord);

	void analyzeLord( GenericLord * lord );
	
	void analyzeLordMap( GenericLord * lord, struct aiData *data);

	GenericCell * randomPath(GenericLord * lord,struct aiData *data);

	/* find if this is a cell reachable (and visible) near an unknown cell */
	GenericCell * findNearCellReach(GenericCell * cell);

	int noPath(GenericCell * cell);
	
	inline int flee(int src, int dst);

	/* manageMeetings
	 * with 
	 * lord =  our lord
	 * cell = target cell
	 * prior = priority of the target
	 * opPower = opponent power, 0 if no opponent
	 * isFlee = our lord flee if enemy is more powerful? true yes, false no (only care with opPower>0)
	 * data = struct of various ai param used and changed by this function
	 */
	 
	int manageMeetings( GenericLord * lord, GenericCell * cell,int prior,int opPower, bool isFlee ,struct aiData * data);

	/* tell if the ai is in her turn (for coordinate lord's turn) */
	bool InTurn() { return _numTurn>=0 ? true : false; }

	AttalSocket * _socket;
	FightAnalyst * _fight;
	GenericPlayer * _player;
	Calendar * _calendar;
	int _priorities[PR_LAST+1];
	
	int _fightCpt;
	int _numlords;

	int _numTurn;
	int _SuffisantPower;

	//GenericMap * _map;
	//GenericLord ** _lords;
	//QPtrList<GenericArtefact> _artefacts;
};

#endif // ANALYST_H   
