/*
 *             Automatically Tuned Linear Algebra Software v3.2
 *                      (C) Copyright 1999 Camm Maguire                      
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions, and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *   3. The name of the University, the ATLAS group, or the names of its 
 *      contributers may not be used to endorse or promote products derived
 *      from this software without specific written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE. 
 *
 */


#ifdef GER
#undef NO_TRANSPOSE
#define NO_TRANSPOSE
#endif


#if NDPM > 4
#error Max NDPM is 4 
#endif

#include <stdio.h>
#include <stdlib.h>

#include "camm_util.h"

#ifndef GER
#if defined(BETAX) || defined(BETAXI0)
#include "camm_scale.h"
#endif
#endif

#if NDPM >= 4
#define EXT4 Mjoin(4dp,BLC)
#undef NDP
#define NDP 4
#undef EXT
#define EXT EXT4
#include "camm_dpa.h"
#endif

#if NDPM >= 3
#define EXT3 Mjoin(3dp,BLC)
#undef NDP
#define NDP 3
#undef EXT
#define EXT EXT3
#include "camm_dpa.h"
#endif

#if NDPM >= 2
#define EXT2 Mjoin(2dp,BLC)
#undef NDP
#define NDP 2
#undef EXT
#define EXT EXT2
#include "camm_dpa.h"
#endif

#define EXT1 Mjoin(1dp,BLC)
#undef NDP
#define NDP 1
#undef EXT
#define EXT EXT1
#include "camm_dpa.h"

#undef NDP
#define NDP NDPM
#undef EXT
#define EXT Mjoin(Mjoin(NDP,Mjoin(dp,BLC)),m)
#include "camm_dpa.h"

#ifdef GER
#if defined(SCPLX) || defined(DCPLX)
#ifdef Conj_
#define IM 1c
#else
#define IM 1u
#endif
#else
#define IM 1
#endif


#define FN Mjoin(Mjoin(Mjoin(ATL_,PREC),Mjoin(ger,IM)),_a1_x1_yX)

void 
FN(int m,int n, const SCALAR alpha,const TYPE *c,
   int cinc,const TYPE *b,int binc,
   TYPE *a,int lda) {

#else


#define FN Mjoin(Mjoin(Mjoin(ATL_,PREC),gemv),Mjoin(FEXT,Mjoin(_a1_x1_,Mjoin(BL,_y1))))

void 
FN(int m,int n, const SCALAR alpha,const TYPE *a,
   int lda,const TYPE *b,int binc,
   const SCALAR beta,TYPE *c,int cinc) {

#endif

  int i,mm,nn;
  const TYPE *ae;
#ifdef NO_TRANSPOSE
  int len=m,w=n;
#define zz b
#else
  int len=n,w=m;
#define zz c
#endif

#ifdef GER
#define zzinc binc
#else
#define zzinc 1


#if defined(NO_TRANSPOSE) && defined(BETA0)
  memset(c,0,m*sizeof(*c));
#endif

#if defined(BETAX) || defined(BETAXI0)
#if defined(SCPLX) || defined(DCPLX)
  SCALE(beta,c,m);
#endif
#if defined(SREAL) || defined(DREAL)
  SCALE(&beta,c,m);
#endif
#endif

#endif

  ae=a+w*lda;
  nn=STRIDE*lda;


#if NDPM == 1
  for (;a<ae;a+=lda,zz+=zzinc)
    Mjoin(dp,EXT)(a,nn,b,c,STRIDE*zzinc,len);

#else

  while (a+NDPM*nn<=ae) {
    for (i=0;i<STRIDE;i++,a+=lda,zz+=zzinc) 
      Mjoin(dp,EXT)(a,nn,b,c,STRIDE*zzinc,len);

    a+=(NDPM-1)*nn;
    zz+=(NDPM-1)*STRIDE*zzinc;
  }

  for (i=0;a<ae && i<STRIDE;i++,a+=lda,zz+=zzinc) {

    mm=(ae-a)/nn;
#if STRIDE > 1
    if (((ae-a)/lda)%STRIDE)
      mm++;
#endif
    
    if (mm == 1)
      Mjoin(dp,EXT1)(a,nn,b,c,STRIDE*zzinc,len);

#if ( NDPM == 2 && STRIDE > 1 ) || NDPM > 2
    else if (mm == 2)
      Mjoin(dp,EXT2)(a,nn,b,c,STRIDE*zzinc,len);
#endif

#if ( NDPM == 3 && STRIDE > 1 ) || NDPM > 3
    else if (mm == 3)
      Mjoin(dp,EXT3)(a,nn,b,c,STRIDE*zzinc,len);
#endif

#if ( NDPM == 4 && STRIDE > 1 ) || NDPM > 4
    else if (mm == 4)
      Mjoin(dp,EXT4)(a,nn,b,c,STRIDE*zzinc,len);
#endif


  }

#endif

}

