#ifndef ATL_zGetNB_geqrf

/*
 * NB selection for GEQRF: Side='RIGHT', Uplo='UPPER'
 * M : 25,112,168,224,448,672,728,784,840,896
 * N : 25,112,168,224,448,672,728,784,840,896
 * NB : 4,8,24,56,56,24,96,80,88,168
 */
#define ATL_zGetNB_geqrf(n_, nb_) \
{ \
   if ((n_) < 68) (nb_) = 4; \
   else if ((n_) < 140) (nb_) = 8; \
   else if ((n_) < 196) (nb_) = 24; \
   else if ((n_) < 560) (nb_) = 56; \
   else if ((n_) < 700) (nb_) = 24; \
   else if ((n_) < 756) (nb_) = 96; \
   else if ((n_) < 812) (nb_) = 80; \
   else if ((n_) < 868) (nb_) = 88; \
   else (nb_) = 168; \
}


#endif    /* end ifndef ATL_zGetNB_geqrf */
