#include <stdint.h>

typedef struct {
  WORD_t   vendorid;
  WORD_t   deviceid;
  int        chipreg;
  const char *name;
} AthlonChips_s;

typedef struct {
  const char *desc;
  int        addr;
  LONG_t   bit;
} EachReg_s;

typedef struct {
  int        regid;
  int        tp;
  EachReg_s  regs[3];
} ChipReg_s;

#define VENDORID_AMD         0x1022
#define VENDORID_VIA         0x1106
#define VENDORID_SIS         0x1039
#define VENDORID_NVIDIA      0x10DE

#define REGID_AMD_751        0x00
#define REGID_AMD_762        0x01
#define REGID_VIA_KT133      0x10
#define REGID_VIA_KT266      0x11
#define REGID_VIA_KT400      0x12
#define REGID_VIA_KT880      0x13
#define REGID_SIS_730        0x20
#define REGID_SIS_735        0x21
#define REGID_SIS_746        0x22
#define REGID_NVIDIA_NFORCE1 0x30
#define REGID_NVIDIA_NFORCE2 0x31

/* VendorID, DeviceID, ChipReg number, Name strings */
static AthlonChips_s AthlonChips[] = {
  /* AMD chipset ---------------------------------------------------------*/
  /* AMD 751 */
  { VENDORID_AMD, 0x7006, REGID_AMD_751, "AMD-751" },
  { VENDORID_AMD, 0x700E, REGID_AMD_751, "AMD-761" },
  { VENDORID_AMD, 0x700C, REGID_AMD_762, "AMD-762" },
  /* VIA Chipset --------------------------------------------------------*/
  /* VIA VT8371 */
  { VENDORID_VIA, 0x0391, REGID_VIA_KT133, "VIA KX133" },
  { VENDORID_VIA, 0x0691, REGID_VIA_KT133, "VIA KX133" },
  /* VIA VT8361 */
  { VENDORID_VIA, 0x3112, REGID_VIA_KT133, "VIA KLE133" },
  /* VIA VT8363/8365/8364/8362[A] */
  { VENDORID_VIA, 0x0305, REGID_VIA_KT133, "VIA KT133/KM133/KL133/KN133[A]" },
  /* VIA VT8366 */
  { VENDORID_VIA, 0x3099, REGID_VIA_KT266, "VIA KT266/333[A]" },
  /* VIA VT8375 */
  { VENDORID_VIA, 0x3116, REGID_VIA_KT266, "VIA KM266[A]/KL266/KM333" },
  { VENDORID_VIA, 0x3156, REGID_VIA_KT266, "VIA KN266" },
  /* VIA VT8368 */
  { VENDORID_VIA, 0x3189, REGID_VIA_KT400, "VIA KT400[A]/KT600" },
  /* VIA VT8378 */
  { VENDORID_VIA, 0x3205, REGID_VIA_KT400, "VIA KM400[A]" },
  /* VIA KT880 (function 2) */
  { VENDORID_VIA, 0x2269, REGID_VIA_KT880, "VIA KT880" }, 
  /* SiS Chipset ----------------------------------------------------------*/
  /* SiS 730/733 */
  { VENDORID_SIS, 0x0730, REGID_SIS_730, "SiS 730" },
  { VENDORID_SIS, 0x0733, REGID_SIS_730, "SiS 733" },
  /* SiS 735 or later */
  { VENDORID_SIS, 0x0735, REGID_SIS_735, "SiS 735" },
  { VENDORID_SIS, 0x0740, REGID_SIS_735, "SiS 740" },
  { VENDORID_SIS, 0x0745, REGID_SIS_735, "SiS 745" },
  { VENDORID_SIS, 0x0755, REGID_SIS_735, "SiS 755" },
  /* SiS 746 or later */
  { VENDORID_SIS, 0x0746, REGID_SIS_746, "SiS 746[FX]" },
  { VENDORID_SIS, 0x0741, REGID_SIS_746, "SiS 741/741GX/M741" },
  { VENDORID_SIS, 0x0748, REGID_SIS_746, "SiS 748" },
  /* nVIDIA chipset -----------------------------------------------------*/
  /* nForce */
  { VENDORID_NVIDIA, 0x01a4, REGID_NVIDIA_NFORCE1, "nVIDIA nForce" },
  /* nForce2 */
  { VENDORID_NVIDIA, 0x01e0, REGID_NVIDIA_NFORCE2, "nVIDIA nForce2" },
  /* End Mark */
  { 0, 0, 0, NULL }
};

static ChipReg_s ChipReg[] = {
  /* AMD chipset ----------------------------------------------------------*/
#if 0 /* use WORD instead of LONG (0.3.10) */
  /* AMD AMD-751/761 */
  { REGID_AMD_751, TP_LONG,
    { {"Halt Disconnect and Stop Grant Disconnect", 0x60, 0x00060000},
      {NULL, 0, 0 } } },
  /* AMD AMD-762 */
  { REGID_AMD_762, TP_LONG,
    { {"Halt Disconnect and Stop Grant Disconnect #0", 0x60, 0x00060000},
      {"Halt Disconnect and Stop Grant Disconnect #1", 0x68, 0x00060000},
      {NULL, 0, 0 } } },
#else
  /* AMD AMD-751/761 */
  { REGID_AMD_751, TP_WORD,
    { {"Halt Disconnect and Stop Grant Disconnect", 0x62, 0x0006},
      {NULL, 0, 0 } } },
  /* AMD AMD-762 */
  { REGID_AMD_762, TP_WORD,
    { {"Halt Disconnect and Stop Grant Disconnect #0", 0x62, 0x0006},
      {"Halt Disconnect and Stop Grant Disconnect #1", 0x6a, 0x0006},
      {NULL, 0, 0 } } },
#endif

  /* VIA Chipset ---------------------------------------------------------*/
  /* VIA KX/KLE/KT/KM/KL/KN133[A] */
  { REGID_VIA_KT133, TP_BYTE, 
    { {"Disconnect when STPGNT Detected", 0x52, 0x80},
      {NULL, 0, 0 } } },
  /* VIA KT/KM/266/333[A] */
  { REGID_VIA_KT266, TP_BYTE, 
    { {"Disconnect when STPGNT Detected", 0x92, 0x80},
      {"HALT Command Detection", 0x95, 0x02},
      {NULL, 0, 0 } } },
   /* VIA VT8368 */
  { REGID_VIA_KT400, TP_BYTE, 
    { {"Disconnect when STPGNT Detected", 0xD2, 0x80},
      {"HALT Command Detection", 0xD5, 0x02},
      {NULL, 0, 0 } } },
   /* VIA KT880 */
  { REGID_VIA_KT880, TP_BYTE, 
    { {"Disconnect when STPGNT Detected", 0x82, 0x80},
      {"HALT Command Detection", 0x85, 0x02},
      {NULL, 0, 0 } } }, 
  /* SiS Chipset ---------------------------------------------------------*/
  /* SiS 730/733 */
  { REGID_SIS_730, TP_BYTE, 
    { {"ACPI C1 Disconnect Enable", 0x6B, 0x01},
      {NULL, 0, 0 } } },
  /* SiS 735/740/745/755 */
  { REGID_SIS_735, TP_WORD, 
    { {"ACPI C1 Disconnect Enable", 0x6A, 0x0001},
      {NULL, 0, 0 } } },
  /* SiS 746 or later */
  { REGID_SIS_746, TP_WORD, 
    { {"ACPI C1 Disconnect Enable", 0x6C, 0x0001},
      {NULL, 0, 0 } } },
  /* nVIDIA chipset -----------------------------------------------------*/
  /* nForce */
  { REGID_NVIDIA_NFORCE1, TP_WORD, 
    { /* {"Self-reflesh enable", 0x6C, 0x8000}, */
      {"Halt Disconnect and Stop Grant Disconnect",
       0xE6, 0x0600 },
      {NULL, 0, 0 } } },
  /* nForce2 */
  { REGID_NVIDIA_NFORCE2, TP_BYTE, 
    { {"Halt Disconnect and Stop Grant Disconnect", 0x6F, 0x10}, 
      {NULL, 0, 0 } } },
  /* end mark */
  { 0, 0, { {NULL, 0, 0} } }
};
/* End Of File	**************************************************************/
