#ifndef FILE_HANDLING_HEADER_
#define FILE_HANDLING_HEADER_

#define MAX_CONFIG_LINE 128
#define MAX_INSULT_LINE 80

#define NO_STAGE 0
#define GLOBAL_STAGE 1
#define ENVIRONMENT_STAGE 2
#define PLAYER_STAGE 3

#include <dirent.h>
#include "globaldata.h"
#include "environment.h"
#include "lineseq.h"

// this function reads the text from a file
// and returns a random line from the file.
// On error, NULL is returned.
char *Random_Line(char *filename);


int Save_Game(GLOBALDATA *global, ENVIRONMENT *env);

int Load_Game(GLOBALDATA *global, ENVIRONMENT *env);

int Check_For_Saved_Game(GLOBALDATA *global);

/*
Copy the atanks config file from HOME_DIR to
HOME_DIR/.atanks
*/
int Copy_Config_File(GLOBALDATA *global);


void renderTextLines (GLOBALDATA *global, ENVIRONMENT *env,
                const LINESEQ& lines, int scrollOffset,
                const FONT* fnt, const int spacing );

void scrollTextList (GLOBALDATA *global, ENVIRONMENT *env,
        const LINESEQ& lines);

int draw_circlesBG (GLOBALDATA *global, BITMAP *dest, int x, int y, int width, int height);

void drawMenuBackground (GLOBALDATA *global, ENVIRONMENT *env, int itemType, int tOffset, int numItems);

void flush_inputs();

int Load_Weapons_Text(GLOBALDATA *global);

int Filter_File( const struct dirent *my_file );

struct dirent ** Find_Saved_Games(GLOBALDATA *global, int *num_files_found);

#endif

