#include "as_config.h"
#include "file_util.hh"
#include "file_exceps.hh"
#include "simple_fstream.hh"


#include <pspell/file_util.hh>

#ifdef USE_FILE_LOCKS

// POSIX headers
#include <fcntl.h>

#endif

// This needs to be <stdio.h> and not <cstdio>
#include <stdio.h>
#include <unistd.h>
#include <sys/stat.h>

namespace autil {

  void open_file(SimpleFstream & in, 
		 const string & file, 
		 const char * mode) 
  {
    in.open(file, mode);
    if (!in)
      throw CantReadFile(file);
  }
    
  string add_possible_dir(const string & dir, const string & file) {
    if (need_dir(file.c_str()))
      return dir + "/" + file;
    else
      return file;
  }
   
  time_t get_modification_time(SimpleFstream & f) {
    struct stat s;
    fstat(f.file_no(), &s);
    return s.st_mtime;
  }

  void open_file_readlock(SimpleFstream & in, const string & file) {
    in.open(file.c_str(), "r");
    if (!in)
      throw CantReadFile(file);
#ifdef USE_FILE_LOCKS 
    int fd = in.file_no();
    struct flock fl;
    fl.l_type   = F_RDLCK;
    fl.l_whence = SEEK_SET;
    fl.l_start  = 0;
    fl.l_len    = 0;
    if (fcntl(fd, F_SETLKW, &fl) == -1) {
      in.close();
      throw CantReadFile(file);
    }
#endif
  }

  bool open_file_writelock(SimpleFstream & inout, const string & file) {
#ifndef USE_FILE_LOCKS
    bool exists = file_exists(file);
#endif
    inout.open(file, "r+");
    if (!inout)
      inout.open(file, "w+");
    if (!inout)
      throw CantWriteFile(file);
#ifdef USE_FILE_LOCKS 
    int fd = inout.file_no();
    struct flock fl;
    fl.l_type   = F_WRLCK;
    fl.l_whence = SEEK_SET;
    fl.l_start  = 0;
    fl.l_len    = 0;
    if (fcntl(fd, F_SETLKW, &fl) == -1)
      throw CantWriteFile(file);
    struct stat s;
    fstat(fd, &s);
    return s.st_size != 0;
#else
    return exists;
#endif
  }

  void truncate_file(SimpleFstream & f, const string & name) {
#ifdef USE_FILE_LOCKS
    f.restart();
    ftruncate(f.file_no(),0);
#else
    f.close();
    f.open(name.c_str(), "w+");
#endif    
  }
  
  bool remove_file(const string & name) {
    return remove(name.c_str()) == 0;
  }

  bool file_exists(const string & name) {
    return access(name.c_str(), F_OK) == 0;
    //struct stat fileinfo;
    //return stat(name.c_str(), &fileinfo) == 0;
  }

  bool rename_file(const string & orig_name, const string & new_name) 
  {
    remove(new_name.c_str());
    return rename(orig_name.c_str(), new_name.c_str()) == 0;
  }

  const char * get_file_name(const char * path) {
    const char * file_name;
    if (path != 0) {
      file_name = strrchr(path,'/');
      if (file_name == 0) 
	file_name = path;
    } else {
      file_name = 0;
    }
    return file_name;
  }

}

