------------------------------------------------------------------------------
--                                                                          --
--                     ASIS UTILITY LIBRARY COMPONENTS                      --
--                                                                          --
--             ASIS_UL.SOURCE_TABLE.PROCESSING.ASIS_PROCESSING              --
--                                                                          --
--                           (gnatsync version)                             --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                    Copyright (C) 2007-2008, AdaCore                      --
--                                                                          --
-- GNATSYNC  is  free  software;  you  can redistribute it and/or modify it --
-- under terms of the  GNU  General Public License as published by the Free --
-- Software Foundation;  either version 2, or ( at your option)  any  later --
-- version.  GNATCHECK  is  distributed in the hope that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;   without  even  the  implied  warranty  of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU  General Public License distributed with GNAT; see file  COPYING. If --
-- not,  write to the  Free Software Foundation,  51 Franklin Street, Fifth --
-- Floor, Boston, MA 02110-1301, USA.                                       --
--                                                                          --
-- GNATSYNC is maintained by AdaCore (http://www.adacore.com).              --
--                                                                          --
------------------------------------------------------------------------------

with Asis.Elements;        use Asis.Elements;

with Gnatsync.Global_Info; use Gnatsync.Global_Info;
with Gnatsync.Global_Info.Data;
with Gnatsync.Threads;

separate (ASIS_UL.Source_Table.Processing)
procedure ASIS_Processing (CU : Asis.Compilation_Unit; SF : SF_Id) is
   Unit    : constant Asis.Element        := Unit_Declaration (CU);
   Control : Traverse_Control             := Continue;
   State   : Global_Info_Collection_State := Initial_State;
begin
   Gnatsync.Global_Info.Data.Init_Critical_Section_Table;
   Gnatsync.Global_Info.Collect_Global_Info (Unit, Control, State);
   Set_Source_Status (SF, Processed);
exception
   when Fatal_Error =>
      Set_Source_Status (SF, Error_Detected);
   when Ex : others =>
      Report_Unhandled_Exception (Ex);
      Set_Source_Status (SF, Error_Detected);

end ASIS_Processing;
