------------------------------------------------------------------------------
--                                                                          --
--                          GNATCHECK COMPONENTS                            --
--                                                                          --
--              G N A T C H E C K . R U L E S . M E T R I C S               --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                       Copyright (C) 2008, AdaCore                        --
--                                                                          --
-- GNATCHECK  is  free  software;  you can redistribute it and/or modify it --
-- under terms of the  GNU  General Public License as published by the Free --
-- Software Foundation;  either version 2, or ( at your option)  any  later --
-- version.  GNATCHECK  is  distributed in the hope that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;   without  even  the  implied  warranty  of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU  General Public License distributed with GNAT; see file  COPYING. If --
-- not,  write to the  Free Software Foundation,  51 Franklin Street, Fifth --
-- Floor, Boston, MA 02110-1301, USA.                                       --
--                                                                          --
-- GNATCHECK is maintained by AdaCore (http://www.adacore.com).             --
--                                                                          --
------------------------------------------------------------------------------

--  This package defines the top gnatcheck rule based on metrics. The detailed
--  metric-based checks are defined in the child package
--  Gnatcheck.Rules.Metrics.Checks.

package Gnatcheck.Rules.Metrics is

   -----------------------
   -- Metrics_Violation --
   -----------------------

   --  This is an umbrella rule for metric-based checks. The rule parameters
   --  should specify the metric to check and the mimimal (or maximal) value
   --  of this metric to check the metric value against.
   --
   --  The rule has the following parameters:
   --
   --  * For +R option:
   --
   --       Metric_Check_Name > Value
   --       Metric_Check_Name < Value
   --
   --  * For -R option:
   --
   --       Metric_Name
   --
   --    Where:
   --
   --       Metric_Name - a name of metric-specific test (such as
   --                     Cyclomatic_Complexity)
   --
   --       Value       - integer or real literal specifying the minimal or
   --                     maximal allowed value the specified metric value.
   --
   --  If Metric_Name does not denote any implemented metric check, the
   --  corresponding parameter is ignored.
   --
   --  A parameter of +R option specifies the codition the constracts in the
   --  analyzed code should ,meet, If a given metric is applicable to a given
   --  construct, and the metric value does not meet the condition, this
   --  construct is flagged. Whether for a given metric the upper (< Value) or
   --  lower (> Value) limit should be specified, and if the limit should be an
   --  integer or a real number, depends on a metric.
   --
   --  If a metric name is provided as a parameter of -R option, the
   --  corresponding metric check is disabled.
   --
   --  Parameters are not case-sensitive.
   --
   --  Note, that by default all the metric-based checks are OFF, even if +ALL
   --  rule option or +RMetric option without parameters is applied. To enable
   --  a metric-based check, the limit for the metric value should be provided.
   --
   --  -RMetric option without parameters turns off all the metric-specific
   --  tests.
   --
   --  +RMetric option without parameters enables all the metric-specific tests
   --  that have been enabled by previous +RMetric option with parameters and
   --  then disabled by -RMetric option without parameters.

   type Metrics_Violation_Rule_Type is new Rule_Template with null record;

   --  We do not redefine the Pre_ or Post_Operation for this rule - the rule
   --  does not do anything on its own, everything is done by subordinate
   --  metric checking rules.

   procedure Init_Rule (Rule : in out Metrics_Violation_Rule_Type);

   procedure Process_Rule_Parameter
     (Rule    : in out Metrics_Violation_Rule_Type;
      Param   :        String;
      Enable  :        Boolean);
   --  Process the Param string according to the parameter structure described
   --  above

   Metrics_Violation_Rule : aliased Metrics_Violation_Rule_Type;

end Gnatcheck.Rules.Metrics;
