------------------------------------------------------------------------------
--                                                                          --
--                          GNATCHECK COMPONENTS                            --
--                                                                          --
--                  G N A T C H E C K . D I A G N O S E S                   --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                       Copyright (C) 2006, AdaCore                        --
--                                                                          --
-- GNATCHECK  is  free  software;  you can redistribute it and/or modify it --
-- under terms of the  GNU  General Public License as published by the Free --
-- Software Foundation;  either version 2, or ( at your option)  any  later --
-- version.  GNATCHECK  is  distributed in the hope that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;   without  even  the  implied  warranty  of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU  General Public License distributed with GNAT; see file  COPYING. If --
-- not,  write to the  Free Software Foundation,  51 Franklin Street, Fifth --
-- Floor, Boston, MA 02110-1301, USA.                                       --
--                                                                          --
-- GNATCHECK is maintained by AdaCore (http://www.adacore.com).             --
--                                                                          --
------------------------------------------------------------------------------

--  This package defines the diagnostic message database that allows to
--  generate different formats of the gnatcheck reports

with Asis;                       use Asis;

with ASIS_UL.Source_Table;       use ASIS_UL.Source_Table;
with ASIS_UL.Strings;            use ASIS_UL.Strings;

with Gnatcheck.Compiler;         use Gnatcheck.Compiler;
with Gnatcheck.Global_State;     use Gnatcheck.Global_State;
with Gnatcheck.Rules;            use Gnatcheck.Rules;
with Gnatcheck.Rules.Rule_Table; use Gnatcheck.Rules.Rule_Table;

package Gnatcheck.Diagnoses is

   procedure Create_Mapping_Table;
   --  This procedure creates (and initializes by null links) the
   --  File-Rule-Diagnosis Mapping Table for argument files. This table is
   --  needed to create links between diagnoses that allow to print out these
   --  diagnoses in different orders. This procedure should be called after
   --  registering all the rules and processing all the gnatcheck parameters
   --  (when the file table is filled in and we know how many files to process
   --  we have), but before the first call to Store_Rule_Violation routine.
   --  Note, that the call to this routine does not create entries for the
   --  files that are needed by the argument sources, but are not themselves
   --  the argument sources of the gnatcheck call, and
   --  Add_Line_To_Mapping_Table should be called each time we add a new needed
   --  file to the Mapping Table

   procedure Add_Line_To_Mapping_Table;
   --  Adds one line (corresponding to a source file) to the
   --  File-Rule-Diagnosis Mapping Table

   procedure Store_Rule_Violation
     (For_Rule      : Rule_Id;
      On            : Element;
      In_SF         : SF_Id;
      Diagnosis_Num : Diagnosis_Variant := 0;
      Diag_Pars     : String_Loc;
      Element_SLOC  : String_Loc);

   procedure Store_Rule_Violation
     (For_Rule : Rule_Id;
      On       : GS_Node_Id);

   --  These two routines store the information about the rule violation in the
   --  diagnosis table, setting all the links to create the diagnosis chains
   --  needed to create different report formats

   procedure Store_Compiler_Message
     (In_SF        : SF_Id;
      Line_Num     : Natural;
      Col_Num      : Natural;
      Message      : String_Loc;
      Message_Kind : Compiler_Message_Kinds);
   --  Stores the compiler (warning) message in the diagnosis table, setting
   --  all the links to create the diagnosis chains needed to create different
   --  report formats

   procedure Generate_Report;
   --  This procedure is supposed to generate all possible formats of the rule
   --  violation reports. At the moment we do not have any parameter to set or
   --  to control the report formats, and for debug and development reasons,
   --  we generate all possible formats. The name of the output file is
   --  gnatcheck.out, and it is created in the current directory.

   procedure Diag_Structure_Debug_Image;
   --  Generates the debug image of the diagnosis structures

   procedure Process_Report_File_Format_Parameter
     (Parameter :     String;
      Success   : out Boolean);
   --  Processes parameter of '-sxxx' option and modify the corresponding
   --  control flags and variables setting the format of gnatcheck output file.
   --  Sets Success ON if the actual of Parameter represents a correct
   --  parameter setting for '-s' option, and OFF otherwise.

end Gnatcheck.Diagnoses;
