/*
 * This file was automatically generated by EvoSuite
 * Wed Sep 19 22:19:17 GMT 2018
 */

package uk.ac.sanger.artemis.util;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.HeadlessException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import javax.swing.JPasswordField;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.evosuite.runtime.mock.java.net.MockURL;
import org.evosuite.runtime.testdata.EvoSuiteURL;
import org.evosuite.runtime.testdata.NetworkHandling;
import org.junit.runner.RunWith;
import org.postgresql.largeobject.LargeObject;
import uk.ac.sanger.artemis.components.filetree.RemoteFileNode;
import uk.ac.sanger.artemis.util.DatabaseDocument;
import uk.ac.sanger.artemis.util.Document;
import uk.ac.sanger.artemis.util.FileDocument;
import uk.ac.sanger.artemis.util.InputStreamProgressListener;
import uk.ac.sanger.artemis.util.LargeObjectDocument;
import uk.ac.sanger.artemis.util.LinePushBackReader;
import uk.ac.sanger.artemis.util.RemoteFileDocument;
import uk.ac.sanger.artemis.util.TextDocument;
import uk.ac.sanger.artemis.util.URLDocument;
import uk.ac.sanger.artemis.util.ZipFileDocument;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class Document_ESTest extends Document_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      URL uRL0 = MockURL.getHttpExample();
      URLDocument uRLDocument0 = new URLDocument(uRL0);
      uRLDocument0.setLocation(uRL0);
      assertNull(uRL0.getUserInfo());
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      URL uRL0 = MockURL.getFileExample();
      URLDocument uRLDocument0 = new URLDocument(uRL0);
      boolean boolean0 = uRLDocument0.writable();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      URL uRL0 = MockURL.getHttpExample();
      URLDocument uRLDocument0 = new URLDocument(uRL0);
      EvoSuiteURL evoSuiteURL0 = new EvoSuiteURL("http://www.someFakeButWellFormedURL.org");
      NetworkHandling.createRemoteTextFile(evoSuiteURL0, "~DgbB|5g,==3q");
      Document document0 = uRLDocument0.getParent();
      Reader reader0 = document0.getReader();
      assertNotNull(reader0);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      File file0 = MockFile.createTempFile("R),C'=df|lr{&", "R),C'=df|lr{&");
      FileDocument fileDocument0 = new FileDocument(file0);
      Document document0 = fileDocument0.getParent();
      assertNotSame(fileDocument0, document0);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      File file0 = MockFile.createTempFile("Tu}<3$yiTW_ S", "Tu}<3$yiTW_ S");
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(file0, "Tu}<3$yiTW_ S");
      InputStream inputStream0 = zipFileDocument0.getInputStream();
      assertNotNull(inputStream0);
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField("#~&\"M8rlic4<c");
      DatabaseDocument databaseDocument0 = new DatabaseDocument("#~&\"M8rlic4<c", jPasswordField0);
      Document document0 = databaseDocument0.append("#~&\"M8rlic4<c");
      assertNotSame(document0, databaseDocument0);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      TextDocument textDocument0 = new TextDocument();
      // Undeclared exception!
      try { 
        textDocument0.getWriter();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.io.File", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode(false);
      RemoteFileDocument remoteFileDocument0 = new RemoteFileDocument(remoteFileNode0);
      remoteFileDocument0.getOutputStream();
      // Undeclared exception!
      try { 
        remoteFileDocument0.getWriter();
      
      } catch(Exception e) {
    	  	fail("caught exception: " + e.getMessage());
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      MockFile mockFile0 = new MockFile("k#110xfJxC", "F");
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(mockFile0, "k#110xfJxC");
      try { 
        zipFileDocument0.getReader();
        fail("Expecting exception: FileNotFoundException");
      
      } catch(FileNotFoundException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockFileInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField("nq+nDBwgZBK.bES~(%f");
      DatabaseDocument databaseDocument0 = new DatabaseDocument("nq+nDBwgZBK.bES~(%f", jPasswordField0, (String) null, "``CkKUlVu2j>*i", true);
      // Undeclared exception!
      try { 
        databaseDocument0.getOutputStream();
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      LargeObject largeObject0 = mock(LargeObject.class, new ViolatedAssumptionAnswer());
      doReturn((InputStream) null).when(largeObject0).getInputStream();
      LargeObjectDocument largeObjectDocument0 = new LargeObjectDocument("", (String) null, largeObject0);
      // Undeclared exception!
      try { 
        largeObjectDocument0.getLinePushBackReader();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.util.zip.InflaterInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      RemoteFileDocument remoteFileDocument0 = null;
      try {
        remoteFileDocument0 = new RemoteFileDocument((RemoteFileNode) null);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - created a null Document
         //
         verifyException("uk.ac.sanger.artemis.util.Document", e);
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      File file0 = MockFile.createTempFile("os.name", ">)b*Y?]");
      FileDocument fileDocument0 = new FileDocument(file0);
      LinePushBackReader linePushBackReader0 = fileDocument0.getLinePushBackReader();
      assertEquals(0, linePushBackReader0.getLineNumber());
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      URL uRL0 = MockURL.getHttpExample();
      URLDocument uRLDocument0 = new URLDocument(uRL0);
      InputStreamProgressListener inputStreamProgressListener0 = mock(InputStreamProgressListener.class, new ViolatedAssumptionAnswer());
      uRLDocument0.addInputStreamProgressListener(inputStreamProgressListener0);
      assertEquals("fooExample", uRLDocument0.getName());
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField("", 0);
      InputStreamProgressListener inputStreamProgressListener0 = mock(InputStreamProgressListener.class, new ViolatedAssumptionAnswer());
      DatabaseDocument databaseDocument0 = new DatabaseDocument("0r2}/t}u{UU0#H+=[U", jPasswordField0, "P", "", true, inputStreamProgressListener0);
      String string0 = databaseDocument0.toString();
      assertNotNull(string0);
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      RemoteFileNode remoteFileNode0 = new RemoteFileNode(false);
      RemoteFileDocument remoteFileDocument0 = new RemoteFileDocument(remoteFileNode0);
      Writer writer0 = remoteFileDocument0.getWriter();
      assertNotNull(writer0);
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      URL uRL0 = MockURL.getHttpExample();
      URLDocument uRLDocument0 = new URLDocument(uRL0);
      try { 
        uRLDocument0.getReader();
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // Could not find: www.someFakeButWellFormedURL.org
         //
         verifyException("org.evosuite.runtime.mock.java.net.EvoHttpURLConnection", e);
      }
  }
}
