/*
 * This file was automatically generated by EvoSuite
 * Wed Sep 19 18:45:54 GMT 2018
 */

package uk.ac.sanger.artemis.io;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.JPasswordField;
import org.biojava.bio.seq.CircularView;
import org.biojava.bio.seq.FeatureRealizer;
import org.biojava.utils.ChangeListener;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.evosuite.runtime.mock.java.io.MockFileOutputStream;
import org.evosuite.runtime.mock.java.io.MockPrintWriter;
import org.evosuite.runtime.testdata.EvoSuiteFile;
import org.evosuite.runtime.testdata.FileSystemHandling;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.components.LogReadListener;
import uk.ac.sanger.artemis.io.BioJavaEntry;
import uk.ac.sanger.artemis.io.BlastDocumentEntry;
import uk.ac.sanger.artemis.io.BlastEntryInformation;
import uk.ac.sanger.artemis.io.DatabaseDocumentEntry;
import uk.ac.sanger.artemis.io.EmblDocumentEntry;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.Entry;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.GFFDocumentEntry;
import uk.ac.sanger.artemis.io.GenbankDocumentEntry;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.io.IndexFastaStream;
import uk.ac.sanger.artemis.io.IndexedGFFDocumentEntry;
import uk.ac.sanger.artemis.io.LineGroup;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.MSPcrunchDocumentEntry;
import uk.ac.sanger.artemis.io.PartialSequence;
import uk.ac.sanger.artemis.io.PublicDBDocumentEntry;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RangeVector;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.io.ReadListener;
import uk.ac.sanger.artemis.io.SimpleEntryInformation;
import uk.ac.sanger.artemis.io.StreamSequence;
import uk.ac.sanger.artemis.util.DatabaseDocument;
import uk.ac.sanger.artemis.util.Document;
import uk.ac.sanger.artemis.util.FileDocument;
import uk.ac.sanger.artemis.util.InputStreamProgressListener;
import uk.ac.sanger.artemis.util.LinePushBackReader;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class StreamSequence_ESTest extends StreamSequence_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("V6u", "uk.ac.sanger.artemis.io.StreamSequence");
      assertNotNull(fastaStreamSequence0);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      
      char[] charArray0 = new char[1];
      fastaStreamSequence0.appendChar(charArray0);
      assertArrayEquals(new char[] {'\u0000'}, charArray0);
      assertEquals(1, charArray0.length);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(4, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      
      fastaStreamSequence0.forceReset();
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(4, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      
      char[] charArray1 = new char[2];
      assertFalse(charArray1.equals((Object)charArray0));
      
      fastaStreamSequence0.setCounts();
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(4, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      
      charArray1[0] = ')';
      charArray1[1] = 'a';
      fastaStreamSequence0.appendChar(charArray1);
      assertNotSame(charArray1, charArray0);
      assertArrayEquals(new char[] {')', 'a'}, charArray1);
      assertFalse(charArray1.equals((Object)charArray0));
      assertEquals(2, charArray1.length);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.length());
      
      FastaStreamSequence fastaStreamSequence1 = new FastaStreamSequence("uk.ac.sanger.artemis.io.StreamSequence");
      assertFalse(fastaStreamSequence1.equals((Object)fastaStreamSequence0));
      assertNotNull(fastaStreamSequence1);
      assertEquals(4, fastaStreamSequence1.getACount());
      assertEquals(1, fastaStreamSequence1.getGCount());
      assertEquals(38, fastaStreamSequence1.length());
      assertEquals(4, fastaStreamSequence1.getFormatType());
      assertEquals(2, fastaStreamSequence1.getCCount());
      assertEquals(29, fastaStreamSequence1.getOtherCount());
      assertEquals(2, fastaStreamSequence1.getTCount());
      
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence(fastaStreamSequence0);
      assertFalse(fastaStreamSequence0.equals((Object)fastaStreamSequence1));
      assertNotNull(emblStreamSequence0);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(5, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(6, emblStreamSequence0.length());
      
      int int0 = emblStreamSequence0.getFormatType();
      assertNotSame(fastaStreamSequence0, fastaStreamSequence1);
      assertEquals(1, int0);
      assertFalse(fastaStreamSequence0.equals((Object)fastaStreamSequence1));
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(5, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(6, emblStreamSequence0.length());
      
      StringWriter stringWriter0 = new StringWriter(1);
      assertNotNull(stringWriter0);
      assertEquals("", stringWriter0.toString());
      
      StringWriter stringWriter1 = stringWriter0.append('.');
      assertSame(stringWriter0, stringWriter1);
      assertSame(stringWriter1, stringWriter0);
      assertNotNull(stringWriter1);
      assertEquals(".", stringWriter0.toString());
      assertEquals(".", stringWriter1.toString());
      
      StringWriter stringWriter2 = stringWriter1.append((CharSequence) "V6u");
      assertSame(stringWriter0, stringWriter1);
      assertSame(stringWriter0, stringWriter2);
      assertSame(stringWriter1, stringWriter2);
      assertSame(stringWriter1, stringWriter0);
      assertSame(stringWriter2, stringWriter1);
      assertSame(stringWriter2, stringWriter0);
      assertNotNull(stringWriter2);
      assertEquals(".V6u", stringWriter0.toString());
      assertEquals(".V6u", stringWriter1.toString());
      assertEquals(".V6u", stringWriter2.toString());
      
      fastaStreamSequence0.writeToStream(stringWriter2);
      assertNotSame(fastaStreamSequence0, fastaStreamSequence1);
      assertSame(stringWriter0, stringWriter1);
      assertSame(stringWriter0, stringWriter2);
      assertSame(stringWriter1, stringWriter2);
      assertSame(stringWriter1, stringWriter0);
      assertSame(stringWriter2, stringWriter1);
      assertSame(stringWriter2, stringWriter0);
      assertFalse(fastaStreamSequence0.equals((Object)fastaStreamSequence1));
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(".V6u>uk.ac.sanger.artemis.io.StreamSequence\nnnunna\n", stringWriter0.toString());
      assertEquals(".V6u>uk.ac.sanger.artemis.io.StreamSequence\nnnunna\n", stringWriter1.toString());
      assertEquals(".V6u>uk.ac.sanger.artemis.io.StreamSequence\nnnunna\n", stringWriter2.toString());
      
      char char0 = fastaStreamSequence1.charAt(22);
      assertNotSame(fastaStreamSequence1, fastaStreamSequence0);
      assertEquals('n', char0);
      assertFalse(fastaStreamSequence1.equals((Object)fastaStreamSequence0));
      assertEquals(4, fastaStreamSequence1.getACount());
      assertEquals(1, fastaStreamSequence1.getGCount());
      assertEquals(38, fastaStreamSequence1.length());
      assertEquals(4, fastaStreamSequence1.getFormatType());
      assertEquals(2, fastaStreamSequence1.getCCount());
      assertEquals(29, fastaStreamSequence1.getOtherCount());
      assertEquals(2, fastaStreamSequence1.getTCount());
      
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      assertNotNull(blastEntryInformation0);
      assertFalse(blastEntryInformation0.useEMBLFormat());
      
      File file0 = MockFile.createTempFile("\u0001Jp2D#|x8%L`", "$U08&=0");
      assertNotNull(file0);
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.length());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.canWrite());
      assertFalse(file0.isHidden());
      assertTrue(file0.canExecute());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canRead());
      assertTrue(file0.isFile());
      assertEquals("\u0001Jp2D#|x8%L`0$U08&=0", file0.getName());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/\u0001Jp2D#|x8%L`0$U08&=0", file0.toString());
      assertTrue(file0.exists());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      
      MockFile mockFile0 = new MockFile(file0, "uk.ac.sanger.artemis.io.StreamSequence");
      assertFalse(mockFile0.equals((Object)file0));
      assertNotNull(mockFile0);
      
      FileDocument fileDocument0 = new FileDocument(mockFile0);
      assertFalse(file0.equals((Object)mockFile0));
      assertFalse(mockFile0.equals((Object)file0));
      assertNotNull(fileDocument0);
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.length());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.canWrite());
      assertFalse(file0.isHidden());
      assertTrue(file0.canExecute());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canRead());
      assertTrue(file0.isFile());
      assertEquals("\u0001Jp2D#|x8%L`0$U08&=0", file0.getName());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/\u0001Jp2D#|x8%L`0$U08&=0", file0.toString());
      assertTrue(file0.exists());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(0L, mockFile0.getUsableSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/\u0001Jp2D#|x8%L`0$U08&=0/uk.ac.sanger.artemis.io.StreamSequence", mockFile0.toString());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/\u0001Jp2D#|x8%L`0$U08&=0", mockFile0.getParent());
      assertFalse(mockFile0.isHidden());
      assertTrue(mockFile0.isAbsolute());
      assertFalse(mockFile0.canWrite());
      assertFalse(mockFile0.isDirectory());
      assertEquals(0L, mockFile0.lastModified());
      assertEquals(0L, mockFile0.length());
      assertEquals(0L, mockFile0.getFreeSpace());
      assertFalse(mockFile0.canExecute());
      assertEquals("uk.ac.sanger.artemis.io.StreamSequence", mockFile0.getName());
      assertEquals(0L, mockFile0.getTotalSpace());
      assertFalse(mockFile0.exists());
      assertTrue(mockFile0.isFile());
      assertFalse(mockFile0.canRead());
      assertFalse(fileDocument0.writable());
      assertEquals("uk.ac.sanger.artemis.io.StreamSequence", fileDocument0.getName());
      
      Document document0 = fileDocument0.append("fZ^");
      assertNotSame(file0, mockFile0);
      assertNotSame(mockFile0, file0);
      assertNotSame(fileDocument0, document0);
      assertNotSame(document0, fileDocument0);
      assertFalse(file0.equals((Object)mockFile0));
      assertFalse(mockFile0.equals((Object)file0));
      assertFalse(document0.equals((Object)fileDocument0));
      assertNotNull(document0);
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.length());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.canWrite());
      assertFalse(file0.isHidden());
      assertTrue(file0.canExecute());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.canRead());
      assertTrue(file0.isFile());
      assertEquals("\u0001Jp2D#|x8%L`0$U08&=0", file0.getName());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/\u0001Jp2D#|x8%L`0$U08&=0", file0.toString());
      assertTrue(file0.exists());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(0L, mockFile0.getUsableSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/\u0001Jp2D#|x8%L`0$U08&=0/uk.ac.sanger.artemis.io.StreamSequence", mockFile0.toString());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/\u0001Jp2D#|x8%L`0$U08&=0", mockFile0.getParent());
      assertFalse(mockFile0.isHidden());
      assertTrue(mockFile0.isAbsolute());
      assertFalse(mockFile0.canWrite());
      assertFalse(mockFile0.isDirectory());
      assertEquals(0L, mockFile0.lastModified());
      assertEquals(0L, mockFile0.length());
      assertEquals(0L, mockFile0.getFreeSpace());
      assertFalse(mockFile0.canExecute());
      assertEquals("uk.ac.sanger.artemis.io.StreamSequence", mockFile0.getName());
      assertEquals(0L, mockFile0.getTotalSpace());
      assertFalse(mockFile0.exists());
      assertTrue(mockFile0.isFile());
      assertFalse(mockFile0.canRead());
      assertFalse(fileDocument0.writable());
      assertEquals("uk.ac.sanger.artemis.io.StreamSequence", fileDocument0.getName());
      assertEquals("fZ^", document0.getName());
      assertFalse(document0.writable());
      
      LogReadListener logReadListener0 = new LogReadListener("YZW01.}m");
      assertNotNull(logReadListener0);
      assertFalse(logReadListener0.seenMessage());
      
      PublicDBDocumentEntry publicDBDocumentEntry0 = null;
      try {
        publicDBDocumentEntry0 = new PublicDBDocumentEntry(blastEntryInformation0, document0, logReadListener0);
        fail("Expecting exception: FileNotFoundException");
      
      } catch(Throwable e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockFileInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      String string0 = "";
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      assertNotNull(genbankStreamSequence0);
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      
      FileSystemHandling fileSystemHandling0 = new FileSystemHandling();
      assertNotNull(fileSystemHandling0);
      
      int int0 = (-11);
      // Undeclared exception!
      try { 
        genbankStreamSequence0.getCharSubSequence((-11), (-11));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // -6
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      String string0 = "Ob:*f%";
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("Ob:*f%");
      assertNotNull(genbankStreamSequence0);
      assertEquals(6, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(6, genbankStreamSequence0.getOtherCount());
      
      genbankStreamSequence0.forceReset();
      assertEquals(6, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(6, genbankStreamSequence0.getOtherCount());
      
      int int0 = genbankStreamSequence0.length();
      assertEquals(6, int0);
      assertEquals(6, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(6, genbankStreamSequence0.getOtherCount());
      
      StringReader stringReader0 = new StringReader("Ob:*f%");
      assertNotNull(stringReader0);
      
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(stringReader0);
      assertNotNull(linePushBackReader0);
      assertEquals(0, linePushBackReader0.getLineNumber());
      
      try { 
        genbankStreamSequence0.readHeader(linePushBackReader0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // Genbank sequence data should begin with \"BASE COUNT\" or \"ORIGIN\"
         //
         verifyException("uk.ac.sanger.artemis.io.GenbankStreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      String string0 = "ip(H,h";
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("ip(H,h");
      assertNotNull(genbankStreamSequence0);
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(6, genbankStreamSequence0.length());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(6, genbankStreamSequence0.getOtherCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      
      GenbankStreamSequence genbankStreamSequence1 = new GenbankStreamSequence("ip(H,h");
      assertFalse(genbankStreamSequence1.equals((Object)genbankStreamSequence0));
      assertNotNull(genbankStreamSequence1);
      assertEquals(6, genbankStreamSequence1.getOtherCount());
      assertEquals(2, genbankStreamSequence1.getFormatType());
      assertEquals(0, genbankStreamSequence1.getGCount());
      assertEquals(0, genbankStreamSequence1.getTCount());
      assertNull(genbankStreamSequence1.getHeader());
      assertEquals(0, genbankStreamSequence1.getACount());
      assertEquals(0, genbankStreamSequence1.getCCount());
      assertEquals(6, genbankStreamSequence1.length());
      
      char[] charArray0 = new char[7];
      genbankStreamSequence0.setFromChar(charArray0);
      assertNotSame(genbankStreamSequence0, genbankStreamSequence1);
      assertArrayEquals(new char[] {'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'}, charArray0);
      assertFalse(genbankStreamSequence0.equals((Object)genbankStreamSequence1));
      assertEquals(7, charArray0.length);
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(7, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(7, genbankStreamSequence0.getOtherCount());
      
      genbankStreamSequence1.forceReset();
      assertNotSame(genbankStreamSequence1, genbankStreamSequence0);
      assertFalse(genbankStreamSequence1.equals((Object)genbankStreamSequence0));
      assertEquals(6, genbankStreamSequence1.getOtherCount());
      assertEquals(2, genbankStreamSequence1.getFormatType());
      assertEquals(0, genbankStreamSequence1.getGCount());
      assertEquals(0, genbankStreamSequence1.getTCount());
      assertNull(genbankStreamSequence1.getHeader());
      assertEquals(0, genbankStreamSequence1.getACount());
      assertEquals(0, genbankStreamSequence1.getCCount());
      assertEquals(6, genbankStreamSequence1.length());
      
      charArray0[1] = 'g';
      charArray0[2] = '{';
      charArray0[3] = '$';
      charArray0[4] = 'B';
      charArray0[5] = '6';
      charArray0[6] = 'S';
      genbankStreamSequence1.appendChar(charArray0);
      assertNotSame(genbankStreamSequence1, genbankStreamSequence0);
      assertArrayEquals(new char[] {'\u0000', 'g', '{', '$', 'B', '6', 'S'}, charArray0);
      assertFalse(genbankStreamSequence1.equals((Object)genbankStreamSequence0));
      assertEquals(7, charArray0.length);
      assertEquals(2, genbankStreamSequence1.getFormatType());
      assertEquals(13, genbankStreamSequence1.length());
      assertEquals(0, genbankStreamSequence1.getGCount());
      assertEquals(0, genbankStreamSequence1.getTCount());
      assertNull(genbankStreamSequence1.getHeader());
      assertEquals(0, genbankStreamSequence1.getACount());
      assertEquals(0, genbankStreamSequence1.getCCount());
      assertEquals(13, genbankStreamSequence1.getOtherCount());
      
      GenbankStreamSequence genbankStreamSequence2 = (GenbankStreamSequence)genbankStreamSequence1.copy();
      assertNotSame(genbankStreamSequence1, genbankStreamSequence2);
      assertNotSame(genbankStreamSequence1, genbankStreamSequence0);
      assertNotSame(genbankStreamSequence2, genbankStreamSequence0);
      assertNotSame(genbankStreamSequence2, genbankStreamSequence1);
      assertFalse(genbankStreamSequence1.equals((Object)genbankStreamSequence0));
      assertFalse(genbankStreamSequence2.equals((Object)genbankStreamSequence0));
      assertFalse(genbankStreamSequence2.equals((Object)genbankStreamSequence1));
      assertNotNull(genbankStreamSequence2);
      assertEquals(2, genbankStreamSequence1.getFormatType());
      assertEquals(13, genbankStreamSequence1.length());
      assertEquals(0, genbankStreamSequence1.getGCount());
      assertEquals(0, genbankStreamSequence1.getTCount());
      assertNull(genbankStreamSequence1.getHeader());
      assertEquals(0, genbankStreamSequence1.getACount());
      assertEquals(0, genbankStreamSequence1.getCCount());
      assertEquals(13, genbankStreamSequence1.getOtherCount());
      assertEquals(12, genbankStreamSequence2.getOtherCount());
      assertNull(genbankStreamSequence2.getHeader());
      assertEquals(0, genbankStreamSequence2.getCCount());
      assertEquals(0, genbankStreamSequence2.getTCount());
      assertEquals(0, genbankStreamSequence2.getACount());
      assertEquals(13, genbankStreamSequence2.length());
      assertEquals(2, genbankStreamSequence2.getFormatType());
      assertEquals(1, genbankStreamSequence2.getGCount());
      
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("ip(H,h");
      assertNotNull(emblStreamSequence0);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(6, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(6, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getTCount());
      
      StringReader stringReader0 = new StringReader("ip(H,h");
      assertNotNull(stringReader0);
      
      boolean boolean0 = stringReader0.ready();
      assertTrue(boolean0);
      
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(stringReader0);
      assertNotNull(linePushBackReader0);
      assertEquals(0, linePushBackReader0.getLineNumber());
      
      EntryInformation entryInformation0 = null;
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry((EntryInformation) null);
      assertNotNull(mSPcrunchDocumentEntry0);
      assertTrue(mSPcrunchDocumentEntry0.isReadOnly());
      
      PublicDBDocumentEntry publicDBDocumentEntry0 = null;
      try {
        publicDBDocumentEntry0 = new PublicDBDocumentEntry((EntryInformation) null, mSPcrunchDocumentEntry0, true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.SimpleEntryInformation", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      Document document0 = mock(Document.class, new ViolatedAssumptionAnswer());
      ReadListener readListener0 = mock(ReadListener.class, new ViolatedAssumptionAnswer());
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("uk.ac.sanger.artemis.io.StreamSequence");
      assertNotNull(emblStreamSequence0);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(4, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(2, emblStreamSequence0.getCCount());
      assertEquals(2, emblStreamSequence0.getTCount());
      assertEquals(38, emblStreamSequence0.length());
      assertEquals(29, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      
      EmblStreamSequence emblStreamSequence1 = (EmblStreamSequence)emblStreamSequence0.copy();
      assertNotSame(emblStreamSequence0, emblStreamSequence1);
      assertNotSame(emblStreamSequence1, emblStreamSequence0);
      assertFalse(emblStreamSequence1.equals((Object)emblStreamSequence0));
      assertNotNull(emblStreamSequence1);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(4, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(2, emblStreamSequence0.getCCount());
      assertEquals(2, emblStreamSequence0.getTCount());
      assertEquals(38, emblStreamSequence0.length());
      assertEquals(29, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(4, emblStreamSequence1.getACount());
      assertEquals(1, emblStreamSequence1.getGCount());
      assertEquals(38, emblStreamSequence1.length());
      assertEquals(2, emblStreamSequence1.getCCount());
      assertNull(emblStreamSequence1.getHeader());
      assertEquals(1, emblStreamSequence1.getFormatType());
      assertEquals(2, emblStreamSequence1.getTCount());
      assertEquals(29, emblStreamSequence1.getOtherCount());
      
      int int0 = emblStreamSequence1.getOtherCount();
      assertNotSame(emblStreamSequence0, emblStreamSequence1);
      assertNotSame(emblStreamSequence1, emblStreamSequence0);
      assertEquals(29, int0);
      assertFalse(emblStreamSequence0.equals((Object)emblStreamSequence1));
      assertFalse(emblStreamSequence1.equals((Object)emblStreamSequence0));
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(4, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(2, emblStreamSequence0.getCCount());
      assertEquals(2, emblStreamSequence0.getTCount());
      assertEquals(38, emblStreamSequence0.length());
      assertEquals(29, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(4, emblStreamSequence1.getACount());
      assertEquals(1, emblStreamSequence1.getGCount());
      assertEquals(38, emblStreamSequence1.length());
      assertEquals(2, emblStreamSequence1.getCCount());
      assertNull(emblStreamSequence1.getHeader());
      assertEquals(1, emblStreamSequence1.getFormatType());
      assertEquals(2, emblStreamSequence1.getTCount());
      assertEquals(29, emblStreamSequence1.getOtherCount());
      
      DatabaseDocumentEntry databaseDocumentEntry0 = null;
      try {
        databaseDocumentEntry0 = new DatabaseDocumentEntry(document0, readListener0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.util.Properties$LineReader", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("uk.ac.sanger.artemis.io.StreamSequence");
      assertNotNull(genbankStreamSequence0);
      assertEquals(2, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(2, genbankStreamSequence0.getTCount());
      assertEquals(29, genbankStreamSequence0.getOtherCount());
      assertEquals(38, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(4, genbankStreamSequence0.getACount());
      assertEquals(1, genbankStreamSequence0.getGCount());
      
      genbankStreamSequence0.setCounts();
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(4, genbankStreamSequence0.getCCount());
      assertEquals(4, genbankStreamSequence0.getTCount());
      assertEquals(38, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(2, genbankStreamSequence0.getGCount());
      assertEquals(20, genbankStreamSequence0.getOtherCount());
      assertEquals(8, genbankStreamSequence0.getACount());
      
      char[] charArray0 = new char[9];
      charArray0[0] = '~';
      charArray0[1] = '}';
      charArray0[2] = '2';
      charArray0[3] = '8';
      charArray0[4] = 'N';
      charArray0[5] = 'M';
      charArray0[6] = '_';
      charArray0[7] = 'l';
      charArray0[8] = 'P';
      genbankStreamSequence0.setFromChar(charArray0);
      assertArrayEquals(new char[] {'~', '}', '2', '8', 'N', 'M', '_', 'l', 'P'}, charArray0);
      assertEquals(9, charArray0.length);
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(9, genbankStreamSequence0.length());
      assertEquals(9, genbankStreamSequence0.getOtherCount());
      
      StringReader stringReader0 = new StringReader("org.biojava.bio.seq.SimpleAssembly");
      assertNotNull(stringReader0);
      
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(stringReader0);
      assertNotNull(linePushBackReader0);
      assertEquals(0, linePushBackReader0.getLineNumber());
      
      char[] charArray1 = genbankStreamSequence0.getCharSequence();
      assertNotSame(charArray1, charArray0);
      assertArrayEquals(new char[] {'n', 'n', 'n', 'n', 'n', 'n', 'n', 'n', 'n'}, charArray1);
      assertFalse(charArray1.equals((Object)charArray0));
      assertEquals(9, charArray1.length);
      assertNotNull(charArray1);
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(9, genbankStreamSequence0.length());
      assertEquals(9, genbankStreamSequence0.getOtherCount());
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      String string0 = "V6u";
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("V6u", "uk.ac.sanger.artemis.io.StreamSequence");
      assertNotNull(fastaStreamSequence0);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      
      char[] charArray0 = new char[1];
      charArray0[0] = 'B';
      fastaStreamSequence0.forceReset();
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      
      char[] charArray1 = new char[2];
      assertFalse(charArray1.equals((Object)charArray0));
      
      fastaStreamSequence0.setCounts();
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      
      charArray1[0] = ')';
      charArray1[1] = 'a';
      fastaStreamSequence0.appendChar(charArray1);
      assertNotSame(charArray1, charArray0);
      assertArrayEquals(new char[] {')', 'a'}, charArray1);
      assertFalse(charArray1.equals((Object)charArray0));
      assertEquals(2, charArray1.length);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(5, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(5, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      
      // Undeclared exception!
      try { 
        fastaStreamSequence0.copy();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.RawStreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence(",SwM:)");
      assertNotNull(rawStreamSequence0);
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(6, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(6, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      
      int int0 = (-1431);
      char[] charArray0 = new char[2];
      charArray0[0] = 'a';
      charArray0[1] = 'I';
      rawStreamSequence0.appendChar(charArray0);
      assertArrayEquals(new char[] {'a', 'I'}, charArray0);
      assertEquals(2, charArray0.length);
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(8, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(8, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      
      // Undeclared exception!
      try { 
        rawStreamSequence0.getSubSequence((-1431), 97);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // -716
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("4L)Sc7pYYCGFa?8gpF", "4L)Sc7pYYCGFa?8gpF");
      assertNotNull(fastaStreamSequence0);
      assertEquals(1, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(1, fastaStreamSequence0.getACount());
      assertEquals(15, fastaStreamSequence0.getOtherCount());
      assertEquals(18, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      
      fastaStreamSequence0.setCounts();
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(2, fastaStreamSequence0.getGCount());
      assertEquals(2, fastaStreamSequence0.getCCount());
      assertEquals(2, fastaStreamSequence0.getACount());
      assertEquals(18, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(12, fastaStreamSequence0.getOtherCount());
      
      int int0 = fastaStreamSequence0.getFormatType();
      assertEquals(4, int0);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(2, fastaStreamSequence0.getGCount());
      assertEquals(2, fastaStreamSequence0.getCCount());
      assertEquals(2, fastaStreamSequence0.getACount());
      assertEquals(18, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(12, fastaStreamSequence0.getOtherCount());
      
      int int1 = fastaStreamSequence0.getACount();
      assertEquals(2, int1);
      assertFalse(int1 == int0);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(2, fastaStreamSequence0.getGCount());
      assertEquals(2, fastaStreamSequence0.getCCount());
      assertEquals(2, fastaStreamSequence0.getACount());
      assertEquals(18, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(12, fastaStreamSequence0.getOtherCount());
      
      LinePushBackReader linePushBackReader0 = null;
      GenbankStreamSequence genbankStreamSequence0 = null;
      try {
        genbankStreamSequence0 = new GenbankStreamSequence((LinePushBackReader) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.GenbankStreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      String string0 = "";
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      assertNotNull(genbankStreamSequence0);
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getTCount());
      
      GenbankStreamSequence genbankStreamSequence1 = (GenbankStreamSequence)genbankStreamSequence0.copy();
      assertNotSame(genbankStreamSequence0, genbankStreamSequence1);
      assertNotSame(genbankStreamSequence1, genbankStreamSequence0);
      assertFalse(genbankStreamSequence1.equals((Object)genbankStreamSequence0));
      assertNotNull(genbankStreamSequence1);
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence1.getCCount());
      assertEquals(0, genbankStreamSequence1.length());
      assertNull(genbankStreamSequence1.getHeader());
      assertEquals(0, genbankStreamSequence1.getOtherCount());
      assertEquals(0, genbankStreamSequence1.getACount());
      assertEquals(0, genbankStreamSequence1.getGCount());
      assertEquals(0, genbankStreamSequence1.getTCount());
      assertEquals(2, genbankStreamSequence1.getFormatType());
      
      char[] charArray0 = genbankStreamSequence1.getCharSequence();
      assertNotSame(genbankStreamSequence0, genbankStreamSequence1);
      assertNotSame(genbankStreamSequence1, genbankStreamSequence0);
      assertArrayEquals(new char[] {}, charArray0);
      assertFalse(genbankStreamSequence0.equals((Object)genbankStreamSequence1));
      assertFalse(genbankStreamSequence1.equals((Object)genbankStreamSequence0));
      assertEquals(0, charArray0.length);
      assertNotNull(charArray0);
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence1.getCCount());
      assertEquals(0, genbankStreamSequence1.length());
      assertNull(genbankStreamSequence1.getHeader());
      assertEquals(0, genbankStreamSequence1.getOtherCount());
      assertEquals(0, genbankStreamSequence1.getACount());
      assertEquals(0, genbankStreamSequence1.getGCount());
      assertEquals(0, genbankStreamSequence1.getTCount());
      assertEquals(2, genbankStreamSequence1.getFormatType());
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence(".oPkI{", "");
      assertNotNull(fastaStreamSequence0);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      
      fastaStreamSequence0.appendChar(charArray0);
      assertNotSame(genbankStreamSequence0, genbankStreamSequence1);
      assertNotSame(genbankStreamSequence1, genbankStreamSequence0);
      assertArrayEquals(new char[] {}, charArray0);
      assertFalse(genbankStreamSequence0.equals((Object)genbankStreamSequence1));
      assertFalse(genbankStreamSequence1.equals((Object)genbankStreamSequence0));
      assertEquals(0, charArray0.length);
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence1.getCCount());
      assertEquals(0, genbankStreamSequence1.length());
      assertNull(genbankStreamSequence1.getHeader());
      assertEquals(0, genbankStreamSequence1.getOtherCount());
      assertEquals(0, genbankStreamSequence1.getACount());
      assertEquals(0, genbankStreamSequence1.getGCount());
      assertEquals(0, genbankStreamSequence1.getTCount());
      assertEquals(2, genbankStreamSequence1.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      
      int int0 = fastaStreamSequence0.getFormatType();
      assertEquals(4, int0);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      
      int int1 = LineGroup.getLineType("NJ~#'c]m+iY<T(iT");
      assertEquals(2, int1);
      assertFalse(int1 == int0);
      
      fastaStreamSequence0.setFastaHeaderPositionsOnReverseComplement((RangeVector) null);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      
      String string1 = fastaStreamSequence0.getSubSequence(2, 991);
      assertEquals("nnknn", string1);
      assertFalse(string1.equals((Object)string0));
      assertNotNull(string1);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      
      LinePushBackReader linePushBackReader0 = null;
      try {
        linePushBackReader0 = new LinePushBackReader((Reader) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.io.Reader", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("&21w;q");
      assertNotNull(emblStreamSequence0);
      assertEquals(0, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(6, emblStreamSequence0.length());
      assertEquals(6, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      
      EmblStreamSequence emblStreamSequence1 = new EmblStreamSequence(emblStreamSequence0);
      assertFalse(emblStreamSequence1.equals((Object)emblStreamSequence0));
      assertNotNull(emblStreamSequence1);
      assertEquals(0, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(6, emblStreamSequence0.length());
      assertEquals(6, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertNull(emblStreamSequence1.getHeader());
      assertEquals(6, emblStreamSequence1.getOtherCount());
      assertEquals(0, emblStreamSequence1.getCCount());
      assertEquals(6, emblStreamSequence1.length());
      assertEquals(1, emblStreamSequence1.getFormatType());
      assertEquals(0, emblStreamSequence1.getACount());
      assertEquals(0, emblStreamSequence1.getGCount());
      assertEquals(0, emblStreamSequence1.getTCount());
      
      char[] charArray0 = emblStreamSequence1.getCharSequence();
      assertNotSame(emblStreamSequence0, emblStreamSequence1);
      assertNotSame(emblStreamSequence1, emblStreamSequence0);
      assertArrayEquals(new char[] {'n', 'n', 'n', 'w', 'n', 'n'}, charArray0);
      assertFalse(emblStreamSequence0.equals((Object)emblStreamSequence1));
      assertFalse(emblStreamSequence1.equals((Object)emblStreamSequence0));
      assertEquals(6, charArray0.length);
      assertNotNull(charArray0);
      assertEquals(0, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(6, emblStreamSequence0.length());
      assertEquals(6, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertNull(emblStreamSequence1.getHeader());
      assertEquals(6, emblStreamSequence1.getOtherCount());
      assertEquals(0, emblStreamSequence1.getCCount());
      assertEquals(6, emblStreamSequence1.length());
      assertEquals(1, emblStreamSequence1.getFormatType());
      assertEquals(0, emblStreamSequence1.getACount());
      assertEquals(0, emblStreamSequence1.getGCount());
      assertEquals(0, emblStreamSequence1.getTCount());
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      assertNotNull(genbankStreamSequence0);
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.length());
      
      GenbankStreamSequence genbankStreamSequence1 = new GenbankStreamSequence(genbankStreamSequence0);
      assertFalse(genbankStreamSequence1.equals((Object)genbankStreamSequence0));
      assertNotNull(genbankStreamSequence1);
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence1.getCCount());
      assertNull(genbankStreamSequence1.getHeader());
      assertEquals(0, genbankStreamSequence1.getTCount());
      assertEquals(0, genbankStreamSequence1.getACount());
      assertEquals(0, genbankStreamSequence1.getGCount());
      assertEquals(2, genbankStreamSequence1.getFormatType());
      assertEquals(0, genbankStreamSequence1.getOtherCount());
      assertEquals(0, genbankStreamSequence1.length());
      
      genbankStreamSequence0.setHeader("uk.ac.sanger.artemis.io.StreamSequence");
      assertNotSame(genbankStreamSequence0, genbankStreamSequence1);
      assertFalse(genbankStreamSequence0.equals((Object)genbankStreamSequence1));
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals("uk.ac.sanger.artemis.io.StreamSequence", genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.length());
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence(genbankStreamSequence1);
      assertFalse(genbankStreamSequence0.equals((Object)genbankStreamSequence1));
      assertFalse(genbankStreamSequence1.equals((Object)genbankStreamSequence0));
      assertNotNull(fastaStreamSequence0);
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals("uk.ac.sanger.artemis.io.StreamSequence", genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence1.getCCount());
      assertNull(genbankStreamSequence1.getHeader());
      assertEquals(0, genbankStreamSequence1.getTCount());
      assertEquals(0, genbankStreamSequence1.getACount());
      assertEquals(0, genbankStreamSequence1.getGCount());
      assertEquals(2, genbankStreamSequence1.getFormatType());
      assertEquals(0, genbankStreamSequence1.getOtherCount());
      assertEquals(0, genbankStreamSequence1.length());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      
      char[] charArray0 = new char[5];
      charArray0[0] = 'l';
      charArray0[1] = 'E';
      // Undeclared exception!
      try { 
        fastaStreamSequence0.getSubSequence(97, 97);
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      String string0 = "";
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      assertNotNull(genbankStreamSequence0);
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.length());
      
      int int0 = 101;
      char[] charArray0 = genbankStreamSequence0.getCharSubSequence(101, 101);
      assertArrayEquals(new char[] {'\u0000'}, charArray0);
      assertEquals(1, charArray0.length);
      assertNotNull(charArray0);
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.length());
      
      DatabaseDocumentEntry databaseDocumentEntry0 = null;
      try {
        databaseDocumentEntry0 = new DatabaseDocumentEntry();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.util.Properties$LineReader", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      StringReader stringReader0 = new StringReader(",WW1hCL[ kW^k");
      assertNotNull(stringReader0);
      
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(stringReader0);
      assertNotNull(linePushBackReader0);
      assertEquals(0, linePushBackReader0.getLineNumber());
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence(linePushBackReader0);
      assertNotNull(fastaStreamSequence0);
      assertEquals(1, linePushBackReader0.getLineNumber());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      
      // Undeclared exception!
      try { 
        fastaStreamSequence0.appendChar((char[]) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("");
      assertNotNull(rawStreamSequence0);
      assertEquals(0, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getGCount());
      
      char[] charArray0 = new char[9];
      charArray0[0] = '^';
      charArray0[1] = '%';
      charArray0[2] = '3';
      charArray0[3] = '+';
      charArray0[4] = 'k';
      charArray0[5] = 'C';
      charArray0[6] = '';
      charArray0[7] = 'M';
      charArray0[8] = 'W';
      rawStreamSequence0.appendChar(charArray0);
      assertArrayEquals(new char[] {'^', '%', '3', '+', 'k', 'C', '', 'M', 'W'}, charArray0);
      assertEquals(9, charArray0.length);
      assertEquals(9, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(9, rawStreamSequence0.length());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getGCount());
      
      // Undeclared exception!
      try { 
        rawStreamSequence0.copy();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.RawStreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      String string0 = "],IG@< y";
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("],IG@< y");
      assertNotNull(genbankStreamSequence0);
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(8, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(8, genbankStreamSequence0.getOtherCount());
      
      int int0 = (-1954);
      int int1 = 4271;
      // Undeclared exception!
      try { 
        genbankStreamSequence0.getCharSubSequence((-1954), 4271);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // -978
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      String string0 = "";
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("");
      assertNotNull(emblStreamSequence0);
      assertEquals(0, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getOtherCount());
      
      int int0 = emblStreamSequence0.length();
      assertEquals(0, int0);
      assertEquals(0, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getOtherCount());
      
      StringWriter stringWriter0 = new StringWriter(0);
      assertNotNull(stringWriter0);
      assertEquals("", stringWriter0.toString());
      
      char char0 = '\\';
      // Undeclared exception!
      try { 
        stringWriter0.append((CharSequence) "", 1716, (-844));
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("");
      assertNotNull(emblStreamSequence0);
      assertEquals(0, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.length());
      
      char[] charArray0 = new char[3];
      charArray0[0] = 'o';
      charArray0[1] = '%';
      charArray0[2] = '*';
      emblStreamSequence0.appendChar(charArray0);
      assertArrayEquals(new char[] {'o', '%', '*'}, charArray0);
      assertEquals(3, charArray0.length);
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(3, emblStreamSequence0.getOtherCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(3, emblStreamSequence0.length());
      
      StringReader stringReader0 = new StringReader("");
      assertNotNull(stringReader0);
      
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(stringReader0);
      assertNotNull(linePushBackReader0);
      assertEquals(0, linePushBackReader0.getLineNumber());
      
      StringWriter stringWriter0 = null;
      try {
        stringWriter0 = new StringWriter((-2792));
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // Negative buffer size
         //
         verifyException("java.io.StringWriter", e);
      }
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("");
      assertNotNull(emblStreamSequence0);
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getOtherCount());
      
      EmblStreamSequence emblStreamSequence1 = (EmblStreamSequence)emblStreamSequence0.copy();
      assertNotSame(emblStreamSequence0, emblStreamSequence1);
      assertNotSame(emblStreamSequence1, emblStreamSequence0);
      assertFalse(emblStreamSequence1.equals((Object)emblStreamSequence0));
      assertNotNull(emblStreamSequence1);
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence1.getFormatType());
      assertEquals(0, emblStreamSequence1.getACount());
      assertEquals(0, emblStreamSequence1.getOtherCount());
      assertEquals(0, emblStreamSequence1.getCCount());
      assertEquals(0, emblStreamSequence1.getTCount());
      assertEquals(0, emblStreamSequence1.length());
      assertEquals(0, emblStreamSequence1.getGCount());
      assertNull(emblStreamSequence1.getHeader());
      
      emblStreamSequence1.forceReset();
      assertNotSame(emblStreamSequence0, emblStreamSequence1);
      assertNotSame(emblStreamSequence1, emblStreamSequence0);
      assertFalse(emblStreamSequence0.equals((Object)emblStreamSequence1));
      assertFalse(emblStreamSequence1.equals((Object)emblStreamSequence0));
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence1.getFormatType());
      assertEquals(0, emblStreamSequence1.getACount());
      assertEquals(0, emblStreamSequence1.getOtherCount());
      assertEquals(0, emblStreamSequence1.getCCount());
      assertEquals(0, emblStreamSequence1.getTCount());
      assertEquals(0, emblStreamSequence1.length());
      assertEquals(0, emblStreamSequence1.getGCount());
      assertNull(emblStreamSequence1.getHeader());
      
      String string0 = "t7sp/4_7DUdFQ'PSk";
      int int0 = LineGroup.getLineType("t7sp/4_7DUdFQ'PSk");
      assertEquals(2, int0);
      
      int int1 = 0;
      // Undeclared exception!
      try { 
        emblStreamSequence1.getSubSequence(0, 0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // -1
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("", "");
      assertNotNull(fastaStreamSequence0);
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      
      int int0 = fastaStreamSequence0.getFormatType();
      assertEquals(4, int0);
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      
      int int1 = fastaStreamSequence0.getTCount();
      assertEquals(0, int1);
      assertFalse(int1 == int0);
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("uk.ac.sanger.artemis.io.StreamSequence");
      assertNotNull(genbankStreamSequence0);
      assertEquals(2, genbankStreamSequence0.getCCount());
      assertEquals(2, genbankStreamSequence0.getTCount());
      assertEquals(29, genbankStreamSequence0.getOtherCount());
      assertEquals(4, genbankStreamSequence0.getACount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(38, genbankStreamSequence0.length());
      
      char[] charArray0 = new char[8];
      charArray0[0] = '^';
      charArray0[1] = '+';
      charArray0[2] = 'a';
      charArray0[3] = 'W';
      charArray0[4] = 'N';
      charArray0[5] = '_';
      charArray0[6] = '6';
      charArray0[7] = 'E';
      genbankStreamSequence0.appendChar(charArray0);
      assertArrayEquals(new char[] {'^', '+', 'a', 'W', 'N', '_', '6', 'E'}, charArray0);
      assertEquals(8, charArray0.length);
      assertEquals(2, genbankStreamSequence0.getCCount());
      assertEquals(2, genbankStreamSequence0.getTCount());
      assertEquals(4, genbankStreamSequence0.getACount());
      assertEquals(46, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(37, genbankStreamSequence0.getOtherCount());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertNull(genbankStreamSequence0.getHeader());
      
      int int2 = genbankStreamSequence0.getFormatType();
      assertEquals(2, int2);
      assertFalse(int2 == int0);
      assertFalse(int2 == int1);
      assertEquals(2, genbankStreamSequence0.getCCount());
      assertEquals(2, genbankStreamSequence0.getTCount());
      assertEquals(4, genbankStreamSequence0.getACount());
      assertEquals(46, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(37, genbankStreamSequence0.getOtherCount());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertNull(genbankStreamSequence0.getHeader());
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      String string0 = "ip(H,h";
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("ip(H,h");
      assertNotNull(genbankStreamSequence0);
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(6, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(6, genbankStreamSequence0.getOtherCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getACount());
      
      GenbankStreamSequence genbankStreamSequence1 = (GenbankStreamSequence)genbankStreamSequence0.copy();
      assertNotSame(genbankStreamSequence0, genbankStreamSequence1);
      assertNotSame(genbankStreamSequence1, genbankStreamSequence0);
      assertFalse(genbankStreamSequence1.equals((Object)genbankStreamSequence0));
      assertNotNull(genbankStreamSequence1);
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(6, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(6, genbankStreamSequence0.getOtherCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence1.getCCount());
      assertEquals(0, genbankStreamSequence1.getTCount());
      assertNull(genbankStreamSequence1.getHeader());
      assertEquals(0, genbankStreamSequence1.getACount());
      assertEquals(6, genbankStreamSequence1.getOtherCount());
      assertEquals(2, genbankStreamSequence1.getFormatType());
      assertEquals(0, genbankStreamSequence1.getGCount());
      assertEquals(6, genbankStreamSequence1.length());
      
      char[] charArray0 = new char[7];
      charArray0[0] = 'o';
      // Undeclared exception!
      try { 
        genbankStreamSequence0.setFromChar((char[]) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("J;q)<J3Q:O");
      assertNotNull(rawStreamSequence0);
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(10, rawStreamSequence0.getOtherCount());
      assertEquals(10, rawStreamSequence0.length());
      assertEquals(3, rawStreamSequence0.getFormatType());
      
      int int0 = rawStreamSequence0.getACount();
      assertEquals(0, int0);
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(10, rawStreamSequence0.getOtherCount());
      assertEquals(10, rawStreamSequence0.length());
      assertEquals(3, rawStreamSequence0.getFormatType());
      
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence(rawStreamSequence0);
      assertNotNull(genbankStreamSequence0);
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(10, rawStreamSequence0.getOtherCount());
      assertEquals(10, rawStreamSequence0.length());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(10, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(10, genbankStreamSequence0.getOtherCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      
      char[] charArray0 = new char[7];
      charArray0[0] = '\\';
      charArray0[1] = '^';
      charArray0[2] = ']';
      charArray0[3] = '#';
      charArray0[4] = '1';
      charArray0[5] = '2';
      charArray0[6] = '5';
      genbankStreamSequence0.setFromChar(charArray0);
      assertArrayEquals(new char[] {'\\', '^', ']', '#', '1', '2', '5'}, charArray0);
      assertEquals(7, charArray0.length);
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(10, rawStreamSequence0.getOtherCount());
      assertEquals(10, rawStreamSequence0.length());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(7, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(7, genbankStreamSequence0.getOtherCount());
      
      GenbankStreamSequence genbankStreamSequence1 = (GenbankStreamSequence)genbankStreamSequence0.copy();
      assertNotSame(genbankStreamSequence0, genbankStreamSequence1);
      assertNotSame(genbankStreamSequence1, genbankStreamSequence0);
      assertFalse(genbankStreamSequence1.equals((Object)genbankStreamSequence0));
      assertNotNull(genbankStreamSequence1);
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(10, rawStreamSequence0.getOtherCount());
      assertEquals(10, rawStreamSequence0.length());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(7, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(7, genbankStreamSequence0.getOtherCount());
      assertEquals(2, genbankStreamSequence1.getFormatType());
      assertEquals(7, genbankStreamSequence1.getOtherCount());
      assertEquals(0, genbankStreamSequence1.getTCount());
      assertEquals(0, genbankStreamSequence1.getGCount());
      assertEquals(0, genbankStreamSequence1.getCCount());
      assertNull(genbankStreamSequence1.getHeader());
      assertEquals(0, genbankStreamSequence1.getACount());
      assertEquals(7, genbankStreamSequence1.length());
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      String string0 = "eu";
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("eu");
      assertNotNull(rawStreamSequence0);
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(2, rawStreamSequence0.getOtherCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(2, rawStreamSequence0.length());
      
      int int0 = 0;
      int int1 = 0;
      int[] intArray0 = new int[0];
      rawStreamSequence0.setFastaHeaderPosition(intArray0, intArray0);
      assertArrayEquals(new int[] {}, intArray0);
      assertEquals(0, intArray0.length);
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(2, rawStreamSequence0.getOtherCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(2, rawStreamSequence0.length());
      
      // Undeclared exception!
      try { 
        rawStreamSequence0.getCharSubSequence(0, 0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // -1
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      String string0 = "";
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("");
      assertNotNull(fastaStreamSequence0);
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence(fastaStreamSequence0);
      assertNotNull(emblStreamSequence0);
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      
      // Undeclared exception!
      try { 
        fastaStreamSequence0.setSequencePackingCapacity((-1830));
        fail("Expecting exception: NegativeArraySizeException");
      
      } catch(NegativeArraySizeException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("Xw#w[ASnz(!.<8u$");
      assertNotNull(rawStreamSequence0);
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(16, rawStreamSequence0.getOtherCount());
      assertEquals(16, rawStreamSequence0.length());
      
      int[] intArray0 = new int[5];
      intArray0[0] = 1387;
      intArray0[1] = 0;
      intArray0[2] = 113;
      intArray0[3] = (-1720);
      char[] charArray0 = new char[8];
      charArray0[0] = 'd';
      charArray0[1] = '7';
      charArray0[2] = 'm';
      charArray0[3] = 'U';
      charArray0[4] = '>';
      charArray0[5] = 'H';
      charArray0[6] = 'B';
      charArray0[7] = 'H';
      rawStreamSequence0.appendChar(charArray0);
      assertArrayEquals(new char[] {'d', '7', 'm', 'U', '>', 'H', 'B', 'H'}, charArray0);
      assertEquals(8, charArray0.length);
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(24, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(24, rawStreamSequence0.getOtherCount());
      
      intArray0[4] = 0;
      rawStreamSequence0.setFastaHeaderPosition(intArray0, intArray0);
      assertArrayEquals(new int[] {1387, 0, 113, (-1720), 0}, intArray0);
      assertEquals(5, intArray0.length);
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(24, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(24, rawStreamSequence0.getOtherCount());
      
      int int0 = rawStreamSequence0.getGCount();
      assertEquals(0, int0);
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(24, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(24, rawStreamSequence0.getOtherCount());
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      StringReader stringReader0 = new StringReader("v_eo)cX)=s^6,|");
      assertNotNull(stringReader0);
      
      boolean boolean0 = stringReader0.ready();
      assertTrue(boolean0);
      
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(stringReader0);
      assertNotNull(linePushBackReader0);
      assertEquals(0, linePushBackReader0.getLineNumber());
      
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence(linePushBackReader0);
      assertNotNull(rawStreamSequence0);
      assertEquals(1, linePushBackReader0.getLineNumber());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.length());
      
      StringWriter stringWriter0 = new StringWriter();
      assertNotNull(stringWriter0);
      assertEquals("", stringWriter0.toString());
      
      StringWriter stringWriter1 = stringWriter0.append((CharSequence) "v_eo)cX)=s^6,|");
      assertSame(stringWriter0, stringWriter1);
      assertSame(stringWriter1, stringWriter0);
      assertNotNull(stringWriter1);
      assertEquals("v_eo)cX)=s^6,|", stringWriter0.toString());
      assertEquals("v_eo)cX)=s^6,|", stringWriter1.toString());
      
      LineGroup.writeStartOfGFFEntry(stringWriter1);
      assertSame(stringWriter0, stringWriter1);
      assertSame(stringWriter1, stringWriter0);
      assertEquals("v_eo)cX)=s^6,|##FASTA\n", stringWriter0.toString());
      assertEquals("v_eo)cX)=s^6,|##FASTA\n", stringWriter1.toString());
      
      rawStreamSequence0.readHeader(linePushBackReader0);
      assertEquals(1, linePushBackReader0.getLineNumber());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.length());
      
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("v_eo)cX)=s^6,|");
      assertNotNull(emblStreamSequence0);
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(13, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(14, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getACount());
      
      String string0 = emblStreamSequence0.getHeader();
      assertNull(string0);
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(13, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(14, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getACount());
      
      emblStreamSequence0.readHeader(linePushBackReader0);
      assertEquals(1, linePushBackReader0.getLineNumber());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(13, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(14, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getACount());
      
      rawStreamSequence0.readHeader(linePushBackReader0);
      assertEquals(1, linePushBackReader0.getLineNumber());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.length());
      
      char[] charArray0 = rawStreamSequence0.getCharSequence();
      assertArrayEquals(new char[] {}, charArray0);
      assertEquals(0, charArray0.length);
      assertNotNull(charArray0);
      assertEquals(1, linePushBackReader0.getLineNumber());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.length());
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      StringReader stringReader0 = new StringReader("lahIoR)89Zw%q_hE!_");
      assertNotNull(stringReader0);
      
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(stringReader0);
      assertNotNull(linePushBackReader0);
      assertEquals(0, linePushBackReader0.getLineNumber());
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence(linePushBackReader0);
      assertNotNull(fastaStreamSequence0);
      assertEquals(1, linePushBackReader0.getLineNumber());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.length());
      
      char[] charArray0 = new char[3];
      charArray0[0] = 'k';
      charArray0[1] = 'd';
      charArray0[2] = '$';
      fastaStreamSequence0.appendChar(charArray0);
      assertArrayEquals(new char[] {'k', 'd', '$'}, charArray0);
      assertEquals(3, charArray0.length);
      assertEquals(1, linePushBackReader0.getLineNumber());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("F\"bLQ.T]", "F\"bLQ.T]");
      assertNotNull(fastaStreamSequence0);
      assertEquals(8, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(8, fastaStreamSequence0.length());
      
      StringWriter stringWriter0 = new StringWriter();
      assertNotNull(stringWriter0);
      assertEquals("", stringWriter0.toString());
      
      stringWriter0.close();
      assertEquals("", stringWriter0.toString());
      
      Range range0 = mock(Range.class, new ViolatedAssumptionAnswer());
      RangeVector rangeVector0 = new RangeVector(range0);
      assertNotNull(rangeVector0);
      assertEquals(10, rangeVector0.capacity());
      assertEquals(1, rangeVector0.size());
      assertFalse(rangeVector0.isEmpty());
      
      fastaStreamSequence0.setFastaHeaderPositionsOnReverseComplement(rangeVector0);
      assertEquals(8, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(8, fastaStreamSequence0.length());
      assertEquals(10, rangeVector0.capacity());
      assertEquals(1, rangeVector0.size());
      assertFalse(rangeVector0.isEmpty());
      
      LineGroup.writeEndOfEMBLEntry(stringWriter0);
      assertEquals("//\n", stringWriter0.toString());
      
      StringWriter stringWriter1 = stringWriter0.append('?');
      assertSame(stringWriter0, stringWriter1);
      assertSame(stringWriter1, stringWriter0);
      assertNotNull(stringWriter1);
      assertEquals("//\n?", stringWriter0.toString());
      assertEquals("//\n?", stringWriter1.toString());
      
      fastaStreamSequence0.writeToStream(stringWriter1);
      assertSame(stringWriter0, stringWriter1);
      assertSame(stringWriter1, stringWriter0);
      assertEquals(8, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(8, fastaStreamSequence0.length());
      assertEquals("//\n?>F\"bLQ.T]\nnnbnnnnn\n", stringWriter0.toString());
      assertEquals("//\n?>F\"bLQ.T]\nnnbnnnnn\n", stringWriter1.toString());
      
      int[] intArray0 = fastaStreamSequence0.getFastaHeaderPositions();
      assertArrayEquals(new int[] {}, intArray0);
      assertEquals(0, intArray0.length);
      assertNotNull(intArray0);
      assertEquals(8, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(8, fastaStreamSequence0.length());
      
      IndexFastaStream indexFastaStream0 = null;
      try {
        indexFastaStream0 = new IndexFastaStream((Entry) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.IndexFastaStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("region", "Rp");
      assertNotNull(fastaStreamSequence0);
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(5, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      
      int int0 = fastaStreamSequence0.getFormatType();
      assertEquals(4, int0);
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(5, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      
      org.biojava.bio.seq.Sequence sequence0 = mock(org.biojava.bio.seq.Sequence.class, new ViolatedAssumptionAnswer());
      doReturn((String) null).when(sequence0).getName();
      doReturn((String) null).when(sequence0).getURN();
      FeatureRealizer featureRealizer0 = mock(FeatureRealizer.class, new ViolatedAssumptionAnswer());
      CircularView circularView0 = null;
      try {
        circularView0 = new CircularView(sequence0, featureRealizer0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.biojava.bio.seq.impl.ViewSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      String string0 = "uk.ac.sanger.artemis.io.StreamSequence";
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("uk.ac.sanger.artemis.io.StreamSequence");
      assertNotNull(rawStreamSequence0);
      assertEquals(1, rawStreamSequence0.getGCount());
      assertEquals(4, rawStreamSequence0.getACount());
      assertEquals(2, rawStreamSequence0.getCCount());
      assertEquals(2, rawStreamSequence0.getTCount());
      assertEquals(29, rawStreamSequence0.getOtherCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(38, rawStreamSequence0.length());
      
      // Undeclared exception!
      try { 
        rawStreamSequence0.copy();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.RawStreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test30()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("");
      assertNotNull(emblStreamSequence0);
      assertEquals(0, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0, emblStreamSequence0.getCCount());
      
      emblStreamSequence0.setSequencePackingCapacity(159);
      assertEquals(0, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0, emblStreamSequence0.getCCount());
      
      // Undeclared exception!
      try { 
        emblStreamSequence0.getCharSubSequence(159, (-183));
        fail("Expecting exception: NegativeArraySizeException");
      
      } catch(NegativeArraySizeException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test31()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("");
      assertNotNull(fastaStreamSequence0);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      
      char[] charArray0 = new char[3];
      charArray0[0] = '^';
      charArray0[1] = 'F';
      charArray0[2] = 'M';
      fastaStreamSequence0.setFromChar(charArray0);
      assertArrayEquals(new char[] {'^', 'F', 'M'}, charArray0);
      assertEquals(3, charArray0.length);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      
      int int0 = fastaStreamSequence0.getFormatType();
      assertEquals(4, int0);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
  }

  @Test(timeout = 4000)
  public void test32()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("ugIf)lI");
      assertNotNull(genbankStreamSequence0);
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(6, genbankStreamSequence0.getOtherCount());
      assertEquals(7, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getTCount());
      
      String string0 = genbankStreamSequence0.getSubSequence(502, 0);
      assertEquals("", string0);
      assertNotNull(string0);
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(6, genbankStreamSequence0.getOtherCount());
      assertEquals(7, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getTCount());
      
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence(genbankStreamSequence0);
      assertNotNull(rawStreamSequence0);
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(6, genbankStreamSequence0.getOtherCount());
      assertEquals(7, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(7, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(6, rawStreamSequence0.getOtherCount());
      assertEquals(1, rawStreamSequence0.getGCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      
      StringWriter stringWriter0 = new StringWriter(502);
      assertNotNull(stringWriter0);
      assertEquals("", stringWriter0.toString());
      
      genbankStreamSequence0.writeToStream(stringWriter0);
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(6, genbankStreamSequence0.getOtherCount());
      assertEquals(7, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals("BASE COUNT        0 a      0 c      1 g      0 t\nORIGIN\n        1 ugnnnnn\n", stringWriter0.toString());
      
      String string1 = LineGroup.EMBL_SEQUENCE_STRING;
      assertEquals("SQ", string1);
      assertFalse(string1.equals((Object)string0));
      assertNotNull(string1);
      
      stringWriter0.flush();
      assertEquals("BASE COUNT        0 a      0 c      1 g      0 t\nORIGIN\n        1 ugnnnnn\n", stringWriter0.toString());
      
      StringWriter stringWriter1 = stringWriter0.append((CharSequence) "SQ");
      assertSame(stringWriter0, stringWriter1);
      assertSame(stringWriter1, stringWriter0);
      assertNotNull(stringWriter1);
      assertEquals("BASE COUNT        0 a      0 c      1 g      0 t\nORIGIN\n        1 ugnnnnn\nSQ", stringWriter0.toString());
      assertEquals("BASE COUNT        0 a      0 c      1 g      0 t\nORIGIN\n        1 ugnnnnn\nSQ", stringWriter1.toString());
      
      StringWriter stringWriter2 = stringWriter1.append('&');
      assertSame(stringWriter0, stringWriter1);
      assertSame(stringWriter0, stringWriter2);
      assertSame(stringWriter1, stringWriter2);
      assertSame(stringWriter1, stringWriter0);
      assertSame(stringWriter2, stringWriter0);
      assertSame(stringWriter2, stringWriter1);
      assertNotNull(stringWriter2);
      assertEquals("BASE COUNT        0 a      0 c      1 g      0 t\nORIGIN\n        1 ugnnnnn\nSQ&", stringWriter0.toString());
      assertEquals("BASE COUNT        0 a      0 c      1 g      0 t\nORIGIN\n        1 ugnnnnn\nSQ&", stringWriter1.toString());
      assertEquals("BASE COUNT        0 a      0 c      1 g      0 t\nORIGIN\n        1 ugnnnnn\nSQ&", stringWriter2.toString());
      
      LineGroup.writeStartOfGFFEntry(stringWriter1);
      assertSame(stringWriter0, stringWriter1);
      assertSame(stringWriter0, stringWriter2);
      assertSame(stringWriter1, stringWriter2);
      assertSame(stringWriter1, stringWriter0);
      assertEquals("BASE COUNT        0 a      0 c      1 g      0 t\nORIGIN\n        1 ugnnnnn\nSQ&##FASTA\n", stringWriter0.toString());
      assertEquals("BASE COUNT        0 a      0 c      1 g      0 t\nORIGIN\n        1 ugnnnnn\nSQ&##FASTA\n", stringWriter1.toString());
      
      StringReader stringReader0 = new StringReader(",|7<GYVsA\"7]b]0");
      assertNotNull(stringReader0);
      
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(stringReader0);
      assertNotNull(linePushBackReader0);
      assertEquals(0, linePushBackReader0.getLineNumber());
      
      try { 
        genbankStreamSequence0.readSequence(linePushBackReader0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // GENBANK sequence file contains a character that is not a letter: ,
         //
         verifyException("uk.ac.sanger.artemis.io.GenbankStreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test33()  throws Throwable  {
      String string0 = "V6u";
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("V6u", "uk.ac.sanger.artemis.io.StreamSequence");
      assertNotNull(fastaStreamSequence0);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      
      char[] charArray0 = new char[1];
      charArray0[0] = 'B';
      fastaStreamSequence0.appendChar(charArray0);
      assertArrayEquals(new char[] {'B'}, charArray0);
      assertEquals(1, charArray0.length);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.length());
      
      fastaStreamSequence0.forceReset();
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.length());
      
      char[] charArray1 = new char[2];
      assertFalse(charArray1.equals((Object)charArray0));
      
      fastaStreamSequence0.setCounts();
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.length());
      
      charArray1[0] = ')';
      charArray1[1] = 'a';
      fastaStreamSequence0.appendChar(charArray1);
      assertNotSame(charArray1, charArray0);
      assertArrayEquals(new char[] {')', 'a'}, charArray1);
      assertFalse(charArray1.equals((Object)charArray0));
      assertEquals(2, charArray1.length);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      
      // Undeclared exception!
      try { 
        fastaStreamSequence0.copy();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.RawStreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test34()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("Can't pack with alphabet ");
      assertNotNull(genbankStreamSequence0);
      assertEquals(1, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(17, genbankStreamSequence0.getOtherCount());
      assertEquals(4, genbankStreamSequence0.getACount());
      assertEquals(25, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(3, genbankStreamSequence0.getTCount());
      
      GenbankStreamSequence genbankStreamSequence1 = (GenbankStreamSequence)genbankStreamSequence0.copy();
      assertNotSame(genbankStreamSequence0, genbankStreamSequence1);
      assertNotSame(genbankStreamSequence1, genbankStreamSequence0);
      assertFalse(genbankStreamSequence1.equals((Object)genbankStreamSequence0));
      assertNotNull(genbankStreamSequence1);
      assertEquals(1, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(17, genbankStreamSequence0.getOtherCount());
      assertEquals(4, genbankStreamSequence0.getACount());
      assertEquals(25, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(3, genbankStreamSequence0.getTCount());
      assertEquals(2, genbankStreamSequence1.getFormatType());
      assertEquals(25, genbankStreamSequence1.length());
      assertEquals(0, genbankStreamSequence1.getGCount());
      assertEquals(17, genbankStreamSequence1.getOtherCount());
      assertEquals(1, genbankStreamSequence1.getCCount());
      assertNull(genbankStreamSequence1.getHeader());
      assertEquals(3, genbankStreamSequence1.getTCount());
      assertEquals(4, genbankStreamSequence1.getACount());
      
      GenbankStreamSequence genbankStreamSequence2 = new GenbankStreamSequence(genbankStreamSequence1);
      assertFalse(genbankStreamSequence0.equals((Object)genbankStreamSequence1));
      assertFalse(genbankStreamSequence1.equals((Object)genbankStreamSequence0));
      assertFalse(genbankStreamSequence2.equals((Object)genbankStreamSequence0));
      assertFalse(genbankStreamSequence2.equals((Object)genbankStreamSequence1));
      assertNotNull(genbankStreamSequence2);
      assertEquals(1, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(17, genbankStreamSequence0.getOtherCount());
      assertEquals(4, genbankStreamSequence0.getACount());
      assertEquals(25, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(3, genbankStreamSequence0.getTCount());
      assertEquals(2, genbankStreamSequence1.getFormatType());
      assertEquals(25, genbankStreamSequence1.length());
      assertEquals(0, genbankStreamSequence1.getGCount());
      assertEquals(17, genbankStreamSequence1.getOtherCount());
      assertEquals(1, genbankStreamSequence1.getCCount());
      assertNull(genbankStreamSequence1.getHeader());
      assertEquals(3, genbankStreamSequence1.getTCount());
      assertEquals(4, genbankStreamSequence1.getACount());
      assertEquals(17, genbankStreamSequence2.getOtherCount());
      assertEquals(3, genbankStreamSequence2.getTCount());
      assertEquals(2, genbankStreamSequence2.getFormatType());
      assertEquals(4, genbankStreamSequence2.getACount());
      assertEquals(25, genbankStreamSequence2.length());
      assertNull(genbankStreamSequence2.getHeader());
      assertEquals(1, genbankStreamSequence2.getCCount());
      assertEquals(0, genbankStreamSequence2.getGCount());
      
      GenbankStreamSequence genbankStreamSequence3 = (GenbankStreamSequence)genbankStreamSequence2.copy();
      assertNotSame(genbankStreamSequence0, genbankStreamSequence3);
      assertNotSame(genbankStreamSequence0, genbankStreamSequence2);
      assertNotSame(genbankStreamSequence0, genbankStreamSequence1);
      assertNotSame(genbankStreamSequence1, genbankStreamSequence0);
      assertNotSame(genbankStreamSequence1, genbankStreamSequence3);
      assertNotSame(genbankStreamSequence1, genbankStreamSequence2);
      assertNotSame(genbankStreamSequence2, genbankStreamSequence3);
      assertNotSame(genbankStreamSequence2, genbankStreamSequence0);
      assertNotSame(genbankStreamSequence2, genbankStreamSequence1);
      assertNotSame(genbankStreamSequence3, genbankStreamSequence1);
      assertNotSame(genbankStreamSequence3, genbankStreamSequence2);
      assertNotSame(genbankStreamSequence3, genbankStreamSequence0);
      assertFalse(genbankStreamSequence0.equals((Object)genbankStreamSequence2));
      assertFalse(genbankStreamSequence0.equals((Object)genbankStreamSequence1));
      assertFalse(genbankStreamSequence1.equals((Object)genbankStreamSequence0));
      assertFalse(genbankStreamSequence1.equals((Object)genbankStreamSequence2));
      assertFalse(genbankStreamSequence2.equals((Object)genbankStreamSequence0));
      assertFalse(genbankStreamSequence2.equals((Object)genbankStreamSequence1));
      assertFalse(genbankStreamSequence3.equals((Object)genbankStreamSequence1));
      assertFalse(genbankStreamSequence3.equals((Object)genbankStreamSequence2));
      assertFalse(genbankStreamSequence3.equals((Object)genbankStreamSequence0));
      assertNotNull(genbankStreamSequence3);
      assertEquals(1, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(17, genbankStreamSequence0.getOtherCount());
      assertEquals(4, genbankStreamSequence0.getACount());
      assertEquals(25, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(3, genbankStreamSequence0.getTCount());
      assertEquals(2, genbankStreamSequence1.getFormatType());
      assertEquals(25, genbankStreamSequence1.length());
      assertEquals(0, genbankStreamSequence1.getGCount());
      assertEquals(17, genbankStreamSequence1.getOtherCount());
      assertEquals(1, genbankStreamSequence1.getCCount());
      assertNull(genbankStreamSequence1.getHeader());
      assertEquals(3, genbankStreamSequence1.getTCount());
      assertEquals(4, genbankStreamSequence1.getACount());
      assertEquals(17, genbankStreamSequence2.getOtherCount());
      assertEquals(3, genbankStreamSequence2.getTCount());
      assertEquals(2, genbankStreamSequence2.getFormatType());
      assertEquals(4, genbankStreamSequence2.getACount());
      assertEquals(25, genbankStreamSequence2.length());
      assertNull(genbankStreamSequence2.getHeader());
      assertEquals(1, genbankStreamSequence2.getCCount());
      assertEquals(0, genbankStreamSequence2.getGCount());
      assertEquals(2, genbankStreamSequence3.getFormatType());
      assertEquals(0, genbankStreamSequence3.getGCount());
      assertEquals(4, genbankStreamSequence3.getACount());
      assertEquals(25, genbankStreamSequence3.length());
      assertEquals(1, genbankStreamSequence3.getCCount());
      assertNull(genbankStreamSequence3.getHeader());
      assertEquals(17, genbankStreamSequence3.getOtherCount());
      assertEquals(3, genbankStreamSequence3.getTCount());
      
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence(genbankStreamSequence3);
      assertFalse(genbankStreamSequence0.equals((Object)genbankStreamSequence3));
      assertFalse(genbankStreamSequence0.equals((Object)genbankStreamSequence2));
      assertFalse(genbankStreamSequence0.equals((Object)genbankStreamSequence1));
      assertFalse(genbankStreamSequence1.equals((Object)genbankStreamSequence0));
      assertFalse(genbankStreamSequence1.equals((Object)genbankStreamSequence3));
      assertFalse(genbankStreamSequence1.equals((Object)genbankStreamSequence2));
      assertFalse(genbankStreamSequence2.equals((Object)genbankStreamSequence3));
      assertFalse(genbankStreamSequence2.equals((Object)genbankStreamSequence0));
      assertFalse(genbankStreamSequence2.equals((Object)genbankStreamSequence1));
      assertFalse(genbankStreamSequence3.equals((Object)genbankStreamSequence1));
      assertFalse(genbankStreamSequence3.equals((Object)genbankStreamSequence2));
      assertFalse(genbankStreamSequence3.equals((Object)genbankStreamSequence0));
      assertNotNull(rawStreamSequence0);
      assertEquals(1, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(17, genbankStreamSequence0.getOtherCount());
      assertEquals(4, genbankStreamSequence0.getACount());
      assertEquals(25, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(3, genbankStreamSequence0.getTCount());
      assertEquals(2, genbankStreamSequence1.getFormatType());
      assertEquals(25, genbankStreamSequence1.length());
      assertEquals(0, genbankStreamSequence1.getGCount());
      assertEquals(17, genbankStreamSequence1.getOtherCount());
      assertEquals(1, genbankStreamSequence1.getCCount());
      assertNull(genbankStreamSequence1.getHeader());
      assertEquals(3, genbankStreamSequence1.getTCount());
      assertEquals(4, genbankStreamSequence1.getACount());
      assertEquals(17, genbankStreamSequence2.getOtherCount());
      assertEquals(3, genbankStreamSequence2.getTCount());
      assertEquals(2, genbankStreamSequence2.getFormatType());
      assertEquals(4, genbankStreamSequence2.getACount());
      assertEquals(25, genbankStreamSequence2.length());
      assertNull(genbankStreamSequence2.getHeader());
      assertEquals(1, genbankStreamSequence2.getCCount());
      assertEquals(0, genbankStreamSequence2.getGCount());
      assertEquals(2, genbankStreamSequence3.getFormatType());
      assertEquals(0, genbankStreamSequence3.getGCount());
      assertEquals(4, genbankStreamSequence3.getACount());
      assertEquals(25, genbankStreamSequence3.length());
      assertEquals(1, genbankStreamSequence3.getCCount());
      assertNull(genbankStreamSequence3.getHeader());
      assertEquals(17, genbankStreamSequence3.getOtherCount());
      assertEquals(3, genbankStreamSequence3.getTCount());
      assertEquals(3, rawStreamSequence0.getTCount());
      assertEquals(17, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(1, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(25, rawStreamSequence0.length());
      assertEquals(4, rawStreamSequence0.getACount());
      
      // Undeclared exception!
      try { 
        genbankStreamSequence1.getCharSubSequence(1000, 1000);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 499
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test35()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("", "J1ykLoXs ]s,");
      assertNotNull(fastaStreamSequence0);
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      
      StringWriter stringWriter0 = new StringWriter(1101);
      assertNotNull(stringWriter0);
      assertEquals("", stringWriter0.toString());
      
      LineGroup.writeEndOfEMBLEntry(stringWriter0);
      assertEquals("//\n", stringWriter0.toString());
      
      fastaStreamSequence0.forceReset();
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      
      fastaStreamSequence0.setCounts();
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
  }

  @Test(timeout = 4000)
  public void test36()  throws Throwable  {
      String string0 = ")r8Fw'yaB$>%%J";
      StringReader stringReader0 = new StringReader(")r8Fw'yaB$>%%J");
      assertNotNull(stringReader0);
      
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(stringReader0);
      assertNotNull(linePushBackReader0);
      assertEquals(0, linePushBackReader0.getLineNumber());
      
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence(linePushBackReader0);
      assertNotNull(emblStreamSequence0);
      assertEquals(1, linePushBackReader0.getLineNumber());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.length());
      assertEquals(")r8Fw'yaB$>%%J", emblStreamSequence0.getHeader());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getACount());
      
      EmblStreamSequence emblStreamSequence1 = (EmblStreamSequence)emblStreamSequence0.copy();
      assertNotSame(emblStreamSequence0, emblStreamSequence1);
      assertNotSame(emblStreamSequence1, emblStreamSequence0);
      assertFalse(emblStreamSequence1.equals((Object)emblStreamSequence0));
      assertNotNull(emblStreamSequence1);
      assertEquals(1, linePushBackReader0.getLineNumber());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.length());
      assertEquals(")r8Fw'yaB$>%%J", emblStreamSequence0.getHeader());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence1.getGCount());
      assertEquals(1, emblStreamSequence1.getFormatType());
      assertEquals(0, emblStreamSequence1.getTCount());
      assertEquals(0, emblStreamSequence1.getCCount());
      assertEquals(0, emblStreamSequence1.length());
      assertNull(emblStreamSequence1.getHeader());
      assertEquals(0, emblStreamSequence1.getOtherCount());
      assertEquals(0, emblStreamSequence1.getACount());
      
      EmblStreamSequence emblStreamSequence2 = (EmblStreamSequence)emblStreamSequence1.copy();
      assertNotSame(emblStreamSequence0, emblStreamSequence2);
      assertNotSame(emblStreamSequence0, emblStreamSequence1);
      assertNotSame(emblStreamSequence1, emblStreamSequence2);
      assertNotSame(emblStreamSequence1, emblStreamSequence0);
      assertNotSame(emblStreamSequence2, emblStreamSequence0);
      assertNotSame(emblStreamSequence2, emblStreamSequence1);
      assertFalse(emblStreamSequence0.equals((Object)emblStreamSequence1));
      assertFalse(emblStreamSequence1.equals((Object)emblStreamSequence0));
      assertFalse(emblStreamSequence2.equals((Object)emblStreamSequence0));
      assertFalse(emblStreamSequence2.equals((Object)emblStreamSequence1));
      assertNotNull(emblStreamSequence2);
      assertEquals(1, linePushBackReader0.getLineNumber());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.length());
      assertEquals(")r8Fw'yaB$>%%J", emblStreamSequence0.getHeader());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence1.getGCount());
      assertEquals(1, emblStreamSequence1.getFormatType());
      assertEquals(0, emblStreamSequence1.getTCount());
      assertEquals(0, emblStreamSequence1.getCCount());
      assertEquals(0, emblStreamSequence1.length());
      assertNull(emblStreamSequence1.getHeader());
      assertEquals(0, emblStreamSequence1.getOtherCount());
      assertEquals(0, emblStreamSequence1.getACount());
      assertNull(emblStreamSequence2.getHeader());
      assertEquals(0, emblStreamSequence2.getCCount());
      assertEquals(0, emblStreamSequence2.length());
      assertEquals(0, emblStreamSequence2.getTCount());
      assertEquals(1, emblStreamSequence2.getFormatType());
      assertEquals(0, emblStreamSequence2.getACount());
      assertEquals(0, emblStreamSequence2.getGCount());
      assertEquals(0, emblStreamSequence2.getOtherCount());
      
      // Undeclared exception!
      try { 
        emblStreamSequence0.charAt((-970));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // -486
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test37()  throws Throwable  {
      StringReader stringReader0 = new StringReader("");
      assertNotNull(stringReader0);
      
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(stringReader0);
      assertNotNull(linePushBackReader0);
      assertEquals(0, linePushBackReader0.getLineNumber());
      
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence(linePushBackReader0);
      assertNotNull(rawStreamSequence0);
      assertEquals(0, linePushBackReader0.getLineNumber());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(0, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.length());
  }

  @Test(timeout = 4000)
  public void test38()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("literature=");
      assertNotNull(genbankStreamSequence0);
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(1, genbankStreamSequence0.getACount());
      assertEquals(2, genbankStreamSequence0.getTCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(11, genbankStreamSequence0.length());
      assertEquals(8, genbankStreamSequence0.getOtherCount());
      
      // Undeclared exception!
      try { 
        genbankStreamSequence0.charAt(0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // -1
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test39()  throws Throwable  {
      StringReader stringReader0 = new StringReader("V{2\"_seI|");
      assertNotNull(stringReader0);
      
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(stringReader0);
      assertNotNull(linePushBackReader0);
      assertEquals(0, linePushBackReader0.getLineNumber());
      
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("V{2\"_seI|");
      assertNotNull(genbankStreamSequence0);
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(9, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(9, genbankStreamSequence0.getOtherCount());
      
      GenbankStreamSequence genbankStreamSequence1 = (GenbankStreamSequence)genbankStreamSequence0.copy();
      assertNotSame(genbankStreamSequence0, genbankStreamSequence1);
      assertNotSame(genbankStreamSequence1, genbankStreamSequence0);
      assertFalse(genbankStreamSequence1.equals((Object)genbankStreamSequence0));
      assertNotNull(genbankStreamSequence1);
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(9, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(9, genbankStreamSequence0.getOtherCount());
      assertNull(genbankStreamSequence1.getHeader());
      assertEquals(0, genbankStreamSequence1.getACount());
      assertEquals(0, genbankStreamSequence1.getCCount());
      assertEquals(0, genbankStreamSequence1.getGCount());
      assertEquals(9, genbankStreamSequence1.length());
      assertEquals(0, genbankStreamSequence1.getTCount());
      assertEquals(2, genbankStreamSequence1.getFormatType());
      assertEquals(9, genbankStreamSequence1.getOtherCount());
      
      GenbankStreamSequence genbankStreamSequence2 = (GenbankStreamSequence)genbankStreamSequence1.copy();
      assertNotSame(genbankStreamSequence0, genbankStreamSequence1);
      assertNotSame(genbankStreamSequence0, genbankStreamSequence2);
      assertNotSame(genbankStreamSequence1, genbankStreamSequence0);
      assertNotSame(genbankStreamSequence1, genbankStreamSequence2);
      assertNotSame(genbankStreamSequence2, genbankStreamSequence1);
      assertNotSame(genbankStreamSequence2, genbankStreamSequence0);
      assertFalse(genbankStreamSequence0.equals((Object)genbankStreamSequence1));
      assertFalse(genbankStreamSequence1.equals((Object)genbankStreamSequence0));
      assertFalse(genbankStreamSequence2.equals((Object)genbankStreamSequence1));
      assertFalse(genbankStreamSequence2.equals((Object)genbankStreamSequence0));
      assertNotNull(genbankStreamSequence2);
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(9, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(9, genbankStreamSequence0.getOtherCount());
      assertNull(genbankStreamSequence1.getHeader());
      assertEquals(0, genbankStreamSequence1.getACount());
      assertEquals(0, genbankStreamSequence1.getCCount());
      assertEquals(0, genbankStreamSequence1.getGCount());
      assertEquals(9, genbankStreamSequence1.length());
      assertEquals(0, genbankStreamSequence1.getTCount());
      assertEquals(2, genbankStreamSequence1.getFormatType());
      assertEquals(9, genbankStreamSequence1.getOtherCount());
      assertEquals(0, genbankStreamSequence2.getACount());
      assertEquals(2, genbankStreamSequence2.getFormatType());
      assertEquals(9, genbankStreamSequence2.getOtherCount());
      assertEquals(0, genbankStreamSequence2.getTCount());
      assertEquals(9, genbankStreamSequence2.length());
      assertEquals(0, genbankStreamSequence2.getGCount());
      assertNull(genbankStreamSequence2.getHeader());
      assertEquals(0, genbankStreamSequence2.getCCount());
      
      genbankStreamSequence2.setCounts();
      assertNotSame(genbankStreamSequence0, genbankStreamSequence1);
      assertNotSame(genbankStreamSequence0, genbankStreamSequence2);
      assertNotSame(genbankStreamSequence1, genbankStreamSequence0);
      assertNotSame(genbankStreamSequence1, genbankStreamSequence2);
      assertNotSame(genbankStreamSequence2, genbankStreamSequence1);
      assertNotSame(genbankStreamSequence2, genbankStreamSequence0);
      assertFalse(genbankStreamSequence0.equals((Object)genbankStreamSequence1));
      assertFalse(genbankStreamSequence0.equals((Object)genbankStreamSequence2));
      assertFalse(genbankStreamSequence1.equals((Object)genbankStreamSequence0));
      assertFalse(genbankStreamSequence1.equals((Object)genbankStreamSequence2));
      assertFalse(genbankStreamSequence2.equals((Object)genbankStreamSequence1));
      assertFalse(genbankStreamSequence2.equals((Object)genbankStreamSequence0));
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(9, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(9, genbankStreamSequence0.getOtherCount());
      assertNull(genbankStreamSequence1.getHeader());
      assertEquals(0, genbankStreamSequence1.getACount());
      assertEquals(0, genbankStreamSequence1.getCCount());
      assertEquals(0, genbankStreamSequence1.getGCount());
      assertEquals(9, genbankStreamSequence1.length());
      assertEquals(0, genbankStreamSequence1.getTCount());
      assertEquals(2, genbankStreamSequence1.getFormatType());
      assertEquals(9, genbankStreamSequence1.getOtherCount());
      assertEquals(0, genbankStreamSequence2.getACount());
      assertEquals(2, genbankStreamSequence2.getFormatType());
      assertEquals(9, genbankStreamSequence2.getOtherCount());
      assertEquals(0, genbankStreamSequence2.getTCount());
      assertEquals(9, genbankStreamSequence2.length());
      assertEquals(0, genbankStreamSequence2.getGCount());
      assertNull(genbankStreamSequence2.getHeader());
      assertEquals(0, genbankStreamSequence2.getCCount());
  }

  @Test(timeout = 4000)
  public void test40()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      assertNotNull(genbankStreamSequence0);
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      
      GenbankStreamSequence genbankStreamSequence1 = new GenbankStreamSequence(genbankStreamSequence0);
      assertFalse(genbankStreamSequence1.equals((Object)genbankStreamSequence0));
      assertNotNull(genbankStreamSequence1);
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence1.getTCount());
      assertNull(genbankStreamSequence1.getHeader());
      assertEquals(0, genbankStreamSequence1.getACount());
      assertEquals(0, genbankStreamSequence1.getGCount());
      assertEquals(0, genbankStreamSequence1.getCCount());
      assertEquals(0, genbankStreamSequence1.getOtherCount());
      assertEquals(0, genbankStreamSequence1.length());
      assertEquals(2, genbankStreamSequence1.getFormatType());
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence(genbankStreamSequence1);
      assertFalse(genbankStreamSequence0.equals((Object)genbankStreamSequence1));
      assertFalse(genbankStreamSequence1.equals((Object)genbankStreamSequence0));
      assertNotNull(fastaStreamSequence0);
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence1.getTCount());
      assertNull(genbankStreamSequence1.getHeader());
      assertEquals(0, genbankStreamSequence1.getACount());
      assertEquals(0, genbankStreamSequence1.getGCount());
      assertEquals(0, genbankStreamSequence1.getCCount());
      assertEquals(0, genbankStreamSequence1.getOtherCount());
      assertEquals(0, genbankStreamSequence1.length());
      assertEquals(2, genbankStreamSequence1.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      
      int int0 = fastaStreamSequence0.getCCount();
      assertNotSame(genbankStreamSequence0, genbankStreamSequence1);
      assertNotSame(genbankStreamSequence1, genbankStreamSequence0);
      assertEquals(0, int0);
      assertFalse(genbankStreamSequence0.equals((Object)genbankStreamSequence1));
      assertFalse(genbankStreamSequence1.equals((Object)genbankStreamSequence0));
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence1.getTCount());
      assertNull(genbankStreamSequence1.getHeader());
      assertEquals(0, genbankStreamSequence1.getACount());
      assertEquals(0, genbankStreamSequence1.getGCount());
      assertEquals(0, genbankStreamSequence1.getCCount());
      assertEquals(0, genbankStreamSequence1.getOtherCount());
      assertEquals(0, genbankStreamSequence1.length());
      assertEquals(2, genbankStreamSequence1.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
  }

  @Test(timeout = 4000)
  public void test41()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      assertNotNull(genbankStreamSequence0);
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getACount());
      
      int int0 = genbankStreamSequence0.getOtherCount();
      assertEquals(0, int0);
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getACount());
  }

  @Test(timeout = 4000)
  public void test42()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("uk.ac.sanger.artemis.sequence.SequenceChangeEvent");
      assertNotNull(emblStreamSequence0);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(49, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(2, emblStreamSequence0.getTCount());
      assertEquals(3, emblStreamSequence0.getCCount());
      assertEquals(2, emblStreamSequence0.getGCount());
      assertEquals(38, emblStreamSequence0.getOtherCount());
      assertEquals(4, emblStreamSequence0.getACount());
      
      // Undeclared exception!
      try { 
        emblStreamSequence0.readSequence((LinePushBackReader) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.EmblStreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test43()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.shouldAllThrowIOExceptions();
      assertTrue(boolean0);
      
      String string0 = "ip(H,h";
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("ip(H,h");
      assertNotNull(genbankStreamSequence0);
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(6, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(6, genbankStreamSequence0.getOtherCount());
      
      GenbankStreamSequence genbankStreamSequence1 = (GenbankStreamSequence)genbankStreamSequence0.copy();
      assertNotSame(genbankStreamSequence0, genbankStreamSequence1);
      assertNotSame(genbankStreamSequence1, genbankStreamSequence0);
      assertFalse(genbankStreamSequence1.equals((Object)genbankStreamSequence0));
      assertNotNull(genbankStreamSequence1);
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(6, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(6, genbankStreamSequence0.getOtherCount());
      assertEquals(2, genbankStreamSequence1.getFormatType());
      assertEquals(6, genbankStreamSequence1.getOtherCount());
      assertEquals(6, genbankStreamSequence1.length());
      assertEquals(0, genbankStreamSequence1.getACount());
      assertEquals(0, genbankStreamSequence1.getGCount());
      assertNull(genbankStreamSequence1.getHeader());
      assertEquals(0, genbankStreamSequence1.getCCount());
      assertEquals(0, genbankStreamSequence1.getTCount());
      
      char[] charArray0 = new char[7];
      charArray0[0] = 'o';
      int int0 = genbankStreamSequence0.getFormatType();
      assertNotSame(genbankStreamSequence0, genbankStreamSequence1);
      assertEquals(2, int0);
      assertFalse(genbankStreamSequence0.equals((Object)genbankStreamSequence1));
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(6, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(6, genbankStreamSequence0.getOtherCount());
      
      char char0 = genbankStreamSequence1.charAt(2);
      assertNotSame(genbankStreamSequence0, genbankStreamSequence1);
      assertNotSame(genbankStreamSequence1, genbankStreamSequence0);
      assertEquals('n', char0);
      assertFalse(genbankStreamSequence0.equals((Object)genbankStreamSequence1));
      assertFalse(genbankStreamSequence1.equals((Object)genbankStreamSequence0));
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(6, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(6, genbankStreamSequence0.getOtherCount());
      assertEquals(2, genbankStreamSequence1.getFormatType());
      assertEquals(6, genbankStreamSequence1.getOtherCount());
      assertEquals(6, genbankStreamSequence1.length());
      assertEquals(0, genbankStreamSequence1.getACount());
      assertEquals(0, genbankStreamSequence1.getGCount());
      assertNull(genbankStreamSequence1.getHeader());
      assertEquals(0, genbankStreamSequence1.getCCount());
      assertEquals(0, genbankStreamSequence1.getTCount());
      
      // Undeclared exception!
      try { 
        genbankStreamSequence0.setFromChar((char[]) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test44()  throws Throwable  {
      String string0 = "";
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      assertNotNull(genbankStreamSequence0);
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.length());
      
      int int0 = 0;
      // Undeclared exception!
      try { 
        genbankStreamSequence0.getCharSubSequence(0, 0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // -1
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test45()  throws Throwable  {
      char[] charArray0 = new char[7];
      charArray0[0] = '^';
      charArray0[1] = '@';
      charArray0[2] = '-';
      charArray0[3] = 'F';
      charArray0[4] = 'I';
      charArray0[5] = '5';
      charArray0[6] = 'B';
      Short short0 = new Short((short) (-20));
      assertEquals((short) (-20), (short)short0);
      assertNotNull(short0);
      
      Integer integer0 = new Integer(0);
      assertEquals(0, (int)integer0);
      assertNotNull(integer0);
      
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 0, 0, short0, integer0);
      assertArrayEquals(new char[] {'^', '@', '-', 'F', 'I', '5', 'B'}, charArray0);
      assertEquals(7, charArray0.length);
      assertNotNull(partialSequence0);
      assertEquals(0, partialSequence0.getACount());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals((short) (-20), (short)partialSequence0.getStrand());
      assertEquals(7, partialSequence0.getOtherCount());
      assertFalse(partialSequence0.isComplement());
      
      EmblStreamSequence emblStreamSequence0 = null;
      try {
        emblStreamSequence0 = new EmblStreamSequence(partialSequence0);
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // uk.ac.sanger.artemis.io.PartialSequence cannot be cast to uk.ac.sanger.artemis.io.StreamSequence
         //
         verifyException("uk.ac.sanger.artemis.io.EmblStreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test46()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      assertNotNull(genbankStreamSequence0);
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      
      StringWriter stringWriter0 = new StringWriter();
      assertNotNull(stringWriter0);
      assertEquals("", stringWriter0.toString());
      
      StringWriter stringWriter1 = stringWriter0.append((CharSequence) "");
      assertSame(stringWriter0, stringWriter1);
      assertSame(stringWriter1, stringWriter0);
      assertNotNull(stringWriter1);
      assertEquals("", stringWriter0.toString());
      assertEquals("", stringWriter1.toString());
      
      genbankStreamSequence0.writeToStream(stringWriter1);
      assertSame(stringWriter0, stringWriter1);
      assertSame(stringWriter1, stringWriter0);
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals("BASE COUNT        0 a      0 c      0 g      0 t\nORIGIN\n", stringWriter0.toString());
      assertEquals("BASE COUNT        0 a      0 c      0 g      0 t\nORIGIN\n", stringWriter1.toString());
      
      GenbankStreamSequence genbankStreamSequence1 = (GenbankStreamSequence)genbankStreamSequence0.copy();
      assertNotSame(genbankStreamSequence0, genbankStreamSequence1);
      assertNotSame(genbankStreamSequence1, genbankStreamSequence0);
      assertFalse(genbankStreamSequence1.equals((Object)genbankStreamSequence0));
      assertNotNull(genbankStreamSequence1);
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence1.getOtherCount());
      assertEquals(0, genbankStreamSequence1.getACount());
      assertEquals(0, genbankStreamSequence1.getGCount());
      assertEquals(0, genbankStreamSequence1.getCCount());
      assertNull(genbankStreamSequence1.getHeader());
      assertEquals(2, genbankStreamSequence1.getFormatType());
      assertEquals(0, genbankStreamSequence1.length());
      assertEquals(0, genbankStreamSequence1.getTCount());
      
      StringReader stringReader0 = new StringReader("");
      assertNotNull(stringReader0);
      
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(stringReader0);
      assertNotNull(linePushBackReader0);
      assertEquals(0, linePushBackReader0.getLineNumber());
      
      boolean boolean0 = stringReader0.ready();
      assertTrue(boolean0);
      
      int int0 = linePushBackReader0.read();
      assertEquals((-1), int0);
      assertEquals(0, linePushBackReader0.getLineNumber());
      
      EmblStreamSequence emblStreamSequence0 = null;
      try {
        emblStreamSequence0 = new EmblStreamSequence(linePushBackReader0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.EmblStreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test47()  throws Throwable  {
      LinePushBackReader linePushBackReader0 = null;
      try {
        linePushBackReader0 = new LinePushBackReader((Reader) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.io.Reader", e);
      }
  }

  @Test(timeout = 4000)
  public void test48()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      assertNotNull(genbankStreamSequence0);
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      
      StringWriter stringWriter0 = new StringWriter();
      assertNotNull(stringWriter0);
      assertEquals("", stringWriter0.toString());
      
      StringWriter stringWriter1 = stringWriter0.append((CharSequence) "");
      assertSame(stringWriter0, stringWriter1);
      assertSame(stringWriter1, stringWriter0);
      assertNotNull(stringWriter1);
      assertEquals("", stringWriter0.toString());
      assertEquals("", stringWriter1.toString());
      
      genbankStreamSequence0.writeToStream(stringWriter1);
      assertSame(stringWriter0, stringWriter1);
      assertSame(stringWriter1, stringWriter0);
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals("BASE COUNT        0 a      0 c      0 g      0 t\nORIGIN\n", stringWriter0.toString());
      assertEquals("BASE COUNT        0 a      0 c      0 g      0 t\nORIGIN\n", stringWriter1.toString());
      
      StringReader stringReader0 = new StringReader("KaL");
      assertNotNull(stringReader0);
      
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(stringReader0);
      assertNotNull(linePushBackReader0);
      assertEquals(0, linePushBackReader0.getLineNumber());
      
      boolean boolean0 = stringReader0.ready();
      assertTrue(boolean0);
      
      int int0 = linePushBackReader0.read();
      assertEquals(75, int0);
      assertEquals(0, linePushBackReader0.getLineNumber());
      
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence(linePushBackReader0);
      assertNotNull(emblStreamSequence0);
      assertEquals(1, linePushBackReader0.getLineNumber());
      assertEquals("aL", emblStreamSequence0.getHeader());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getACount());
      
      emblStreamSequence0.readHeader(linePushBackReader0);
      assertEquals(1, linePushBackReader0.getLineNumber());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getACount());
      
      Document document0 = mock(Document.class, new ViolatedAssumptionAnswer());
      IndexedGFFDocumentEntry indexedGFFDocumentEntry0 = null;
      try {
        indexedGFFDocumentEntry0 = new IndexedGFFDocumentEntry(document0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.util.Properties$LineReader", e);
      }
  }

  @Test(timeout = 4000)
  public void test49()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("uk.ac.sanger.artemis.io.StreamSequence");
      assertNotNull(genbankStreamSequence0);
      assertEquals(4, genbankStreamSequence0.getACount());
      assertEquals(38, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getCCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getTCount());
      assertEquals(29, genbankStreamSequence0.getOtherCount());
      
      genbankStreamSequence0.setCounts();
      assertEquals(4, genbankStreamSequence0.getTCount());
      assertEquals(38, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(4, genbankStreamSequence0.getCCount());
      assertEquals(2, genbankStreamSequence0.getGCount());
      assertEquals(20, genbankStreamSequence0.getOtherCount());
      assertEquals(8, genbankStreamSequence0.getACount());
      
      String string0 = "org.biojava.bio.seq.SimpleAssembly";
      char[] charArray0 = new char[9];
      charArray0[0] = '~';
      charArray0[1] = '}';
      charArray0[2] = '+';
      charArray0[3] = '8';
      charArray0[4] = 'N';
      char char0 = 'M';
      // Undeclared exception!
      try { 
        genbankStreamSequence0.charAt(1240);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 619
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test50()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("V6u", "uk.ac.sanger.artemis.io.StreamSequence");
      char[] charArray0 = new char[1];
      charArray0[0] = 'B';
      fastaStreamSequence0.appendChar(charArray0);
      fastaStreamSequence0.forceReset();
      char[] charArray1 = new char[21];
      fastaStreamSequence0.setCounts();
      charArray1[0] = ')';
      charArray1[1] = 'a';
      fastaStreamSequence0.appendChar(charArray1);
      FastaStreamSequence fastaStreamSequence1 = new FastaStreamSequence("V6u", "uk.ac.sanger.artemis.io.StreamSequence");
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence(fastaStreamSequence0);
      LineGroup.getLineType("");
      emblStreamSequence0.getFormatType();
      StringWriter stringWriter0 = new StringWriter(1);
      StringWriter stringWriter1 = stringWriter0.append('.');
      StringWriter stringWriter2 = stringWriter1.append((CharSequence) "V6u");
      fastaStreamSequence0.writeToStream(stringWriter2);
      assertEquals(25, fastaStreamSequence0.length());
  }

  @Test(timeout = 4000)
  public void test51()  throws Throwable  {
      String string0 = "V6u";
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("V6u");
      char[] charArray0 = new char[4];
      fastaStreamSequence0.appendChar(charArray0);
      fastaStreamSequence0.forceReset();
      char[] charArray1 = new char[2];
      fastaStreamSequence0.setCounts();
      charArray1[0] = ')';
      fastaStreamSequence0.appendChar(charArray1);
      // Undeclared exception!
      try { 
        fastaStreamSequence0.copy();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.RawStreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test52()  throws Throwable  {
      String string0 = "ip(H,h";
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("ip(H,h");
      StreamSequence streamSequence0 = genbankStreamSequence0.copy();
      streamSequence0.forceReset();
      streamSequence0.copy();
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("ip(H,h");
      StringReader stringReader0 = new StringReader("ip(H,h");
      stringReader0.ready();
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(stringReader0);
      EntryInformation entryInformation0 = null;
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry((EntryInformation) null);
      PublicDBDocumentEntry publicDBDocumentEntry0 = null;
      try {
        publicDBDocumentEntry0 = new PublicDBDocumentEntry((EntryInformation) null, mSPcrunchDocumentEntry0, true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.SimpleEntryInformation", e);
      }
  }

  @Test(timeout = 4000)
  public void test53()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("JJa01%18");
      int[] intArray0 = new int[6];
      intArray0[0] = (-2924);
      intArray0[1] = 631;
      intArray0[2] = (-113);
      intArray0[3] = 3039;
      intArray0[4] = 1000;
      intArray0[5] = 0;
      rawStreamSequence0.setFastaHeaderPosition(intArray0, intArray0);
      int int0 = (-862);
      // Undeclared exception!
      try { 
        rawStreamSequence0.getSubSequence((-862), 544);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // -432
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }
}
