/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*================================================*/
/*	An XML output class
 *
 *	by Tony Sideris	(09:01PM Mar 25, 2002)
 *================================================*/
#include "arson.h"

#include <qtextstream.h>

#include "xmlwriter.h"

/*========================================================*/

ArsonXmlTag::ArsonXmlTag (ArsonXmlWriter &out, const QString &name)
	: m_out(out), m_name(name)
{
	//	Nothing...
}

/*========================================================*/

void ArsonXmlTag::addAttribute (const QString &name, const QString &value)
{
	m_attr[name] = value;
}

void ArsonXmlTag::addAttribute (const QString &name, int value)
{
	addAttribute(name, QString::number(value));
}

/*========================================================*/

void ArsonXmlTag::begin (void)
{
	startTag(m_out.writer(true), ">");
}

void ArsonXmlTag::end (void)
{
	QTextStream &out = m_out.writer(false);
	out << "</" << m_name << ">\n";
}

/*========================================================*/

void ArsonXmlTag::doit (void)
{
	startTag(m_out.writer(), "/>");
}

/*========================================================*/

QString myXmlEncode (const QString &str)
{
	QString res (str);

	arsonReplace("&", "&amp;", res);
	arsonReplace("<", "&lt;", res);
	arsonReplace(">", "&gt;", res);

	return res;
}

void ArsonXmlTag::startTag (QTextStream &out, const char *close)
{
	Attributes::ConstIterator it, end;

	out << "<" << m_name;

	for (it = m_attr.begin(), end = m_attr.end(); it != end; ++it)
		out << " " << it.key() << "=\"" << myXmlEncode(it.data()) << "\"";

	out << close << "\n";
}

/*========================================================*/

ArsonXmlWriter::ArsonXmlWriter (QTextStream &out, const QString &name)
	: ArsonXmlTag(*this, name),
	m_level(0),
	m_out(out)
{
	//	Nothing...
}

/*========================================================*/

void ArsonXmlWriter::begin (void)
{
	out() << "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n";
	ArsonXmlTag::begin();
}

/*========================================================*/

void ArsonXmlWriter::doit (void)
{
#ifdef ARSONDBG
	Assert(false && "doit() in the writer makes no sense!");
#endif	//	ARSONDBG
}

/*========================================================*/

QTextStream &ArsonXmlWriter::writer (bool begin)
{
	out() << indentation(begin ? indent : unindent);
	return out();
}

QTextStream &ArsonXmlWriter::writer (void)
{
	out() << indentation(none);
	return out();
}

/*========================================================*/

QString ArsonXmlWriter::indentation (int how)
{
	QString res;
	res.fill(QChar(' '), m_level);

	m_level += how;

	Assert(m_level >= 0);
	return res;
}

/*========================================================*/
