/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#include "tString.h"
#include <ctype.h>


tString::tString(){  
  operator[](0)='\0';
}

tString::tString(const char *x){
  operator[](0)='\0';
  operator+=(x);
}

tString::tString(const tString &x){
  operator[](0)='\0';
  operator+=(x);
}

void tString::ReadLine(istream &s){
  char c=' ';
  int i=0;
  SetLen(0);
  while(c!='\n' && isspace(c) &&  s.good() && !s.eof()){
    c=s.get();
  }

  s.putback(c);
  c='x';

  while(c!='\n' &&  s.good() && !s.eof()){
    c=s.get();
    operator[](i++)=c;
  }
  if (i>0)
    operator[](i-1)='\0';
  else
    operator[](0)='\0';
}

/*
tString & tString::operator<<(const char *c){
  return operator+=(c);
}
*/

tString & tString::operator+=(const char *c){
  if (c){
    int i=Len()-1;
    if (i<0) i=0;
    while (*c!='\0'){
      operator[](i)=*c;
      i++;
      c++;
    }
    operator[](i)='\0';
  }
  return *this;
}

tString & tString::operator=(const char *c){
  Clear();
  return operator+=(c);
}


tString tString::operator+(const char *c) const{
  tString s(*this);
  return s+=c;
  //return s;
}

tString::operator const char *() const{
  if (Len())
    return &operator()(0);
  else
    return "";
}

/*
tString & tString::operator<<(char c){
  return operator+=(c);
}
*/

tString & tString::operator+=(char c){
  int i=Len();
  if (i<=0) i=1;
  operator[](i-1)=c;
  operator[](i)='\0';
  return *this;
}

tString tString::operator+(char c) const{
  tString s(*this);
  return s+=c;
  //return s;
}

ostream & operator<< (ostream &s,const tString &x){
  if(x.Len())  
    return s << &(x(0));
  else 
    return s;
}

istream & operator>> (istream &s,tString &x){
  char c=' ';
  int i=0;
  x.SetLen(0);

  while(isspace(c) && s.good() && !s.eof()) c=s.get();
 
  while(!isspace(c) && s.good() && !s.eof()){
    x[i++]=c;
    c=s.get();
  }
  s.putback(c);
  x[i]='\0';
  return s;
}


void tString::SetPos(int l){
  int i;
  for(i=Len();i<l;i++)
    operator+=(' ');
}

// char st_stringOutputBuffer[tMAX_STRING_OUTPUT];


/*
void operator <<(tString &s,const char * c){
  strstream S(st_stringOutputBuffer,tMAX_STRING_OUTPUT-1);
  S << c << '\0';
  s+=st_stringOutputBuffer;
}

void operator <<(tString &s,const unsigned char * c){
  strstream S(st_stringOutputBuffer,tMAX_STRING_OUTPUT-1);
  S << c << '\0';
  s+=st_stringOutputBuffer;
}

void operator <<(tString &s,int c){
  strstream S(st_stringOutputBuffer,tMAX_STRING_OUTPUT-1);
  S << c << '\0';
  s+=st_stringOutputBuffer;
}

void operator <<(tString &s,float c){
  strstream S(st_stringOutputBuffer,tMAX_STRING_OUTPUT-1);
  S << c << '\0';
  s+=st_stringOutputBuffer;
}
*/





