/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#ifndef ArmageTron_tMemManager_H
#define ArmageTron_tMemManager_H

#include "new.h"

#ifndef _MSC_VER
#ifndef _cdecl
#define _cdecl
// #include "windef.h"
#endif
#endif

#include <stdlib.h>

class tMemMan{
 public:
  static void *Alloc(size_t s);
  static void  Dispose(void *p);
  static void  DisposeButKeep(void *p);
  static void  Check();
  static void  Profile();
};

#ifdef WIN32
#ifdef DEBUG
//#define DONTUSEMEMMANAGER
#endif
#endif

#ifdef _MSC_VER
//#define THROW_BADALLOC _THROW1(std::bad_alloc)
//#define THROW_NOTHING  _THROW0()
#define THROW_BADALLOC
#define THROW_NOTHING
#else
#define THROW_BADALLOC throw (std::bad_alloc)
#define THROW_NOTHING  throw ()
#endif


#ifndef DONTUSEMEMMANAGER
void* _cdecl operator new	(unsigned int size) THROW_BADALLOC; 
void  _cdecl operator delete   (void *ptr)  THROW_NOTHING;
void  operator delete   (void *ptr,bool keep) THROW_NOTHING;
void* operator new	(unsigned int size,const char *classn,const char *file,int line)  THROW_BADALLOC;
void  operator delete   (void *ptr,const char *classn, const char *file,int line)  THROW_NOTHING;
void* operator new[]	(unsigned int size)  THROW_BADALLOC;
void  operator delete[]   (void *ptr) THROW_NOTHING;
void* operator new[]	(unsigned int size,const char *classn,const char *file,int line)  THROW_BADALLOC;
void  operator delete[]   (void *ptr,const char *classname,const char *file,int line)  THROW_NOTHING;


void * operator new(
        unsigned int cb,
        int nBlockUse,
        const char * szFileName,
        int nLine
        );

#define tNEW(x) new(#x,__FILE__,__LINE__) x

#define tMEMMANAGER(classname)  public:void *operator new(size_t s){return tMemMan::Alloc(s); }  void operator delete(void *p){  if (p) tMemMan::Dispose(p); }
#else
#define tNEW(x) new x
#define tMEMMANAGER(classname)  

#endif

#endif
