/* $Id: ArkFontBitmap.h,v 1.3 2002/10/20 19:42:56 mrq Exp $
** 
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2000 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef FONT_BITMAP_H
#define FONT_BITMAP_H

#include <Ark/Ark.h>
#include <Ark/ArkMaterial.h>
#include <Ark/ArkFont.h>
#include <Ark/ArkRenderer.h>

namespace Ark
{

   class BitmapFontData;
   class ARK_DLL_API BitmapFont : public Font
   {
	 BitmapFontData *m_BmData;
	 BitmapFont *m_RefFont;

	 int m_Size;
	 Color m_Color;

      public:
	 BitmapFont(const String &name);
	 ~BitmapFont();

	 virtual bool Load (Cache *cache, const String &filename);

         virtual bool GetStringSize (const String &string, int *w, int *h);

         /// Get the bounds of a string using this font and properties.
         virtual bool GetStringBounds (const String &string,
                                       FontAlignment align,
                                       int *min, int *max);

         /// Draw a string using this font.
         virtual bool DrawString (Renderer &render,
                                  const String &string,
                                  int x, int y,
                                  FontAlignment align = CENTER_LEFT);
   };

} // namespace Ark

#endif // FONT_BITMAP_H
