# Arch Perl library, Copyright (C) 2004 Mikhael Goikhman, Enno Cramer, 2005 Thomas Gerigk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use 5.006;
use strict;
use warnings;

package ArchWay::Widget::PartnerVersions_indexed;

use Glib qw(TRUE FALSE);
use Gtk2;

use base qw(ArchWay::Widget::PartnerVersions);

use ArchWay::Util::TreeVersions;

use constant FIELDS => qw(index archive version type kinship role label);
use constant LABELS => qw(Index Archive Version Type Kinship Role Label);

sub new ($$$) {
	my $class = shift;
	my $treeversions = shift || die "No TreeVersions given";
	my $window = shift || die "No window given";

	my $model = Gtk2::ListStore->new(('Glib::String') x scalar(LABELS));
	my $self = bless Gtk2::TreeView->new_with_model($model), $class;

	$self->{tree} = $treeversions->tree;
	$self->{window} = $window;
	$self->{version_store} = $treeversions;;
	$self->_init;

	return $self;
}

sub _init ($) {
	my $self = shift;

	$self->set_border_width(3);

	for (my $col = 0; $col < scalar(LABELS); ++$col) {
		my $title = (LABELS)[$col];
		my $column = Gtk2::TreeViewColumn->new_with_attributes(
			(LABELS)[$col], Gtk2::CellRendererText->new(),
			text => $col,      
		);
		$column->set_resizable(TRUE);
		$column->set_sort_column_id($col);

		$self->append_column($column);
		$self->{(FIELDS)[$col]} = $col;
	}

	my $model = $self->get_model;
	my $version_entries = $self->{version_store}->all;
	my @versions = sort keys %$version_entries;
	$self->{versions} = { map { $_ => 1 } @versions };

	foreach my $version (@versions) {
		my $entry = $version_entries->{$version};
		$version =~ s!^(.*)/!! || die "Invalid version $version";
		my $archive = $1;

		my $values = {
			archive => $archive,
			version => $version,
			type    => $entry->{type},
			kinship => $entry->{kinship},
			role    => $entry->{role},
			label   => $entry->{label} || "(none)",
		};
		my $iterator = $model->append;
		for my $field (FIELDS) {
			$model->set($iterator, $self->{$field}, $values->{$field});
		}
	}
}

sub set_index {
	my $self = shift;
	my $index = shift;
	my $fversion = shift;
	
	my $model = $self->get_model();
	my $iter = $model->get_iter_first();
	$fversion =~ /^(.+?)\/(.*)$/;
	my $archive = $1;
	my $version =  $2;

	my $iter_old_index = undef;
	my $iter_new_index = undef;
	while ( defined $iter ) {
		if ( $archive eq $model->get($iter, $self->{archive})
			 && $version eq $model->get($iter, $self->{version}) ) {
			$iter_new_index = $iter;
		}
		if ( defined $model->get($iter, $self->{index})
			 && $index eq $model->get($iter, $self->{index}) ) {
			$iter_old_index = $iter;
		}
		$iter = $model->iter_next( $iter );
	}
	if ( defined $iter_new_index ) {
		$model->set($iter_new_index, $self->{index}, $index);
		if ( defined $iter_old_index ) {
			$model->set($iter_old_index, $self->{index}, undef);
		}
	}
	
}

1;

__END__
