/* file-metadata.c
 *
 ****************************************************************
 * Copyright (C) 2001, 2002  Tom Lord
 * 
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */


#include "config-options.h"
#include "hackerlab/cmd/main.h"



static t_uchar * program_name = "file-metadata";
static t_uchar * usage = "file-metadata [options] file...";
static t_uchar * version_string = (cfg__std__package " from regexps.com\n"
				   "\n"
				   "Copyright 2001, 2002 Tom Lord\n"
				   "\n"
				   "This is free software; see the source for copying conditions.\n"
				   "There is NO warranty; not even for MERCHANTABILITY or FITNESS FOR A\n"
				   "PARTICULAR PURPOSE.\n"
				   "\n"
				   "Report bugs to <lord@regexps.com>.\n"
				   "\n");

#define OPTS(OP, OP2) \
  OP (opt_help_msg, "h", "help", 0, \
      "Display a help message and exit.") \
  OP (opt_long_help, "H", 0, 0, \
      "Display a verbose help message and exit.") \
  OP (opt_version, "V", "version", 0, \
      "Display a release identifier string") \
  OP2 (opt_version, 0, 0, 0, "and exit.") \
  OP (opt_symlink, 0, "symlink", 0, \
      "Report metadata for symlink, not link target.") \
  OP (opt_permissions, 0, "permissions", 0, \
      "Report file permissions.") \
  OP (opt_mtime, 0, "mtime", 0, \
      "Report file modification time.")

static t_uchar long_help[] = ("Report attributes of FILE.\n"
			      "Set attributes of FILE.  With \"--symlink\", set attributes\n"
			      "of the symbolic link, rather than the file pointed to by the link.\n"
			      "(Attempting to set some attributes of a symbolic link has no effect.)\n"
			      "\n"
			      "The output of this command is suitable for use as options\n"
			      "to the command `set-file-metadata'.\n");

enum options
{
  OPTS (OPT_ENUM, OPT_IGN)  
};

struct opt_desc opts[] = 
{
  OPTS (OPT_DESC, OPT_DESC)
    {-1, 0, 0, 0, 0}
};



int
main (int argc, char * argv[])
{
  int o;
  struct opt_parsed * option;
  int symlink;
  int permissions;
  int mtime;

  safe_buffer_fd (1, 0, O_WRONLY, 0);

  symlink = 0;
  permissions = 0;
  mtime = 0;

  option = 0;

  while (1)
    {
      o = opt_standard (lim_use_must_malloc, &option, opts, &argc, argv, program_name, usage, version_string, long_help, opt_help_msg, opt_long_help, opt_version);
      if (o == opt_none)
	break;
      switch (o)
	{
	default:
	  safe_printfmt (2, "unhandled option `%s'\n", option->opt_string);
	  panic ("internal error parsing arguments");

	usage_error:
	  opt_usage (2, argv[0], program_name, usage, 1);
	  exit (1);

	/* bogus_arg: */
	  safe_printfmt (2, "ill-formed argument for `%s' (`%s')\n", option->opt_string, option->arg_string);
	  goto usage_error;

	case opt_symlink:
	  symlink = 1;
	  break;

	case opt_permissions:
	  permissions = 1;
	  break;

	case opt_mtime:
	  mtime = 1;
	  break;
	}
    }


  {
    int arg;
    int (*stat_fn) ();

    if (symlink)
      stat_fn = safe_lstat;
    else
      stat_fn = safe_stat;

    for (arg = 1; arg < argc; ++arg)
      {
	struct stat stat_buf;
	int want_space;

	stat_fn (argv[arg], &stat_buf);

	want_space = 0;

	if (permissions)
	  {
	    safe_printfmt (1, "--permissions %lo", (unsigned long)(stat_buf.st_mode & (S_IRWXU | S_IRWXG | S_IRWXO)));
	    want_space = 1;
	  }

	if (mtime)
	  {
	    safe_printfmt (1, "%s--mtime %lu", (want_space ? " " : ""), (unsigned long)(stat_buf.st_mtime));
	    want_space = 1;
	  }

	safe_printfmt (1, "\n");
      }
  }
  return 0;
}

/* tag: Tom Lord Tue Dec  4 14:41:55 2001 (file-metadata.c)
 */
