# 
# heading.sh: format outline-style output (headings)
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

################################################################
# special options
# 
# Some options are special:
# 
#	--version | -V
#	--help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
		printf "format outline-style output (headings)\\n"
		printf "usage: heading [options] format [value...]\\n"
		printf "\\n"
		printf " -V --version                  print version info\\n"
		printf " -h --help                     display help\\n"
		printf "\\n"
		printf " --sub                         print a sub-heading\\n"
		printf " --html                        generate html instead of outline\\n"
		printf "\\n"
		printf "Print an outline heading at the current level (or indicated\\n"
		printf "sub-level)\\n"
		printf "\\n"
		exit 0
      		;;

      *)
		;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

sublvl=
html=

while test $# -ne 0 ; do

  case "$1" in 

    --sub)		shift
    			sublvl="$sublvl*"
			;;

    --html)		shift
    			html=--html
			;;

    --)			shift
    			break
			;;

    -*)			printf "heading: unrecognized option (%s)\\n" "$1" 1>&2
			printf "try --help\\n" 1>&2
			exit 1
			;;

    *)			break
    			;;

  esac

done



################################################################
# Print Asterisks
# 

if test -z "$ARCH__OUTLINE_DEPTH" ; then
  ARCH__OUTLINE_DEPTH="*"
fi

if test -z "$html" ; then
  printf "%s%s "  "$ARCH__OUTLINE_DEPTH" "$sublvl"
  printf "$@"
  echo
else
  printf "<H%d>" $((${#ARCH__OUTLINE_DEPTH} + ${#sublvl}))
  printf "$@" \
  | sed -e '{
	      s/&/\&amp;/g
	      s/</\&lt;/g
	      s/>/\&gt;/g
  	      s/"/\&quot;/g
	    }'

  printf "</H%d>\\n\\n" $((${#ARCH__OUTLINE_DEPTH} + ${#sublvl}))
fi

# tag: Tom Lord Wed Dec 12 05:51:49 2001 (output/heading.sh)
#
