# 
# wd-mv-pristine.sh - place a pristine tree in a project tree
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

################################################################
# special options
# 
# Some options are special:
# 
#	--version | -V
#	--help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
		printf "*move a local pristine tree in to a project tree\'s cache\\n"
		printf "usage: wd-mv-pristine [options] archive revision pristine [dir]\\n"
		printf "\\n"
		printf " -V --version                  print version info\\n"
		printf " -h --help                     display help\\n"
		printf "\\n"
		printf " --lock                        save in a locked state\\n"
		printf "\\n"
		printf "Move the pristine revision tree to the cache in project tree\\n"
		printf "DIR (or the current directory)."
		printf "\\n"
		exit 0
      		;;

      *)
		;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

lock=

while test $# -ne 0 ; do

  case "$1" in 

    --lock)		shift
    			lock=--lock
			;;

    --)			shift
    			break
			;;

    -*)			printf "wd-mv-pristine: unrecognized option (%s)\\n" "$1" 1>&2
			printf "try --help\\n" 1>&2
			exit 1
			;;

    *)			break
    			;;
  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -lt 3 -o $# -gt 4  ; then
  printf "usage: wd-mv-pristine [options] archive revision pristine [dir]\\n" 1>&2
  printf "try --help\\n" 1>&2
  exit 1
fi


archive="$1"
shift

revision="$1"
shift

pristine="$1"
shift

here="`pwd`"
cd "$pristine"
pristine="`pwd`"
cd "$here"

if test $# -eq 1 ; then
  dir="$1"
else
  dir="."
fi

cd "$dir"
dir="`pwd`"

################################################################
# Sanity Check and Process Defaults
# 

larch valid-archive-name -e wd-mv-pristine -- "$archive"
larch valid-package-name -e wd-mv-pristine -l -- "$revision"
if test ! -d "$pristine" ; then
  printf "wd-mv-pristine: not a directory (%s)\\n" 1>&2
  exit 1
fi

cd "$dir"
wdroot="`larch tree-root`"

base=`larch parse-package-name -b "$revision"`
branch=`larch parse-package-name "$revision"`
version=`larch parse-package-name --package-version "$revision"`

if test -z "$lock" ; then
  state=unlocked
else
  state=locked
fi

dest="$wdroot/{arch}/++pristine-trees/$state/$base/$branch/$version/$archive/$revision"

################################################################
# Move It.
# 

mkdir -p "`dirname \"$dest\"`"
mv "$pristine" "$dest"

