# 
# make-cache-temp-dir.sh - Create a temp dir in the user's cache
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

################################################################
# special options
# 
# Some options are special:
# 
#	--version | -V
#	--help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
		printf "create a temp dir in the user's arch cache\\n"
		printf "usage: make-cache-temp-dir [options] id\\n"
		printf "\\n"
		printf " -V --version                  print version info\\n"
		printf " -h --help                     display help\\n"
		printf "\\n"
		printf "Create a temp directory in the user's cache.\\n"
		printf "\\n"
		printf "ID is a string used to form the name of the cache\\n"
		printf "directory.  It should contain, as a substring, a process\\n"
		printf "id of a process that will continue to exist for as long\\n"
		printf "as the directory is needed.\\n"
		printf "\\n"
		printf "If a temp directory with the same ID already exists,\\n"
		printf "it is removed on the presumption that it is from a \\n"
		printf "now-dead process.\\n"
		printf "\\n"
		exit 0
      		;;

      *)
		;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

while test $# -ne 0 ; do

  case "$1" in 

    -*)			printf "make-cache-temp-dir: unrecognized option (%s)\\n" "$1" 1>&2
			printf "try --help\\n" 1>&2
			exit 1
			;;

    *)			break
    			;;

  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -ne 1 ; then
  printf "usage: make-cache-temp-dir [options] id\\n" 1>&2
  printf "try --help\\n" 1>&2
  exit 1
fi

id="$1"

################################################################
# Find the user's cache dir:
# 

cache="`larch cache-dir`"

################################################################
# Make a temp directory.
# 

cd "$cache"

if test ! -e tmp-dirs ; then
  mkdir tmp-dirs
fi

cd tmp-dirs

procdir="tmp-$id"

if test -e "$procdir" ; then
  # presume that an old temp directory got left over
  rm -rf "$procdir"
fi

mkdir "$procdir"

###############################################################
# Return the directory name to the caller:
# 
cd "$procdir"
pwd


