# 
# move.sh - move an explicit tag for a file
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

################################################################
# special options
# 
# Some options are special:
# 
#       --version | -V
#       --help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
                printf "move an explicit inventory tag\\n"
                printf "usage: move [options] old-name new-name \\n"
                printf "\\n"
                printf " -V --version                  print version info\\n"
                printf " -h --help                     display help\\n"
                printf "\\n"
                printf "Move an explicit inventory tag for FILE (which may be a regular\\n"
		printf "file or symbolic link but which must not be a directory).\\n"
                printf "\\n"
                exit 0
                ;;

      *)
                ;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

while test $# -ne 0 ; do

  case "$1" in 

    --)			shift
    			break
			;;
			
    -*)                 printf "move: unrecognized option (%s)\\n" "$1" 1>&2
                        printf "try --help\\n" 1>&2
                        exit 1
                        ;;

    *)                  break
                        ;;
  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -ne 2 ; then
  printf "usage: move [options] old-name new-name\\n" 1>&2
  printf "try --help\\n" 1>&2
  exit 1
fi

file="$1"
shift

new_name="$1"
shift

################################################################
# Sanity Check and Process Defaults
# 

if test -d "$file" ; then
  printf "move: can not move directory tags\\n" 1>&2
  printf "  (move the entire directory instead)\\n" 1>&2
  printf "\\n" 1>&2
  exit 1
else
  file_dir="`dirname \"$file\"`"
  file_basename="`basename \"$file\"`"
  id_file="$file_basename.id"
fi

cd "$file_dir"
file_dir="`pwd`"
wdroot="`larch tree-root`"



if test -d "$new_file" ; then
  printf "move: can not move directory tags\\n" 1>&2
  printf "  (move the entire directory instead)\\n" 1>&2
  printf "\\n" 1>&2
  exit 1
else
  new_dir="`dirname \"$new_name\"`"
  new_basename="`basename \"$new_name\"`"
  new_id_file="$new_basename.id"
fi

cd "$new_dir"
new_dir="`pwd`"
new_wdroot="`larch tree-root`"

if test "$wdroot" != "$new_wdroot" ; then
  printf "move: can not move files between project tree\\n" 1>&2
  printf "\\n"
  exit 1
fi


################################################################
# Record
# 

cd "$file_dir"

if test ! -e ".arch-ids/$id_file" ; then
  printf "move: old-name not previously added\\n" 1>&2
  printf "\\n" 1>&2
  exit 1
fi

cd "$new_dir" 

if test ! -d ".arch-ids" ; then
  mkdir .arch-ids
fi

if test -e ".arch-ids/$new_id_file" ; then
  printf "move: new name already in use\\n" 1>&2
  printf "\\n" 1>&2
  exit 1
fi

mv "$file_dir/.arch-ids/$id_file" ".arch-ids/$new_id_file"

