# 
# copy-from-archive-cache.sh - try to get an archive cached rvsn
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

command_line="$*"

################################################################
# special options
# 
# Some options are special:
# 
#	--version | -V
#	--help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
		printf "try to copy a revision from an archive\'s cache\\n"
		printf "usage: copy-from-archive-cache [options] revision\\n"
		printf "\\n"
		printf " -V --version                  print version info\\n"
		printf " -h --help                     display help\\n"
		printf "\\n"
		printf " --silent                      no output (except odd errors)\\n"
		printf " --quiet                       brief output\\n"
		printf " --report                      default output\\n"
		printf " --verbose                     maximal output\\n"
		printf " --debug                       debugging output\\n"
		printf "\\n"
		printf "Look for a cached copy of REVISION in an archive.  If one is found,\\n"
		printf "copy it to the current directory and exit with status 0.  Otherwise,\\n"
		printf "exit with status 1.\\n"
		printf "\\n"
		exit 0
      		;;

      *)
		;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

quiet=--quiet
report=--report
verbose=

while test $# -ne 0 ; do

  case "$1" in 

    --silent)	shift
    		quiet=
		report=
		verbose=
		;;

    --quiet)	shift
    		quiet=--quiet
		report=
		verbose=
		;;

    --report)	shift
    		quiet=--quiet
		report=--report
		verbose=
		;;

    --verbose)	shift
    		quiet=--quiet
		report=--report
		verbose=--verbose
		;;

    --debug)	shift
    		larch heading "copy-from-archive-cache: debugging output enabled\\n"
    		set -x
		;;

    --)			shift
			break
			;;

    -*)			printf "copy-from-archive-cache: unrecognized option (%s)\\n" "$1" 1>&2
			printf "try --help\\n" 1>&2
			exit 1
			;;

    *)			break
    			;;

  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -ne 1 ; then
  printf "usage: copy-from-archive-cache [options] revision\\n" 1>&2
  printf "try --help\\n" 1>&2
  exit 1
fi

revision="$1"
shift

################################################################
# Sanity Check and Process Defaults
# 

larch valid-package-name -l -e copy-from-archive-cache -- "$revision"

category=`larch parse-package-name -b $revision`
branch=`larch parse-package-name $revision`
vsn=`larch parse-package-name -v $revision`
lvl=`larch parse-package-name -l $revision`

################################################################
# Greetings
# 
# This is an internal command.
# 

if test ! -z "$verbose" ; then 
  ARCH__OUTLINE_DEPTH="$ARCH__OUTLINE_DEPTH*"
  larch heading "copy-from-archive-cache\\n"
  printf "arguments: %s\\n" "$command_line" | fold -w 60 | larch body-indent
  larch heading --sub "copy-from-archive-cache start time: %s\\n" "`date`"
  larch heading --sub "seeking revision: %s\\n" "$branch--$vsn--$lvl"
  larch heading --sub "from archive: %s\\n" "$WITHARCHIVE"
  larch heading --sub "to store in: %s\\n" "`pwd`"
fi


################################################################
# Look for Cached Copies
# 

wftp-home
wftp-cd "$category/$branch/$branch--$vsn/$lvl"

if ! wftp-get $branch--$vsn--$lvl.tar.gz > ,,$branch--$vsn--$lvl.tar.gz 2> /dev/null ; then

  rm -f ,,$branch--$vsn--$lvl.tar.gz

  if test ! -z "$verbose" ; then
    larch heading --sub "no cached copy found\\n"
    larch heading --sub "copy-from-archive-cache finish time: %s\\n" "`date`"
  fi
  exit 1

else


  if test ! -z "$report" ; then
    larch heading --sub "revision found cached in archive: %s\\n" $branch--$vsn--$lvl
  fi

  here="`pwd`"
  mkdir ,,$branch--$vsn--$lvl
  cd  ,,$branch--$vsn--$lvl

  if test ! -z "$verbose" ; then
    tar -m -zvxf ../,,$branch--$vsn--$lvl.tar.gz | larch body-indent --sub
  else
    tar -m -zxf ../,,$branch--$vsn--$lvl.tar.gz
  fi

  cd $branch--$vsn--$lvl
  for f in `ls -a | grep -v -E "^\\.\\.?\$"` ; do
    mv "$f" "$here"
  done
  cd "$here"
  rm -rf ",,$branch--$vsn--$lvl"
  rm -rf ",,$branch--$vsn--$lvl.tar.gz"

fi

