/***************************************************************************
 $RCSfile: modifymedium.cpp,v $
                             -------------------
    cvs         : $Id: modifymedium.cpp,v 1.8 2003/05/18 03:02:12 aquamaniac Exp $
    begin       : Sun Mar 02 2003
    copyright   : (C) 2003 by Fabian Kaiser
    email       : openhbci@derzach.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


/*
 */
#include "modifymedium.h"


HBCI::Error modifyMedium(HBCI::Pointer<AQMAPI> hbciif,
			 HBCI::SimpleConfig &opt){

  HBCI::Tree<HBCI::ConfigNode>::iterator var;
  int country;
  string instid;
  string userid;
  HBCI::Error err;
  HBCI::Pointer<HBCI::User> user;
  HBCI::Pointer<HBCI::Customer> cust;

  country=opt.getIntVariable("country",280,opt.root());
  instid=opt.getVariable("instid","*",opt.root());
  userid=opt.getVariable("user","",opt.root());

  // get the user
  user = hbciif.ref().findUser(country, instid, userid);
  if (!user.isValid())
    return HBCI::Error("modifyMedium()",
		       ERROR_LEVEL_NORMAL,
		       0,
		       ERROR_ADVISE_DONTKNOW,
		       "user not found");
  instid = user.ref().bank().ref().bankCode();

  // ... and the medium
  HBCI::Pointer<HBCI::Medium> medium = user.ref().medium();
  while (medium.ref().isMounted())
    medium.ref().unmountMedium();

  try {
    // the new data
    string newInstid = opt.getVariable("newinstitute", "", opt.root());
    string newUserid = opt.getVariable("newuser", "", opt.root());
    string newCustid = opt.getVariable("newcustomer", "", opt.root());
    string newServer = opt.getVariable("newserver", "", opt.root());
    int newSEQ = opt.getIntVariable("newseq", -1, opt.root());

    // loop through the (multiple) contexts
    int context = 1;
    while (! (newInstid.empty() && newUserid.empty() &&
	      newCustid.empty() && newServer.empty())) {
      int cCountry;
      string cInstid;
      string cUserid;
      string cServer;
      // we need to mount the medium in order to get the contexts
      if (! medium.ref().mountMedium().isOk())
	return HBCI::Error("modifyMedium()",
			   ERROR_LEVEL_NORMAL,
			   0,
			   ERROR_ADVISE_DONTKNOW,
			   "could not mount medium");

      // the next context, if this fails we are done
      if (!(medium.ref().getContext(context, cCountry,
				    cInstid, cUserid, cServer)).isOk())
	break;

      // does the context match
      if (cCountry == country &&
	  cInstid == instid &&
	  cUserid == userid) {

	char input;
	fprintf(stdout, "change context %d (y|n)?", context);
	input = fgetc(stdin);
	if ('Y' == input || 'y' == input) {
	  // ok, try to change it
	  err=medium.ref().changeContext(context, 0, newInstid,
					 newUserid, newCustid, newServer);
	  if (err.isOk()) {
	    if (! newInstid.empty())
	      fprintf(stdout, "institute id changed to %s\n",
		      newInstid.c_str());
	    if (! newUserid.empty())
	      fprintf(stdout, "user id changed to %s\n",
		      newUserid.c_str());
	    if (! newCustid.empty())
	      fprintf(stdout, "customer id changed to %s\n",
		      newCustid.c_str());
	    if (! newServer.empty())
	      fprintf(stdout, "server address changed to %s\n",
		      newServer.c_str());
	  } else {
	    fprintf(stderr, "content could not be changed (%s)\n",
		    err.errorString().c_str());
	  }
	} // user wants to change the context
      } // matching context
      context++;
    } // context loop

    // shall we reset the system id stored on the medium?
    if (opt.findVariable("resetsystemid", opt.root(), false).isValid()) {
      if (HBCI_SECURITY_RDH != medium.ref().securityMode())
	fprintf(stderr, "can't reset the system id with non-RDH mediums\n");
      else {
	if (! medium.ref().isMounted())
	  medium.ref().mountMedium();
	medium.cast<HBCI::MediumRDHBase>().ref().setSystemId("");
	fprintf(stdout, "system id reset\n");
      }
    }

    // shall we set the SEQ directly ?
    if (newSEQ!=-1) {
      if (HBCI_SECURITY_RDH != medium.ref().securityMode())
	fprintf(stderr,
		"Signaturzhler kann nur bei RDH-Medien gesetzt werden.\n");
      else {
	if (! medium.ref().isMounted())
	  medium.ref().mountMedium();
	medium.cast<HBCI::MediumRDHBase>().ref().setSEQ(newSEQ);
	fprintf(stdout, "Signaturzhler gesetzt\n");
      }
    }

    // shall we change the pin?
    if (opt.findVariable("newpin", opt.root(), false).isValid()) {
      if ((medium.ref().changePIN()).isOk()) {
	fprintf(stderr,"Ok, PIN geaendert.\n");
      }
      else {
	fprintf(stderr,"Pin nicht geaendert.\n");
      }
    }

    // unmount the medium and write the data
    while (medium.ref().isMounted())
      medium.ref().unmountMedium();


  } catch (HBCI::Error lerr) {
    err=lerr;
  }

  return err;
}


