/***************************************************************************
 $RCSfile: main.cpp,v $
                             -------------------
    cvs         : $Id: main.cpp,v 1.39 2003/07/28 23:51:49 aquamaniac Exp $
    begin       : Sat Jan 26 2002
    copyright   : (C) 2002 by Martin Preuss
    email       : martin@aquamaniac.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


// general includes

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include <openhbci.h>

#include "aqminteractor.h"
#include "aqmprogressmonitor.h"
#include "pinmanager.h"

// the modules of aqmoney
#include "aqmapi.h"
#include "getbalance.h"
#include "createuser.h"
#include "getkeys.h"
#include "sendkeys.h"
#include "iniletter.h"
#include "turnover.h"
#include "acclist.h"
#include "dump.h"
#include "accadd.h"
#include "transfer.h"
#include "sync.h"
#include "export.h"
#include "getstandingorders.h"
#include "newstandingorder.h"
#include "delstandingorder.h"
#include "createcustomer.h"
#include "resetseq.h"
#include "report.h"
#include "disablekeys.h"
#include "changekeys.h"
#include "modifymedium.h"
#include "chgversion.h"
#include "pluginlist.h"
#include "getstatus.h"
#include "convert.h"
#include "mkpinlist.h"
#include "setproperty.h"
#include "getproperty.h"

#include <time.h>
#include <unistd.h>


s_CmdLineOptionDescr options[]={
{
  "user",                                    // config item name
  CLO_FLAGS_HAS_ARGUMENT,                    // flags
  "user",                                    // long option name
  "u",                                       // short option name
  "userid assigned to you by your institute" // description
},
{
  "customer",                                // config item name
  CLO_FLAGS_HAS_ARGUMENT,                    // flags
  "customer",                                // long option name
  "",                                        // short option name
  "customerid assigned to you by your institute" // description
},
{
  "role",                                    // config item name
  CLO_FLAGS_HAS_ARGUMENT,                    // flags
  "role",                                    // long option name
  "",                                        // short option name
  "role of the customer (e.g. \"private\")"  // description
},
{
  "mediumtype",                              // config item name
  CLO_FLAGS_HAS_ARGUMENT,                    // flags
  "mediumtype",                              // long option name
  "",                                        // short option name
  "either \"file\" or \"card\""              // description
},
{
  "ro-medium",                              // config item name
  0,                    // flags
  "ro-medium",                              // long option name
  "",                                        // short option name
  "for cards that do not allow to write to them"     // description
},
{
  "instid",
  CLO_FLAGS_HAS_ARGUMENT,
  "institute",
  "i",
  "code of your credit institute (\"Bankleitzahl\")"
},
{
  "country",
  CLO_FLAGS_HAS_ARGUMENT,
  "country",
  "c",
  "country code (\"280\" for Germany)"
},
{
  "baks",
  CLO_FLAGS_HAS_ARGUMENT,
  "baks",
  "",
  "number of backup files to create"
},
{
  "hversion",
  CLO_FLAGS_HAS_ARGUMENT,
  "hversion",
  "",
  "HBCI version to set by command \"chgversion\""
},
{
  "medium",
  CLO_FLAGS_HAS_ARGUMENT,
  "medium",
  "",
  "DDV: cardnumber, RDH: path to the file to create"
},
{
  "server",
  CLO_FLAGS_HAS_ARGUMENT,
  "server",
  "",
  "ip address of the institutes server"
},
{
  "key",
  CLO_FLAGS_HAS_ARGUMENT,
  "key",
  "",
  "key to select (\"user\" OR \"institute\")"
},
{
  "output",
  CLO_FLAGS_HAS_ARGUMENT,
  "output",
  "o",
  "what to output (txt OR html"
},
{
  "accnr",
  CLO_FLAGS_HAS_ARGUMENT,
  "account",
  "a",
  "account number"
},
{
  "cmd",
  CLO_FLAGS_HAS_ARGUMENT,
  "command",
  "d",
  "what to do (see man)"
},
{
  "debuglevel",
  CLO_FLAGS_HAS_ARGUMENT,
  "debuglevel",
  "",
  "Debug level (the higher the level the more output you'll see)"
},
{
  "ro",
  0,
  "readonly",
  "r",
  "does not allow alteration of your account's balance"
},
{
  "pinlist",
  0,
  "pinlist",
  "",
  "make AqMoney read the pinlist from stdin"
},

{
  "import",
  0,
  "import",
  "",
  "import users from an existing medium"
},
{
  "cfgfile",
  CLO_FLAGS_HAS_ARGUMENT,
  "configfile",
  "C",
  "use this config file for OpenHBCI's data"
},
{
  "aqmfile",
  CLO_FLAGS_HAS_ARGUMENT,
  "aqmfile",
  "A",
  "use this config file for AqMoney's additional data"
},

{
  "pname",
  CLO_FLAGS_HAS_ARGUMENT,
  "pname",
  "",
  "property name for \"get/setproperty\""
},
{
  "pvalue",
  CLO_FLAGS_HAS_ARGUMENT,
  "pvalue",
  "",
  "property value for \"get/setproperty\""
},

{
  "fromdate",
  CLO_FLAGS_HAS_ARGUMENT,
  "fromdate",
  "",
  "first date (YYYYMMDD)"
},
{
  "todate",
  CLO_FLAGS_HAS_ARGUMENT,
  "todate",
  "",
  "last date (YYYYMMDD)"
},
{
  "tfile",
  CLO_FLAGS_HAS_ARGUMENT,
  "tfile",
  "",
  "name of file containing transfers to be done"
},
{
  "taken",
  CLO_FLAGS_HAS_ARGUMENT,
  "taken",
  "",
  "name of file containing transfers which succeeded (transfer)"
},
{
  "nottaken",
  CLO_FLAGS_HAS_ARGUMENT,
  "nottaken",
  "",
  "name of file containing transfers which did not succeed (transfer)"
},
{
  "outfile",
  CLO_FLAGS_HAS_ARGUMENT,
  "outfile",
  "",
  "name of file to write to"
},
{
  "outformat",
  CLO_FLAGS_HAS_ARGUMENT,
  "outformat",
  "",
  "format of output file"
},
{
  "infile",
  CLO_FLAGS_HAS_ARGUMENT,
  "infile",
  "",
  "name of file to read from"
},
{
  "informat",
  CLO_FLAGS_HAS_ARGUMENT,
  "informat",
  "",
  "format of input file"
},
{
  "xactions",
  0,
  "transactions",
  "xa",
  "used with \"dump\" to show transactions"
},
{
  "balance",
  0,
  "balance",
  "",
  "used with \"dump\" to show balances"
},
{
  "sto",
  0,
  "sto",
  "",
  "used with \"dump\" to show standing orders"
},
{
  "users",
  0,
  "users",
  "",
  "used with \"dump\" to show users"
},
{
  "transfers",
  0,
  "transfers",
  "",
  "used with \"dump\" to show transfers"
},
{
  "pos",
  0,
  "pos",
  "",
  "used with \"dump\" to show only positive values"
},
{
  "neg",
  0,
  "neg",
  "",
  "used with \"dump\" to show only negative values"
},
{
  "open",
  0,
  "open",
  "",
  "used with the transaction matcher to match open transfers"
},
{
  "failed",
  0,
  "failed",
  "",
  "used with the transaction matcher to match failed transfers"
},
{
  "done",
  0,
  "done",
  "",
  "used with the transaction matcher to match done transfers"
},
{
  "nounknown",
  0,
  "no-unknown",
  "",
  "used with the transaction matcher to only match transfers with known status"
},
{
  "noquote",
  0,
  "noquote",
  "",
  "used with \"texport\" in txt mode to not use quotation marks"
},
{
  "tab",
  0,
  "tab",
  "",
  "used with \"texport\" in txt mode to use TAB as delimiter"
},
{
  "noheader",
  0,
  "noheader",
  "",
  "used with \"texport\" in txt mode to omit the header in output"
},
{
  "msg",
  0,
  "msg",
  "",
  "used with \"dump\" to show institute messages"
},
{
  "syncmode",
  CLO_FLAGS_HAS_ARGUMENT,
  "syncmode",
  "",
  "select the sync mode (for command sync)"
},
{
  "year",
  CLO_FLAGS_HAS_ARGUMENT,
  "year",
  "",
  "choose the year (for command report)"
},
{
  "month",
  CLO_FLAGS_HAS_ARGUMENT,
  "month",
  "",
  "choose the month (for command report)"
},
{
  "rflags",
  CLO_FLAGS_HAS_ARGUMENT,
  "rflags",
  "",
  "control the output of the command report (defaults to \"ymd\")"
},
{
  "keynumber",
  CLO_FLAGS_HAS_ARGUMENT,
  "keynumber",
  "",
  "number of the key to disable (used with \"disablekeys\" if you do not have access to your keys anymore)"
},
{
  "keyversion",
  CLO_FLAGS_HAS_ARGUMENT,
  "keyversion",
  "",
  "version of the key to disable (used with \"disablekeys\" if you do not have access to your keys anymore)"
},
{
  "newuser",
  CLO_FLAGS_HAS_ARGUMENT,
  "newuser",
  "",
  "store a new user id on the medium (used with \"modifymedium\")"
},
{
  "newcustomer",
  CLO_FLAGS_HAS_ARGUMENT,
  "newcustomer",
  "",
  "store a new customer id on the medium (used with \"modifymedium\")"
},
{
  "newinstitute",
  CLO_FLAGS_HAS_ARGUMENT,
  "newinstitute",
  "",
  "store a new institute id (german: BLZ) on the medium (used with \"modifymedium\")"
},
{
  "newserver",
  CLO_FLAGS_HAS_ARGUMENT,
  "newserver",
  "",
  "store a new server address on the medium (used with \"modifymedium\")"
},
{
  "newpin",
  0,
  "newpin",
  "",
  "store a new server address on the medium (used with \"modifymedium\")"
},
{
  "resetsystemid",
  0,
  "resetsystemid",
  "",
  "reset the system id (only with rdh media, used with \"modifymedium\"). Call -d sync afterwards"
},
{
  "newseq",
  CLO_FLAGS_HAS_ARGUMENT,
  "newseq",
  "",
  "new signature sequence counter (only with rdh media, used with \"modifymedium\")"
},
{
  "force",
  0,
  "force",
  "",
  "used with \"chgversion\" to enforce using a given protocol version"
},
{
  "help",
  CLO_FLAGS_LAST,
  "help",
  "h",
  "show this help screen"
}
};



int _fileExists(const char *path) {
  FILE *f;

  f=fopen(path,"r");
  if (f!=0) {
    fclose(f);
    return 1;
  }
  return 0;
}


int _backupFiles(const char *path, int steps) {
  char buffer1[256];
  char buffer2[256];
  int i;

  for (i=steps; i>=0; i--) {
    // create filenames
    if (i==0) {
      snprintf(buffer1, sizeof(buffer1),
	       "%s.bak", path);
      snprintf(buffer2, sizeof(buffer2),
	       "%s", path);
    }
    else {
      snprintf(buffer1, sizeof(buffer1),
	       "%s.bak.%d", path, i);
      if (i==1)
	snprintf(buffer2, sizeof(buffer2),
		 "%s.bak", path);
      else
	snprintf(buffer2, sizeof(buffer2),
		 "%s.bak.%d", path, i-1);
    }

    // remove old file, if it is the last one
    if (i==steps)
      unlink(buffer1);

    //fprintf(stderr,"rename(%s, %s) (%d):\n",
    //        buffer2, buffer1, i);

    // rename previous file to current ("x.bak.1"->"x.bak.2")
    if (_fileExists(buffer2)) {
      if (rename(buffer2, buffer1)) {
	fprintf(stderr,"Error: rename(%s, %s): %s\n",
		buffer2, buffer1, strerror(errno));
	return 1;
      }
    }

  } // for

  return 0;
}


/**
 * Main routine.
 * Return: 0 on succes, otherwise:
 *         Bit 0=1: Error in command line arguments
 *         Bit 1=1: Error loading configuration file
 *         Bit 2=1: Error saving configuration file
 *         Bit 3=1: Error on command execution
 */
int _main(int argc, char **argv) {
  HBCI::Error err, err1, err2;
  HBCI::CmdLineOptions opt;
  HBCI::Tree<HBCI::ConfigNode>::iterator var;
  HBCI::Pointer<AQMAPI> hbciif;
  HBCI::Pointer<AQMInteractor> interactor;
  HBCI::Pointer<AQMProgressMonitor> monitor;
  HBCI::Pointer<PinManager> pinManager;
  bool ro;
  string cmd;
  string cfgfile;
  string aqmfile;
  int rv;
  HBCI::Pointer<HBCI::File> f;
  HBCI::Pointer<HBCI::File> f2;
  int debugLevel;
  int steps;

  hbciif.setDescription("main::hbciif (AQMAPI)");
  err=opt.parseOptions(argc,argv,options);
  if (!err.isOk()) {
    fprintf(stderr,"Encountered an error: %s\n",
	    err.message().c_str());
    return 1;
  }
  // check if help requested
  var=opt.findVariable("help",
		       opt.root(),
		       false);
  if (var.isValid()) {
    fprintf(stdout,"Usage:\n");
    fprintf(stdout," %s <OPTIONS>\n",argv[0]);
    fprintf(stdout," where <OPTIONS> can be:\n");
    fprintf(stdout,"%s\n",opt.usage(options).c_str());
    return 1;
  }

  // get some variables
  var=opt.findVariable("ro",opt.root(),false);
  ro=var.isValid();
  steps=opt.getIntVariable("baks",10,opt.root());

  // get command
  cmd=opt.getVariable("cmd","",opt.root());
  if (cmd.empty()) {
    // maybe command given directly ?
    HBCI::Tree<HBCI::ConfigNode>::iterator it;

    it=opt.root();
    if (it.isValid()) {
      it.child();
      while(it.isValid()) {
	if ((*it).type==CONFIG_TYPE_VALUE) {
	  cmd=(*it).data;
	  break;
	}
	else
	  it++;
      } // while
    }
  }
  // recheck for command
  if (cmd.empty()) {
    fprintf(stderr,"ERROR: no command given.\n");
    return 1;
  }
  debugLevel=opt.getIntVariable("debuglevel",0,opt.root());

  // create hbci interface
  hbciif=new AQMAPI(ro);
  hbciif.ref().setDebugLevel(debugLevel);
  hbciif.ref().setSystemName("AqMoney");
  hbciif.ref().setSystemVersion(k_AQMONEY_VERSION_STRING);
  interactor=new AQMInteractor();
  monitor=new AQMProgressMonitor(hbciif.ptr());
  hbciif.ref().setInteractor(interactor.cast<HBCI::Interactor>());
  hbciif.ref().setMonitor(monitor.cast<HBCI::ProgressMonitor>());

  /* check whether we need to setup the pin manager */
  if (opt.findVariable("pinlist",opt.root(),false).isValid()) {
    // yes, we do ;-)
    pinManager=new PinManager(hbciif.ptr());
    err=pinManager.ref().readPinList(stdin);
    if (!err.isOk()) {
      fprintf(stderr,"ERROR: %s\n",
	      err.errorString().c_str());
      return 0x02;
    }
    hbciif.ref().setAuthentificator(pinManager.cast<HBCI::Auth>());
  }

  /* only read configuration file if it exists. Otherwise it will be
   * created in the end */

  // check whether the name of the configuration file is given
  cfgfile=opt.getVariable("cfgfile","",
			  opt.root());
  if (cfgfile.empty()) {
    /* no name given, so try some
     * We will look for these files:
     * ~/.openhbci
     * ~/aqmoney2.conf
     * If none is found then a new file will be created upon exit using
     * the first name in the list above.
     */
    cfgfile=HBCI::Directory::homeDirectory()+"/.openhbci";
    f=new HBCI::File(cfgfile);
    if (!(f.ref().accessFile(FILE_ACCESS_EXIST).isOk())) {
      // try another one
      cfgfile=HBCI::Directory::homeDirectory()+"/aqmoney2.conf";
      if (!(f.ref().accessFile(FILE_ACCESS_EXIST).isOk())) {
	// use default configuration file
	cfgfile=HBCI::Directory::homeDirectory()+"/.openhbci";
      }
    }
  }

  f=new HBCI::File(cfgfile);
  if (f.ref().accessFile(FILE_ACCESS_EXIST).isOk()) {
    err=hbciif.ref().loadEnvironment(cfgfile);

    if (!err.isOk()) {
      fprintf(stderr,"ERROR: %s\n",
	      err.errorString().c_str());
      return 0x02;
    }
  }
  else {
    fprintf(stderr,
	    "Warning: Configuration file not found, will create\n"
	    "\"%s\" later.\n", cfgfile.c_str());
  }

  // check whether the name of the configuration file is given
  aqmfile=opt.getVariable("aqmfile","",
			  opt.root());
  if (aqmfile.empty()) {
    /* no name given, so try some
     * We will look for these files:
     * ~/.openhbci
     * ~/aqmoney2.conf
     * If none is found then a new file will be created upon exit using
     * the first name in the list above.
     */
    aqmfile=HBCI::Directory::homeDirectory()+"/.openhbci_aqmoney";
    f=new HBCI::File(aqmfile);
    if (!(f.ref().accessFile(FILE_ACCESS_EXIST).isOk())) {
      // use default configuration file
      aqmfile=HBCI::Directory::homeDirectory()+"/.openhbci_aqmoney";
    }
  }

  f2=new HBCI::File(aqmfile);
  if (f2.ref().accessFile(FILE_ACCESS_EXIST).isOk()) {
    err=hbciif.ref().loadAQMFile(aqmfile);

    if (!err.isOk()) {
      fprintf(stderr,"ERROR: %s\n",
	      err.errorString().c_str());
      return 0x02;
    }
  }
  else {
    fprintf(stderr,
	    "Warning: Configuration file not found, will create\n"
	    "\"%s\" later.\n", aqmfile.c_str());
  }


  rv=0x08;

  try {
    // do some nasty things
    if (-1!=HBCI::parser::cmpPattern(cmd,"balance",false)) {
      // get balance
      err=getBalance(hbciif,opt);
    }
    else if (-1!=HBCI::parser::cmpPattern(cmd,"version",false)) {
      int vmajor, vminor, vpl, vbuild;

      Hbci::libraryVersion(vmajor, vminor, vpl, vbuild);
      fprintf(stdout,
	      "AqMoney v%s \n"
	      "OpenHBCI Headers: v%s)\n"
	      "OpenHBCI Library: v%d.%d.%d.%d)\n",
	      k_AQMONEY_VERSION_FULL_STRING,
	      OPENHBCI_VERSION_FULL_STRING,
	      vmajor, vminor, vpl, vbuild);
      err=Error();
    }
    else if (-1!=HBCI::parser::cmpPattern(cmd,"turnover",false)) {
      err=turnover(hbciif,opt);
    }
    else if (-1!=HBCI::parser::cmpPattern(cmd,"createuser",false)) {
      err=createUser(hbciif,opt);
    }
    else if (-1!=HBCI::parser::cmpPattern(cmd,"createcustomer",false)) {
      err=createCustomer(hbciif,opt);
    }
    else if (-1!=HBCI::parser::cmpPattern(cmd,"acclist",false)) {
      err=acclist(hbciif,opt);
    }
    else if (-1!=HBCI::parser::cmpPattern(cmd,"getkeys",false)){
      err=getKeys(hbciif,opt);
    }
    else if (-1!=HBCI::parser::cmpPattern(cmd,"dump",false)) {
      err=dump(hbciif,opt);
    }
    else if (-1!=HBCI::parser::cmpPattern(cmd,"sendkeys",false)) {
      err=sendKeys(hbciif,opt);
    }
    else if (-1!=HBCI::parser::cmpPattern(cmd,"iniletter",false)) {
      err=iniletter(hbciif,opt);
    }
    else if (-1!=HBCI::parser::cmpPattern(cmd,"transfer",false)) {
      err=transfer(hbciif,opt);
    }
    else if (-1!=HBCI::parser::cmpPattern(cmd,"sync",false)) {
      err=synchronize(hbciif,opt);
    }
    else if (-1!=HBCI::parser::cmpPattern(cmd,"texport",false)) {
      err=texport(hbciif,opt);
    }
    else if (-1!=HBCI::parser::cmpPattern(cmd,"accadd",false)) {
      err=accAdd(hbciif,opt);
    }
    else if (-1!=HBCI::parser::cmpPattern(cmd,"getstdorders",false)) {
      err=getStandingOrders(hbciif,opt);
    }
    else if (-1!=HBCI::parser::cmpPattern(cmd,"newstdorder",false)) {
      err=newStandingOrder(hbciif,opt);
    }
    else if (-1!=HBCI::parser::cmpPattern(cmd,"delstdorder",false)) {
      err=delStandingOrder(hbciif,opt);
    }
    else if (-1!=HBCI::parser::cmpPattern(cmd,"resetseq",false)) {
      err=resetSeq(hbciif,opt);
    }
    else if (-1!=HBCI::parser::cmpPattern(cmd,"report",false)) {
      err=report(hbciif,opt);
    }
    else if (-1!=HBCI::parser::cmpPattern(cmd,"disablekeys",false)) {
      err=disableKeys(hbciif,opt);
    }
    else if (-1!=HBCI::parser::cmpPattern(cmd,"changekeys",false)) {
      err=changeKeys(hbciif,opt);
    }
    else if (-1!=HBCI::parser::cmpPattern(cmd,"modifymedium",false)) {
      err=modifyMedium(hbciif,opt);
    }
    else if (-1!=HBCI::parser::cmpPattern(cmd,"chgversion",false)) {
      err=chgVersion(hbciif,opt);
    }
    else if (-1!=HBCI::parser::cmpPattern(cmd,"pluginlist",false)) {
      err=pluginList(hbciif,opt);
    }
    else if (-1!=HBCI::parser::cmpPattern(cmd,"getstatus",false)) {
      err=getStatus(hbciif,opt);
    }
    else if (-1!=HBCI::parser::cmpPattern(cmd,"convert",false)) {
      err=convert(hbciif,opt);
    }
    else if (-1!=HBCI::parser::cmpPattern(cmd,"mkpinlist",false)) {
      err=mkPinList(hbciif,opt);
    }
    else if (-1!=HBCI::parser::cmpPattern(cmd,"setproperty",false)) {
      err=setProperty(hbciif,opt);
    }
    else if (-1!=HBCI::parser::cmpPattern(cmd,"getproperty",false)) {
      err=getProperty(hbciif,opt);
    }
    else {
      err=HBCI::Error("main()",
		      ERROR_LEVEL_NORMAL,
		      0,
		      ERROR_ADVISE_DONTKNOW,
		      "Unknown command",
		      cmd);
      rv=1;
    }
    if (!err.isOk()) {
      switch(err.code()) {
      case HBCI_ERROR_CODE_PIN_WRONG_0:
	fprintf(stderr,
		"VERY SERIOUS WARNING:\n"
		"=====================\n"
		"You already entered a false pin 3 times !\n"
		"If you enter a bad pin again "
		"your card gets blocked!\n"
		"Please use now the last program which allowed you "
		"to successfully enter the pin in order to reset the\n"
		"error counter !\n");
	break;
      case HBCI_ERROR_CODE_PIN_WRONG_1:
	fprintf(stderr,
		"SERIOUS WARNING:\n"
		"=====================\n"
		"You already entered a false pin twice !\n"
		"There is only one bad try left, so please be carefull.\n"
		"Please use now the last program which allowed you "
		"to successfully enter the pin in order to reset the\n"
		"error counter !\n");
	break;
      case HBCI_ERROR_CODE_PIN_WRONG_2:
	fprintf(stderr,
		"WARNING:\n"
		"=====================\n"
		"You entered a false pin.\n"
		"There are only two bad tries left, "
		"so please be carefull.\n"
		"If you are very sure that the pin you entered is "
		"correct \n"
		"then please stop using this program and contact\n"
		"         martin@libchipcard.de \n"
		"to report this incidence.\n"
		"If it is possible that you made a mistake, then please\n"
		"try again.\n");
	break;
      case HBCI_ERROR_CODE_PIN_WRONG:
	fprintf(stderr,
		"WARNING:\n"
		"=====================\n"
		"You entered a false pin.\n"
		"If you are very sure that the pin you entered is "
		"correct \n"
		"then please stop using this program and contact\n"
		"         martin@libchipcard.de \n"
		"to report this incidence.\n"
		"If it is possible that you made a mistake, then please\n"
		"try again.\n");
	break;
      default:
	fprintf(stderr,"ERROR: %s\n",
		err.errorString().c_str());
      } // switch
    }
    else
      rv=0;
  } // try
  catch (HBCI::Error lerr) {
    fprintf(stderr,"Exception: %s\n",
	    lerr.errorString().c_str());
    rv=0x8;
  }

  // backup previous config files
  if (_backupFiles(cfgfile.c_str(), steps)) {
    char buffer[256];

    snprintf(buffer,sizeof(buffer)-1, "%s.HAZARDBAK.%8x",
	     cfgfile.c_str(), (unsigned int)time(0));
    fprintf(stderr,
	    "WARNUNG:\n"
	    "========\n"
	    "Konnte kein normales Backup der aktuellen Konfigurationsdatei\n"
	    "\"%s\"erstellen !\n"
	    "Daher wird nun versucht ein Notfall-Backup zu erzeugen.\n"
	    "Der Name dieser Notfall-Datei ist \"%s\"\n",
	    cfgfile.c_str(), buffer);
    if (rename(cfgfile.c_str(), buffer)) {
      fprintf(stderr,
	      "WARNUNG:\n"
	      "========\n"
	      "Konnte kein Backup der aktuellen Konfigurationsdatei\n"
	      "\"%s\"erstellen !\n", cfgfile.c_str());
      fprintf(stderr, "Error: rename(%s, %s): %s\n",
	      cfgfile.c_str(), buffer, strerror(errno));
    }
  }

  // backup previous aqmconfig files
  if (_backupFiles(aqmfile.c_str(), steps)) {
    char buffer[256];

    snprintf(buffer,sizeof(buffer)-1, "%s.HAZARDBAK.%8x",
	     aqmfile.c_str(), (unsigned int)time(0));
    fprintf(stderr,
	    "WARNUNG:\n"
	    "========\n"
	    "Konnte kein normales Backup der aktuellen Konfigurationsdatei\n"
	    "\"%s\"erstellen !\n"
	    "Daher wird nun versucht ein Notfall-Backup zu erzeugen.\n"
	    "Der Name dieser Notfall-Datei ist \"%s\"\n",
	    aqmfile.c_str(), buffer);
    if (rename(aqmfile.c_str(), buffer)) {
      fprintf(stderr,
	      "WARNUNG:\n"
	      "========\n"
	      "Konnte kein Backup der aktuellen Konfigurationsdatei\n"
	      "\"%s\"erstellen !\n", aqmfile.c_str());
      fprintf(stderr, "Error: rename(%s, %s): %s\n",
	      aqmfile.c_str(), buffer, strerror(errno));
    }
  }

  try {
    // save environment
    err=hbciif.ref().saveEnvironment(cfgfile);
  } // try
  catch (HBCI::Error lerr) {
    err=lerr;
  }
  err1=err;
  err=HBCI::Error();

  try {
    // save aqmconfig
    err=hbciif.ref().saveAQMFile(aqmfile);
    hbciif=0;
  } // try
  catch (HBCI::Error lerr) {
    err=lerr;
  }

  if (!err.isOk()) {
    fprintf(stderr,"ERROR: %s\n",
	    err.errorString().c_str());
    rv|=0x04;
  }
  if (!err2.isOk()) {
    fprintf(stderr,"ERROR: %s\n",
	    err2.errorString().c_str());
    rv|=0x04;
  }

  return rv;
}


int main(int argc, char **argv) {
  int result;

  try {
    result=_main(argc,argv);
  }
  catch (HBCI::Error lerr) {
    cerr<<"Exception: "<<lerr.errorString()<<"\n";
    result=0x08;
  }
  return result;
}



