/***************************************************************************
 $RCSfile: xactionmatcher.cpp,v $
 -------------------
 cvs         : $Id: xactionmatcher.cpp,v 1.1 2003/05/29 15:37:47 aquamaniac Exp $
 begin       : Mon Jan 20 2003
 copyright   : (C) 2003 by Martin Preuss
 email       : martin@aquamaniac.de
 */

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "xactionmatcher.h"

TransactionMatcher::TransactionMatcher()
  :_country(0)
  ,_institute("*")
  ,_account("*")
  ,_flags(TM_FLAGS_DEFAULT)
{
}


TransactionMatcher::TransactionMatcher(int country,
				       const string &institute,
				       const string &account,
				       HBCI::Date fromdate,
				       HBCI::Date todate,
				       unsigned int flags)
:_country(country)
,_institute(institute)
,_account(account)
,_fromdate(fromdate)
,_todate(todate)
,_flags(flags)
{
}


TransactionMatcher::~TransactionMatcher(){
}


bool TransactionMatcher::match(const AQMTransaction &xa){
  HBCI::Date tmpdate;

  // check country code
  if (_country!=xa.ourCountryCode() && _country!=0 && xa.ourCountryCode()!=0)
    return false;

  // check bank code
  if (HBCI::parser::cmpPattern(xa.ourBankCode(),
			       _institute,
			       false)==-1)
    return false;

  // check account id
  if (HBCI::parser::cmpPattern(xa.ourAccountId(),
			       _account,
			       false)==-1)
    return false;

  // check date
  tmpdate=xa.valutaDate();
  if (!tmpdate.isValid())
    tmpdate=xa.date();

  // check fromdate
  if (_fromdate.isValid() && tmpdate.isValid())
    if (tmpdate<_fromdate)
      return false;

  // check todate
  if (_todate.isValid() && tmpdate.isValid())
    if (_todate<tmpdate)
      return false;

  // check value
  if (xa.value().getValue()<0) {
    if (!(_flags & TM_FLAGS_NEGATIVE))
      return false;
  }
  else {
    if (!(_flags & TM_FLAGS_POSITIVE))
      return false;
  }

  // check status, if any
  if (xa.status().result()!=-1) {
    // postponed
    if (xa.status().result()==10) {
      if (!(_flags & TM_FLAGS_OPEN))
	return false;
    }
    else if (xa.status().result()>=9000){
      if (!(_flags & TM_FLAGS_FAILED))
	return false;
    }
    else {
      // done
      if (!(_flags & TM_FLAGS_DONE))
	return false;
    }
  }
  else {
    if (_flags & TM_FLAGS_NO_UNKNOWN)
      return false;
  }

  return true;
}




