/***************************************************************************
 $RCSfile: aqmloader.h,v $
                             -------------------
    cvs         : $Id: aqmloader.h,v 1.2 2003/05/29 16:20:36 aquamaniac Exp $
    begin       : Tue Apr 08 2003
    copyright   : (C) 2003 by Martin Preuss
    email       : martin@aquamaniac.de
*/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef AQMLOADER_H
#define AQMLOADER_H

class AQMLoader;

#include <openhbci.h>
#include "aqmtypes.h"
#include "globals.h"

using namespace HBCI;

/**
 *
 */
class AQMLoader: public HBCI::Loader {
private:
  AQMAPI *_api;
public:
  AQMLoader(AQMAPI *hbci);
  ~AQMLoader();

  Error readTransferFile(const string &name,
			 list<AQMTransaction> &xactions);
  Error writeTransferFile(const string &name,
			  const list<AQMTransaction> &xactions);

  Error saveStatusReport(const StatusReport &r,
			 SimpleConfig &cfg,
			 cfgPtr w);
  Error loadStatusReport(StatusReport &r,
			 SimpleConfig &cfg,
			 cfgPtr w);

  Error saveAQMTransaction(const AQMTransaction &t,
			   SimpleConfig &cfg,
			   cfgPtr where);
  Error loadAQMTransaction(AQMTransaction &t,
			   SimpleConfig &cfg,
			   cfgPtr w);
  Error loadAQMTransfers(SimpleConfig &cfg,
			 cfgPtr w);
  Error saveAQMTransfers(SimpleConfig &cfg,
			 cfgPtr w);

  Error loadAQM(SimpleConfig &cfg, cfgPtr w);
  Error saveAQM(SimpleConfig &cfg, cfgPtr where);

};


#endif










