/***************************************************************************
 $RCSfile: aqmapi.cpp,v $
                             -------------------
    cvs         : $Id: aqmapi.cpp,v 1.1 2003/05/29 15:37:47 aquamaniac Exp $
    begin       : Sat May 17 2003
    copyright   : (C) 2003 by Martin Preuss
    email       : martin@aquamaniac.de
*/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#include "aqmapi.h"


AQMAPI::AQMAPI(bool readonly,
	       bool retrievalOnly)
  :HBCI::API(readonly, retrievalOnly)
{
  _loader=new AQMLoader(this);
}


AQMAPI::~AQMAPI(){
}


HBCI::Error AQMAPI::loadAQMFile(const string &f) {
  HBCI::SimpleConfig cfg;
  HBCI::Error err;

  cfg.setMode(HBCIAPP_CONFIG_MODE);
  err=cfg.readFile(f);
  if (!err.isOk())
    return err;
  err=_loader.ref().loadAQM(cfg,cfg.root());

  return err;
}


HBCI::Error AQMAPI::saveAQMFile(const string &f) const {
  HBCI::SimpleConfig cfg;
  HBCI::Error err;

  cfg.setMode(HBCIAPP_CONFIG_MODE);
  err=_loader.ref().saveAQM(cfg,cfg.root());
  if (!err.isOk())
    return HBCI::Error("AQMAPI::saveAQMFile",err);
  err=cfg.writeFile(f);
  if (!err.isOk())
    return HBCI::Error("AQMAPI::saveAQMFile", err);

  return HBCI::Error();
}


void AQMAPI::addTransfer(const AQMTransaction &t){
  _transfers.push_back(t);
}


list<AQMTransaction> &AQMAPI::transfers() {
  return _transfers;
}





