/***************************************************************************
 $RCSfile: chgversion.cpp,v $
                             -------------------
    cvs         : $Id: chgversion.cpp,v 1.5 2003/06/11 18:48:16 aquamaniac Exp $
    begin       : Sun Mar 30 2003
    copyright   : (C) 2003 by Martin Preuss
    email       : martin@aquamaniac.de
*/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif



#include "chgversion.h"


HBCI::Error chgVersion(HBCI::Pointer<AQMAPI> hbciif,
		       HBCI::SimpleConfig &opt){
  int country;
  string instid;
  string custid;
  HBCI::Error err;
  list<HBCI::Pointer<HBCI::Customer> > custs;
  list<HBCI::Pointer<HBCI::Customer> >::iterator it;
  HBCI::Pointer<HBCI::OutboxJob> job;
  int hversion;
  int jobs;
  bool force;

  jobs=0;
  country=opt.getIntVariable("country",280,opt.root());
  instid=opt.getVariable("instid","*",opt.root());
  custid=opt.getVariable("customer","*",opt.root());
  hversion=opt.getIntVariable("hversion",210,opt.root());
  force=opt.findVariable("force",opt.root(),false).isValid();

  try {
    custs=hbciif.ref().getCustomers(country,
				    instid,
				    custid);
    if (custs.empty())
      return HBCI::Error("chgVersion",
			 ERROR_LEVEL_NORMAL,
			 0,
			 ERROR_ADVISE_DONTKNOW,
			 "customer(s) not found");

    // create job for all matching customers
    for (it=custs.begin();
	 it!=custs.end();
	 it++) {
      HBCI::Pointer<HBCI::User> user;
      HBCI::Pointer<HBCI::Bank> bank;
      list<int> sversions;
      list<int>::iterator vit;
      bool versionOk;
      string n;

      user=(*it).ref().user();
      bank=user.ref().bank();
      n=bank.ref().name();
      if (n.empty())
	n="<unbekannte Bank>";
      if (bank.ref().hbciVersion()==hversion) {
	fprintf(stderr,
		"Bank \"%s\" (BLZ=%s) already uses version %d\n",
		n.c_str(), bank.ref().bankCode().c_str(), hversion);
      }
      else {
	// check for supported version
	versionOk=false;
	sversions=bank.ref().supportedVersions();
	for (vit=sversions.begin();
	     vit!=sversions.end();
	     vit++) {
	  if (*vit==hversion) {
	    versionOk=true;
	    break;
	  }
	} // for
	if (!versionOk && !force) {
	  bool first;

	  fprintf(stderr,
		  "Version %d is not supported by bank \"%s\" (BLZ=%s)\n",
		  hversion, n.c_str(), bank.ref().bankCode().c_str());
	  fprintf(stderr,
		  "  Supported versions are: ");
	  first=true;
	  for (vit=sversions.begin();
	       vit!=sversions.end();
	       vit++) {
	    if (!first)
	      fprintf(stderr,", ");
	    else
	      first=false;
	    fprintf(stderr,"%d",*vit);
	  } // for
	  fprintf(stderr,"\n");

	  return HBCI::Error("chgVersion",
			     ERROR_LEVEL_NORMAL,
			     0,
			     ERROR_ADVISE_DONTKNOW,
			     "HBCI version not supported by institute");
	}

	/* set new HBCI version, and also reset BPD version
	 * this will enforce an BPD update upon next dialog initialization
	 * We use a OutboxJobGetAccounts job in order to update the BPD, since
	 * this job really does nothing more than that despite it's name ;-)
	 */
	bank.ref().setHbciVersion(hversion);
	bank.ref().setBPDVersion(0);
	job=new HBCI::OutboxJobGetAccounts(*it);
	// enqueue job
	hbciif.ref().addJob(job);
        jobs++;
      } // if version differs from current one
    } // for

    // execute queue
    if (jobs) {
      err=hbciif.ref().executeQueue(true);
    }
    else {
      fprintf(stderr,"Nothing to be done.\n");
      err=HBCI::Error();
    }
  }
  catch (HBCI::Error lerr) {
    err=lerr;
  }
  return err;
}





