# -*- coding: utf-8 -*-
#############################################
#  Rafael Proença     <cypherbios@ubuntu.com>
#  Laudeci Oliveira    <laudeci@gmail.com>
#
#  Copyright 2006 APTonCD DevTeam.
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published
#  by the Free Software Foundation; version 2 only.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#############################################
import datetime
import os
import string
import sys
import rfc822
import StringIO

from APTonCD.core import constants
from APTonCD.core.utils import SystemInfo

AOC_VERSION = 'aocversion'
DISTRIBUTION = 'distribution'
CODENAME = 'codename'
ARCHITECTURE = 'architecture'
FILE_DATE = 'date'

class mediaBase(object):
	"""This class is used as a base class to all media information classes."""
	def __init__(self, filename="", media="CD1", totalmedia="1"):
		util = SystemInfo()
		
		self.fileName = filename
		self.aocversion = constants.APP_VERSION
		self.distro = util.distro
		self.codename = util.codename
		self.arch = util.architecture
		self.date = datetime.datetime.now().strftime('%Y-%m-%d %H:%M')
		self.media = media
		self.totalmedia = totalmedia
		self.disklabel = "APTonCD for " + self.distro + ' ' + self.codename + ' - ' + self.arch + ' (' + self.date + ') '
		
	def __get_value(self,source, string, default = ''):
		try:
			return source[string]
		except:
			return default
		
		
class MediaInfo(mediaBase):
	"""This class writes some infomation about the media created."""

	def __init__(self, filename=""):
		super(MediaInfo,self).__init__(filename)
		
	def __get_value(self,source, string, default = ''):
		try:
			return source[string]
		except:
			return default
		
	def infoFromFile(self):
		if self.fileName == "":
			return False , "File name cannot be empty."
		
		if not os.path.isfile(self.fileName):
			return False , "'" + self.fileName + "' doesn't exist."
		try:
			aptfile=open(self.fileName, 'r')
			aptdata=aptfile.read()
		except IOError, msg:
			return False , "File doesn't seems to be valid."
		
		infos = string.split(aptdata,"\n\n")
		for info in infos:
			if info:
				tmp=StringIO.StringIO(info)
				p=rfc822.Message(tmp)
				self.aocversion = self.__get_value(p,AOC_VERSION)
				self.distro = self.__get_value(p,DISTRIBUTION)
				self.codename = self.__get_value(p,CODENAME)
				self.arch = self.__get_value(p,ARCHITECTURE)
				self.date = self.__get_value(p,FILE_DATE)
		return True, None

	def compare_version(self):
		util = SystemInfo()
		try :
			info = constants.MESSAGE_0070
			if self.distro != util.distro or self.codename != util.codename:
				return False, (info % (self.distro,self.codename,util.distro,util.codename)) 
			elif self.arch != util.architecture:
				return False, (info % (self.codename, self.arch,util.codename, util.architecture))
			else:
				return True, None
		except Exception, ex :
			return False, str(ex)
					
				
	def write(self):
		i= 0
		try:
			mFile = open(self.fileName,"w")
			mFile.write("aocversion: " + self.aocversion \
			+ "\ndistribution: " + self.distro \
			+ "\ncodename: " + self.codename \
			+ "\narchitecture: " + self.arch \
			+ "\ndate: " + self.date + "\n")
			return True
		except IOError:
			print "The file does not exist"
			return False
			
class aptDiskInfo(mediaBase):
	"""This class writes some infomation for apt about de disk source."""

	def __init__(self, filename="", media="CD1"):
		super(aptDiskInfo,self).__init__(filename, media)
	
	def write(self):
		i= 0
		try:
			mFile = open(self.fileName,"w")
			content = self.disklabel + self.media
			mFile.write(content)
			return True
		except IOError:
			print "The file does not exist"
			return False

class aptDiskDefines(mediaBase):
	"""This class writes some infomation for apt about de disk source."""

	def __init__(self, filename="", media="1", totalmedia="1"):
		super(aptDiskDefines,self).__init__(filename, media, totalmedia)
	
	def write(self):
		i= 0
		try:
			mFile = open(self.fileName,"w")
			content = "#define DISKNAME  " + self.disklabel \
			+ "\n#define TYPE  binary" \
			+ "\n#define TYPEbinary  " + self.media \
			+ "\n#define ARCH  " + self.arch \
			+ "\n#define ARCH" + self.arch + '  ' + self.media \
			+ "\n#define DISKNUM  " + self.media \
			+ "\n#define DISKNUM" + self.media + '  '  + self.media \
			+ "\n#define TOTALNUM  " + self.media \
			+ "\n#define TOTALNUM" + self.media + "  " + self.media +"\n"

			mFile.write(content)
			return True
		except IOError:
			print "The file does not exist"
			return False
