// vs_util.cc

#include "vs_button.h"
#include "vs_center.h"
#include "vs_editline.h"
#include "vs_frame.h"
#include "vs_label.h"
#include "vs_pager.h"
#include "vs_util.h"
#include "vs_scrollbar.h"
#include "vs_table.h"

#include <config/colors.h>
#include <config/keybindings.h>

#include <sigc++/bind.h>

using namespace std;

vscreen_widget *vs_dialog_ok(string msg, Slot0Arg okslot, string label,
			     int attr)
{
  vs_center *center=new vs_center;

  vs_table *table=new vs_table;
  table->set_bg(attr);

  vscreen_widget *txt=new vs_label(msg, attr);

  vs_button *okbutton=new vs_button(label);
  okbutton->set_bg(attr);

  if(okslot)
    okbutton->pressed.connect(okslot);
  okbutton->pressed.connect(slot(center, &vscreen_widget::destroy));

  table->add_widget(txt);
  table->add_widget(new vs_center(okbutton), 1, 0, 1, 1, false, false);

  vs_frame *frame=new vs_frame(table);
  frame->set_bg(attr);

  center->add_widget(frame);
  return center;
}

vscreen_widget *vs_dialog_ok(string msg, Slot0Arg okslot,
			     int attr)
{
  return vs_dialog_ok(msg, okslot, "Ok", attr);
}

vscreen_widget *vs_dialog_ok(string msg, Slot0Arg okslot)
{
  return vs_dialog_ok(msg, okslot, get_color("DefaultWidgetBackground")|A_REVERSE);
}

vscreen_widget *vs_dialog_yesno(string msg,
				Slot0Arg yesslot,
				string yeslabel,
				Slot0Arg noslot,
				string nolabel,
				int attr,
				bool deflt)
{
  vs_center *center=new vs_center;

  vs_table *table=new vs_table;
  table->set_bg(attr);

  vscreen_widget *txt=new vs_label(msg, attr);

  vs_button *yesbutton=new vs_button(yeslabel);
  yesbutton->set_bg(attr);
  vs_button *nobutton=new vs_button(nolabel);
  nobutton->set_bg(attr);

  if(yesslot)
    yesbutton->pressed.connect(yesslot);
  if(noslot)
    nobutton->pressed.connect(noslot);

  table->connect_key("Yes", &global_bindings, yesbutton->pressed.slot());
  table->connect_key("No", &global_bindings, nobutton->pressed.slot());
  table->connect_key("Cancel", &global_bindings, nobutton->pressed.slot());

  yesbutton->pressed.connect(slot(center, &vscreen_widget::destroy));
  nobutton->pressed.connect(slot(center, &vscreen_widget::destroy));

  vs_center *cyes=new vs_center(yesbutton);
  vs_center *cno=new vs_center(nobutton);

  table->add_widget(txt, 0, 0, 1, 2, true, false);
  table->add_widget(cyes, 1, 0, 1, 1, false, false);
  table->add_widget(cno, 1, 1, 1, 1, false, false);

  txt->show();
  yesbutton->show();
  nobutton->show();
  cyes->show();
  cno->show();

  if(deflt)
    table->focus_widget(cyes);
  else
    table->focus_widget(cno);

  vs_frame *frame=new vs_frame(table);
  frame->set_bg(attr);

  center->add_widget(frame);

  return center;
}

vscreen_widget *vs_dialog_yesno(string msg,
				Slot0Arg yesslot,
				Slot0Arg noslot,
				int attr,
				bool deflt)
{
  return vs_dialog_yesno(msg, yesslot, "Yes", noslot, "No", attr, deflt);
}

vscreen_widget *vs_dialog_yesno(string msg,
				Slot0Arg yesslot,
				Slot0Arg noslot,
				bool deflt)
{
  return vs_dialog_yesno(msg,
			 yesslot,
			 noslot,
			 get_color("DefaultWidgetBackground")|A_REVERSE,
			 deflt);
}

vscreen_widget *vs_dialog_fileview(string fn,
				   Slot0Arg okslot,
				   int attr)
{
  vs_file_pager *p=new vs_file_pager(fn);
  vs_scrollbar *scrollbar=new vs_scrollbar(vs_scrollbar::VERTICAL,
					   p->get_cury(),
					   p->get_maxy());
  vs_table *t=new vs_table;
  vs_frame *f=new vs_frame(t);
  vs_center *c=new vs_center(f);

  vs_button *b=new vs_button("Ok");

  b->set_bg(attr);
  f->set_bg(attr);
  t->set_bg(attr);

  b->pressed.connect(slot(c, &vs_center::destroy));

  t->add_widget_opts(p, 0, 0, 1, 1,
		     vs_table::SHRINK | vs_table::ALIGN_CENTER,
		     vs_table::SHRINK | vs_table::ALIGN_CENTER);
  t->add_widget_opts(scrollbar, 0, 1, 1, 1,
		     vs_table::ALIGN_CENTER,
		     vs_table::EXPAND | vs_table::SHRINK | vs_table::ALIGN_CENTER);
  t->add_widget_opts(b, 1, 0, 1, 2,
		     vs_table::ALIGN_CENTER | vs_table::SHRINK,
		     vs_table::ALIGN_CENTER);

  t->connect_key("Confirm", &global_bindings, b->pressed.slot());
  p->location_changed.connect(slot(scrollbar, &vs_scrollbar::set_slider));

  return c;
}

vscreen_widget *vs_dialog_fileview(string fn,
				   Slot0Arg okslot=NULL)
{
  return vs_dialog_fileview(fn, okslot,
			    get_color("DefaultWidgetBackground")|A_REVERSE);
}

static void do_dialog_string(string s,
			     SigC::Slot0<void> realslot)
{
  realslot.call();
}

static void also_do_dialog_string(vs_editline *e,
				  SigC::Slot1<void, string> thestrslot)
{
  e->add_to_history(e->get_text());
  thestrslot.call(e->get_text());
}

vscreen_widget *vs_dialog_string(string msg,
				 string deflt,
				 SlotArg<SigC::Slot1<void, string> > slot,
				 SlotArg<SigC::Slot0<void> > cancel_slot,
				 SlotArg<SigC::Slot1<void, string> > changed_slot,
				 vs_editline::history_list *history,
				 int attr)
{
  vs_table *t=new vs_table;
  vs_label *l=new vs_label(msg);
  vs_editline *e=new vs_editline(rootwin.getmaxx()-6, "", deflt, history);
  vs_button *bok=new vs_button("Ok"), *bcancel=new vs_button("Cancel");
  vs_frame *f=new vs_frame(t);
  vs_center *c=new vs_center(f);

  l->set_bg(attr);
  f->set_bg(attr);
  t->set_bg(attr);
  bok->set_bg(attr);
  bcancel->set_bg(attr);

  t->add_widget(l, 0, 0, 1, 2);
  t->add_widget(e, 1, 0, 1, 2);
  t->add_widget_opts(bok, 2, 0, 1, 1,
		     vs_table::ALIGN_CENTER,
		     vs_table::ALIGN_CENTER);
  t->add_widget(bcancel, 2, 1, 1, 1,
		vs_table::ALIGN_CENTER,
		vs_table::ALIGN_CENTER);

  e->entered.connect(bind(SigC::slot(do_dialog_string),
			  bok->pressed.slot()));
  if(changed_slot)
    e->text_changed.connect(changed_slot);

  t->connect_key_post("Cancel", &global_bindings,
		      bcancel->pressed.slot());

  if(slot)
    bok->pressed.connect(bind(SigC::slot(also_do_dialog_string),
			      e, slot));
  bok->pressed.connect(SigC::slot(c, &vscreen_widget::destroy));

  if(cancel_slot)
    bcancel->pressed.connect(cancel_slot);
  bcancel->pressed.connect(SigC::slot(c, &vscreen_widget::destroy));

  return c;
}

vscreen_widget *vs_dialog_string(string msg,
				 string deflt,
				 SlotArg<SigC::Slot1<void, string> > slot,
				 SlotArg<SigC::Slot0<void> > cancel_slot,
				 SlotArg<SigC::Slot1<void, string> > changed_slot,
				 vs_editline::history_list *history)
{
  return vs_dialog_string(msg,
			  deflt,
			  slot,
			  cancel_slot,
			  changed_slot,
			  history,
			  get_color("DefaultWidgetBackground")|A_REVERSE);
}
