// config_signal.cc			-*-c++-*-
//
// Implementations and stuff for config_signal

#include "config_signal.h"

#include <sigc++/object_slot.h>
#include <sigc++/convert.h>
#include <apt-pkg/strutl.h>

signalling_config::signalling_config(Configuration *_real_config,
				     Configuration *_theme_config)
  :real_config(_real_config), theme_config(_theme_config)
{
  update_theme(real_config->Find(PACKAGE "::Theme", ""));

  connect(PACKAGE "::Theme", SigC::slot(this, &signalling_config::update_theme));
}

signalling_config::~signalling_config()
{
  for(connhash::iterator i=conn_table.begin();
      i!=conn_table.end();
      i++)
    delete i->second;
}

void signalling_config::update_theme(string newtheme)
{
  themeroot=newtheme;
  if(!themeroot.empty())
    themeroot=PACKAGE "::Themes::"+themeroot+"::";
}

void signalling_config::Set(string Name, string Value)
{
  real_config->Set(Name, Value);

  connhash::iterator found=conn_table.find(Name);

  if(found!=conn_table.end())
    found->second->emit(Value);
}

void signalling_config::Set(const char *Name, string Value)
{
  real_config->Set(Name, Value);

  connhash::iterator found=conn_table.find(Name);

  if(found!=conn_table.end())
    found->second->emit(Value);
}

void signalling_config::Set(const char *Name, int Value)
{
  real_config->Set(Name, Value);

  connhash::iterator found=conn_table.find(Name);

  if(found!=conn_table.end())
    found->second->emit(real_config->Find(Name));
}

void signalling_config::connect(string name, const SigC::Slot1<void, string> &slot)
{
  connhash::iterator found=conn_table.find(name);

  if(found!=conn_table.end())
    found->second->connect(slot);
  else
    {
      SigC::Signal1<void, string> *sig=new SigC::Signal1<void, string>;

      conn_table[name]=sig;
      sig->connect(slot);
    }
}

// right now, may emit too many signals..that's ok..?
Configuration *signalling_config::setcfg(Configuration *newcfg)
{
  Configuration *rval=real_config;
  real_config=newcfg;

  update_theme(real_config->Find(PACKAGE "::Theme", ""));

  for(connhash::iterator i=conn_table.begin();
      i!=conn_table.end();
      i++)
    if(Exists(i->first))
      i->second->emit(Find(i->first));

  return rval;
}

void DoStrToNum(SigC::Callback1<void, int> *c, string str)
{
  unsigned long result;

  StrToNum(str.c_str(), result, str.size());

  c->call(result);
}

void DoStrToBool(SigC::Callback1<void, bool> *c, string s)
{
  c->call(StringToBool(s));
}

void signalling_config::connectI(string name, const SigC::Slot1<void, int> &slot)
{
  connect(name, convert(slot, DoStrToNum));
}

void signalling_config::connectB(string name, const SigC::Slot1<void, bool> &slot)
{
  connect(name, convert(slot, DoStrToBool));
}
