//
// anyRemote
// a bluetooth remote for your PC.
//
// Copyright (C) 2006-2012 Mikhail Fedotov <anyremote@mail.ru>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef _BTIO_H
#define _BTIO_H

int  rfcommConnect(const char* btAddress, int channel);
void rfcommClose(void);

int  openSerialPort (char* port);
int  closeSerialPort(int final);


int  bt_read(char* buf, int len);
int  bt_readchar(char* c, int timeout);
int  bt_write(char* buf, int len);
int  bt_put_command(const char* command,
                    char* answer,
                    int   max,
                    int   timeout,
                    char* expect);

int  bt_getfd(void);

char * getBtAddress(void);
void freeBtAddress (void);

int closeSocketPort(int type, int final);
int openSocketPort(int type, int port,char *path);

void openStdin();
void closeStdin();
int readStdin(char* buf, int max);

int unix_open_port (char* port);
int unix_close_port();
//int unix_read_port(char* buf, int l);

int listenAndAcceptSocketConn(int type);
int writeSocketConn(const char* command, int count);
int writeBytesSocketConn(char* command);
int readSocketConn(char* buffer, int len);
int sendKeepAlive(void);

void sendIViewerHeartbeat(void);

#endif
