# This file was automatically generated by SWIG (http://www.swig.org).
# Version 1.3.39
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

package Amanda::Types;
use base qw(Exporter);
use base qw(DynaLoader);
package Amanda::Typesc;
bootstrap Amanda::Types;
package Amanda::Types;
@EXPORT = qw();

# ---------- BASE METHODS -------------

package Amanda::Types;

sub TIEHASH {
    my ($classname,$obj) = @_;
    return bless $obj, $classname;
}

sub CLEAR { }

sub FIRSTKEY { }

sub NEXTKEY { }

sub FETCH {
    my ($self,$field) = @_;
    my $member_func = "swig_${field}_get";
    $self->$member_func();
}

sub STORE {
    my ($self,$field,$newval) = @_;
    my $member_func = "swig_${field}_set";
    $self->$member_func($newval);
}

sub this {
    my $ptr = shift;
    return tied(%$ptr);
}


# ------- FUNCTION WRAPPERS --------

package Amanda::Types;


############# Class : Amanda::Types::dumpfile_t ##############

package Amanda::Types::dumpfile_t;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( Amanda::Types );
%OWNER = ();
%ITERATORS = ();
*swig_type_get = *Amanda::Typesc::dumpfile_t_type_get;
*swig_type_set = *Amanda::Typesc::dumpfile_t_type_set;
*swig_datestamp_get = *Amanda::Typesc::dumpfile_t_datestamp_get;
*swig_datestamp_set = *Amanda::Typesc::dumpfile_t_datestamp_set;
*swig_dumplevel_get = *Amanda::Typesc::dumpfile_t_dumplevel_get;
*swig_dumplevel_set = *Amanda::Typesc::dumpfile_t_dumplevel_set;
*swig_compressed_get = *Amanda::Typesc::dumpfile_t_compressed_get;
*swig_compressed_set = *Amanda::Typesc::dumpfile_t_compressed_set;
*swig_encrypted_get = *Amanda::Typesc::dumpfile_t_encrypted_get;
*swig_encrypted_set = *Amanda::Typesc::dumpfile_t_encrypted_set;
*swig_comp_suffix_get = *Amanda::Typesc::dumpfile_t_comp_suffix_get;
*swig_comp_suffix_set = *Amanda::Typesc::dumpfile_t_comp_suffix_set;
*swig_encrypt_suffix_get = *Amanda::Typesc::dumpfile_t_encrypt_suffix_get;
*swig_encrypt_suffix_set = *Amanda::Typesc::dumpfile_t_encrypt_suffix_set;
*swig_name_get = *Amanda::Typesc::dumpfile_t_name_get;
*swig_name_set = *Amanda::Typesc::dumpfile_t_name_set;
*swig_disk_get = *Amanda::Typesc::dumpfile_t_disk_get;
*swig_disk_set = *Amanda::Typesc::dumpfile_t_disk_set;
*swig_program_get = *Amanda::Typesc::dumpfile_t_program_get;
*swig_program_set = *Amanda::Typesc::dumpfile_t_program_set;
*swig_application_get = *Amanda::Typesc::dumpfile_t_application_get;
*swig_application_set = *Amanda::Typesc::dumpfile_t_application_set;
*swig_srvcompprog_get = *Amanda::Typesc::dumpfile_t_srvcompprog_get;
*swig_srvcompprog_set = *Amanda::Typesc::dumpfile_t_srvcompprog_set;
*swig_clntcompprog_get = *Amanda::Typesc::dumpfile_t_clntcompprog_get;
*swig_clntcompprog_set = *Amanda::Typesc::dumpfile_t_clntcompprog_set;
*swig_srv_encrypt_get = *Amanda::Typesc::dumpfile_t_srv_encrypt_get;
*swig_srv_encrypt_set = *Amanda::Typesc::dumpfile_t_srv_encrypt_set;
*swig_clnt_encrypt_get = *Amanda::Typesc::dumpfile_t_clnt_encrypt_get;
*swig_clnt_encrypt_set = *Amanda::Typesc::dumpfile_t_clnt_encrypt_set;
*swig_recover_cmd_get = *Amanda::Typesc::dumpfile_t_recover_cmd_get;
*swig_recover_cmd_set = *Amanda::Typesc::dumpfile_t_recover_cmd_set;
*swig_uncompress_cmd_get = *Amanda::Typesc::dumpfile_t_uncompress_cmd_get;
*swig_uncompress_cmd_set = *Amanda::Typesc::dumpfile_t_uncompress_cmd_set;
*swig_encrypt_cmd_get = *Amanda::Typesc::dumpfile_t_encrypt_cmd_get;
*swig_encrypt_cmd_set = *Amanda::Typesc::dumpfile_t_encrypt_cmd_set;
*swig_decrypt_cmd_get = *Amanda::Typesc::dumpfile_t_decrypt_cmd_get;
*swig_decrypt_cmd_set = *Amanda::Typesc::dumpfile_t_decrypt_cmd_set;
*swig_srv_decrypt_opt_get = *Amanda::Typesc::dumpfile_t_srv_decrypt_opt_get;
*swig_srv_decrypt_opt_set = *Amanda::Typesc::dumpfile_t_srv_decrypt_opt_set;
*swig_clnt_decrypt_opt_get = *Amanda::Typesc::dumpfile_t_clnt_decrypt_opt_get;
*swig_clnt_decrypt_opt_set = *Amanda::Typesc::dumpfile_t_clnt_decrypt_opt_set;
*swig_cont_filename_get = *Amanda::Typesc::dumpfile_t_cont_filename_get;
*swig_cont_filename_set = *Amanda::Typesc::dumpfile_t_cont_filename_set;
*swig_dle_str_get = *Amanda::Typesc::dumpfile_t_dle_str_get;
*swig_dle_str_set = *Amanda::Typesc::dumpfile_t_dle_str_set;
*swig_is_partial_get = *Amanda::Typesc::dumpfile_t_is_partial_get;
*swig_is_partial_set = *Amanda::Typesc::dumpfile_t_is_partial_set;
*swig_partnum_get = *Amanda::Typesc::dumpfile_t_partnum_get;
*swig_partnum_set = *Amanda::Typesc::dumpfile_t_partnum_set;
*swig_totalparts_get = *Amanda::Typesc::dumpfile_t_totalparts_get;
*swig_totalparts_set = *Amanda::Typesc::dumpfile_t_totalparts_set;
*swig_blocksize_get = *Amanda::Typesc::dumpfile_t_blocksize_get;
*swig_blocksize_set = *Amanda::Typesc::dumpfile_t_blocksize_set;
sub new {
    my $pkg = shift;
    my $self = Amanda::Typesc::new_dumpfile_t(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        Amanda::Typesc::delete_dumpfile_t($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


# ------- VARIABLE STUBS --------

package Amanda::Types;

*F_UNKNOWN = *Amanda::Typesc::F_UNKNOWN;
*F_WEIRD = *Amanda::Typesc::F_WEIRD;
*F_TAPESTART = *Amanda::Typesc::F_TAPESTART;
*F_TAPEEND = *Amanda::Typesc::F_TAPEEND;
*F_DUMPFILE = *Amanda::Typesc::F_DUMPFILE;
*F_CONT_DUMPFILE = *Amanda::Typesc::F_CONT_DUMPFILE;
*F_SPLIT_DUMPFILE = *Amanda::Typesc::F_SPLIT_DUMPFILE;
*F_EMPTY = *Amanda::Typesc::F_EMPTY;

@EXPORT_OK = ();
%EXPORT_TAGS = ();

=head1 NAME

Amanda::Types - Amanda data structures that are shared by several modules

=head1 SYNOPSIS

This module includes several types which are not specific to any
single other module.

=head1 API STATUS

New structures may be added, but existing types are stable.

=head1 dumpfile_t

An in-memory representation of an Amanda header, with keys

=over

=item C<type>;

=item C<datestamp>;

=item C<dumplevel>;

=item C<compressed>;

=item C<encrypted>;

=item C<comp_suffix>;

=item C<encrypt_suffix>;

=item C<name> -- hostname or label;

=item C<disk>;

=item C<program>;

=item C<application>;

=item C<srvcompprog>;

=item C<clntcompprog>;

=item C<srv_encrypt>;

=item C<clnt_encrypt>;

=item C<recover_cmd>;

=item C<uncompress_cmd>;

=item C<encrypt_cmd>;

=item C<decrypt_cmd>;

=item C<srv_decrypt_opt>;

=item C<clnt_decrypt_opt>;

=item C<cont_filename>;

=itme C<dle_str>;

=item C<is_partial>;

=item C<partnum>;

=item C<totalparts> (-1 == UNKNOWN); and

=item C<blocksize>.

=back

where C<type> is one of the following constants, which are availble
for import in the tag C<:filetype_t>:

=over

=item C<F_UNKNOWN>;

=item C<F_WEIRD>;

=item C<F_TAPESTART>;

=item C<F_TAPEEND>;

=item C<F_DUMPFILE>;

=item C<F_CONT_DUMPFILE>;

=item C<F_SPLIT_DUMPFILE>; or

=item C<F_EMPTY>.

=back

NOTE: no methods are currently defined on C<dumpfile_t>; interfaces
can be written as needed.  A new dumpfile is created with

    my $hdr = Amanda::Types::dumpfile_t->new();

=cut

push @EXPORT_OK, qw(filetype_t_to_strings);
push @{$EXPORT_TAGS{"filetype_t"}}, qw(filetype_t_to_strings);

my %_filetype_t_VALUES;
#Convert a flag value to a list of names for flags that are set.
sub filetype_t_to_strings {
    my ($flags) = @_;
    my @result = ();

    for my $k (keys %_filetype_t_VALUES) {
	my $v = $_filetype_t_VALUES{$k};

	#is this a matching flag?
	if (($v == 0 && $flags == 0) || ($v != 0 && ($flags & $v) == $v)) {
	    push @result, $k;
	}
    }

#by default, just return the number as a 1-element list
    if (!@result) {
	return ($flags);
    }

    return @result;
}

push @EXPORT_OK, qw($F_UNKNOWN);
push @{$EXPORT_TAGS{"filetype_t"}}, qw($F_UNKNOWN);

$_filetype_t_VALUES{"F_UNKNOWN"} = $F_UNKNOWN;

push @EXPORT_OK, qw($F_WEIRD);
push @{$EXPORT_TAGS{"filetype_t"}}, qw($F_WEIRD);

$_filetype_t_VALUES{"F_WEIRD"} = $F_WEIRD;

push @EXPORT_OK, qw($F_TAPESTART);
push @{$EXPORT_TAGS{"filetype_t"}}, qw($F_TAPESTART);

$_filetype_t_VALUES{"F_TAPESTART"} = $F_TAPESTART;

push @EXPORT_OK, qw($F_TAPEEND);
push @{$EXPORT_TAGS{"filetype_t"}}, qw($F_TAPEEND);

$_filetype_t_VALUES{"F_TAPEEND"} = $F_TAPEEND;

push @EXPORT_OK, qw($F_DUMPFILE);
push @{$EXPORT_TAGS{"filetype_t"}}, qw($F_DUMPFILE);

$_filetype_t_VALUES{"F_DUMPFILE"} = $F_DUMPFILE;

push @EXPORT_OK, qw($F_CONT_DUMPFILE);
push @{$EXPORT_TAGS{"filetype_t"}}, qw($F_CONT_DUMPFILE);

$_filetype_t_VALUES{"F_CONT_DUMPFILE"} = $F_CONT_DUMPFILE;

push @EXPORT_OK, qw($F_SPLIT_DUMPFILE);
push @{$EXPORT_TAGS{"filetype_t"}}, qw($F_SPLIT_DUMPFILE);

$_filetype_t_VALUES{"F_SPLIT_DUMPFILE"} = $F_SPLIT_DUMPFILE;

push @EXPORT_OK, qw($F_EMPTY);
push @{$EXPORT_TAGS{"filetype_t"}}, qw($F_EMPTY);

$_filetype_t_VALUES{"F_EMPTY"} = $F_EMPTY;
1;
