//
//  Server.h  --  Server class definition
//  -- created  4/13/00  updated 4/19/00
//////////////////////////////////////////////

#ifndef SERVER_H
#define SERVER_H
namespace std {};
using namespace std;

#include <string>
#include <list>
#include "Folder.h"
#include "connection.h"

#define IMAPPORTNO 143

enum server_state 
    {
        NONAUTH, AUTH, SELECTED, LOGOUT 
    };


class Server
{
private:
    string server_name;
    string smtp_server_name;
    string imap_server_name;
    int port_number;
    string username;
    string password;
    string folder_root;
    string fccfolder;
    list<Folder> folder_list;
    server_state current_state;
    AConPtr network_connection;
    string emailaddress;
    bool savepassword;
    bool usessl;
    bool reserved;
    
public:
    // Public vars
    int timeout;

    // Constructors
    Server()
    {
	Server( "", "", "", IMAPPORTNO, "", "", "", "");
    };

    Server( string s_name, string smtp_name, string imap_name, int p_num, string uname, string pass, string f_root, string fcc_f)
    {
	server_name = s_name;
        smtp_server_name = smtp_name;
        imap_server_name = imap_name;
	port_number = p_num;  
	username = uname;
	password = pass;
        folder_root = f_root;
	fccfolder= fcc_f;
	//	emailaddress= email;
	reserved=false;
	timeout=0;
    };
    Server( string s_name, string smtp_name, string imap_name, int p_num, string uname, string pass, string f_root, string fcc_f,string email)
    {
	server_name = s_name;
        smtp_server_name = smtp_name;
        imap_server_name = imap_name;
	port_number = p_num;  
	username = uname;
	password = pass;
        folder_root = f_root;
	fccfolder= fcc_f;
	emailaddress= email;
	reserved=false;
	timeout=0;
    };



    // Mutators
    void set_Server_Name( const string &);
    void set_Port_Number( int );
    void set_Username( const string &);
    void set_Password( const string &);
    void set_Current_State( server_state );
    void set_IMAP_Server_Name(const string &);
    void set_SMTP_Server_Name(const string &);
    void set_FCC_Folder(const string &);
    void set_Folder_Root(const string &);
    void set_EMail_Address(const string &);    
    void set_Save_Password(bool);
    void set_Use_SSL(bool);

    // Accessors
    string get_Server_Name();
    string get_SMTP_Server_Name();
    string get_IMAP_Server_Name();
    int get_Port_Number();
    string get_Username();
    string get_Password();
    string get_FCC_Folder();
    int get_Num_Folders();
    server_state get_Current_State();
    Folder * get_Folder( int );
    AConPtr get_Connection();
    string get_Folder_Root();
    string get_EMail_Address();
    bool get_Save_Password();
    bool get_Use_SSL();
    bool get_Reserved();
    
    // Connection-related Functions
    int login();
    int logout();
    int check_Connected();
    int get_Folder_List_From_Server();
    void reserve();
    void release();

    // Folder-related Functions
    void add_Folder( Folder &);
    void delete_Folder( const string &name);         // delete based on folder name
    int get_New_Mail();
    
    // Debugging purposes only
    void display();
        

    
};

#endif
