#!/usr/bin/perl
#
# Copyright (C) 2004 Daniele Giacomini daniele@swlibero.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#
# index-html.cgi
#
#
local ($index) = "";
local ($line) = "";
local ($type) = "";
local ($user) = "";
local ($group) = "";
local ($size) = "";
local ($day) = "";
local ($name) = "";
local ($true_name) = "";
#
open (DIRECTORY_LISTING, "export LC_ALL=C ; ls -l --full-time --si |");
#
$index = "<!DOCTYPE HTML PUBLIC \"ISO/IEC 15445:2000//DTD HTML//EN\">\
<HTML LANG=\"en\">\
<HEAD>\
<TITLE>directory listing</TITLE>\
</HEAD>\
<BODY>\
<TABLE SUMMARY=\"directory listing\">\
<TBODY>\
<TR><TD>previous</TD><TD><A HREF=\"..\">..</A></TD><TD></TD></TR>\
";
while ($line = <DIRECTORY_LISTING>)
  {
    if ($line =~ m/^(\S)\S+\s+\S+\s+(\S+)\s+(\S+)\s+(\S+)\s+(\S+)\s+\S+\s+\S+\s+(.+)$/)
      {
	$type	= $1;
	$user	= $2;
	$group	= $3;
	$size	= $4;
	$day	= $5;
	$name	= $6;

	if ($type eq "d")
	  {
	    $index = $index . "<TR><TD>directory</TD>\
<TD><A HREF=\"$name\">$name/</A></TD><TD></TD></TR>\n";
	  }
	elsif ($type eq "l")
	  {
	    $name =~ m/^(\S+)\s+\-\>\s+(\S+)$/;
		$true_name = $2;
	    $index = $index . "<TR><TD>link</TD>\
<TD><A HREF=\"$true_name\">$name</A></TD><TD></TD></TR>\n";
	  }
	else
	  {
	    $index = $index . "<TR><TD>file</TD>\
<TD><A HREF=\"$name\">$name</A></TD><TD>$size</TD></TR>\n";
	  }
      }
  }
#
$index = $index . "\
</TBODY>\
</TABLE>\
</BODY>\
</HTML>\
";
close (DIRECTORY_LISTING);
#
print ("Content-Type: text/html\n\n");
print ($index);
#
