/*************************************************************************** 
  alienBlaster 
  Copyright (C) 2004 
  Paul Grathwohl, Arne Hormann, Daniel Kuehn, Soenke Schwardt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
***************************************************************************/
#ifndef BANNER_H
#define BANNER_H

#include "SDL.h"
#include <string>
#include "geometry.h"
#include "global.h"

class Banner {
  SDL_Surface *sprite;
  SDL_Surface *spriteBonus;

  int sound;

  Vector2D pos;
  int timeLived;

  BannerModes mode;
  BannerBoni bonus;

  public:
  Banner( BannerTexts text, BannerModes mode, BannerBoni bonus );
  ~Banner();
  
  void update( int dT );
  void draw( SDL_Surface *screen );
  bool isExpired();
  bool movingAway();
};

#endif
