package require xmpp
namespace import ::xmpp::*
# Module metainformation '''1
namespace eval meta {
	set description "Basic XMPP support"
	set author "Ihar Viarheichyk <iverg@mail.ru>"

	array set user [list description "User name" save change\
			default $::tcl_platform(user) weight .10]
	array set password { save change type password weight .11}
	array set resource { save change default alicq weight .12}
	array set add:Contact:xmpp { type action menu {Add "XMPP contact"} 
		script { Event AddItem Contact:xmpp }
	}
}

namespace eval network::meta {
	array set server { save change default localhost weight .20}
	array set port { save change default 5222 weight .21}
	array set proxy {
		type variant save change default "" weight .23 empty "No proxy"
		description "Proxy to use" 
		valuescript {map x [select Proxy] {lindex [split $x :] end}}
	}
	array set ssl { save change type boolean default 0 
		description "Use SSL"
	}
}

namespace eval [ref Contact:xmpp]::meta {
	set Identifier JID
	array set Send:text	{type action menu {Send Message} weight .10}
	array set Send:contacts	{type action menu {Send Contacts} weight .11}
	array set subscription { type cache save change }
}
#```

proc events {obj name args} {
	if {$name=="xmpp"} { 
		foreach {path attrs val} $args break
		foreach x $path { lappend tag [join $x :] }
		set name /[join $tag /]
	} 
	# Construct name of stanza context variable
	set obj [namespace current]::context::$obj
	if {[catch { eval [list Event xmpp:$name $obj] $args } reason]} {
		puts "event failed: $reason\n$::errorInfo"
	}
}

proc Debug {args} {
	puts "Proxy changed to $network::proxy"
}
# Change password for current jid
proc Password {obj password} {
	puts "Change password: $args"
}

proc Presence {status} {
	set [ref Me](Status) $status
	if {$status=="ffc"} {set status chat}\
	elseif {$status=="na"} {set status xa}
	if {[lsearch {away dnd chat xa} $status]==-1} { 
		jabber send [tag presence]
	} else { jabber send [tag presence [tag show $status]] }
}

# Low-level XMPP events (stanza start, connection establishment etc) '''1
# XMPP stanza contexts namespace 
namespace eval context {} 

handler xmpp:Log LogForward {obj tags str} {
	lappend tags XMPP
	Event Log $tags $str
	puts $str 
}
# Initialize context of new XMPP stanza
handler xmpp:Stanza:Start InitContext {obj args} { array set $obj [list] }

# Drop context after stanza is processed
handler xmpp:Stanza:End DropContext {obj} { unset $obj }

# XMPP connection established
handler xmpp:Established Established {obj args} {
	variable desired_status
	variable user
	if {[info exists desired_status]} {
		[namespace tail $obj] get auth_types [xmpp::tag\
			{jabber:iq:auth query} [xmpp::tag username $user]]
	}
}

# Handle disconnect
handler xmpp:Disconnected Disconnected {obj args} {
	set [ref Me](Status) offline
	foreach x [select Contact:xmpp] { set [ref $x](Status) offline }
}

# .......... Generic IQ and error handling (xmpp-core).......... '''1
# For result and error iq, checks if proper callback is registered,
# and invokes it. Deletes all callbacks for Iq ID. If no callbacks registered
# generate Alicq event.
handler {xmpp:/iq(result) xmpp:/iq(error)} iq-result {obj name attrs val} {
	array set aux $attrs
	if {![info exists aux(id)]} {
		Event Log {warning XMPP}\
		    "$aux(type) IQ stanza has no ID, skipping"
		return 
	}
	variable callbacks
	set key $aux(id),$aux(type)
	if {![info exists aux(from)]} { set aux(from) "" }
	if {[info exists callbacks($key)]} {
		eval $callbacks($key)
	} else { Event Iq:$aux(type):$aux(id) $obj $aux(id) $aux(from) }
	array unset callbacks $aux(id),*
	return -code break
} 0.7

handler xmpp:/iq(get) iq-get {obj name attrs val} {
	upvar 0 $obj context
	array set opt $attrs
	if {![info exists opt(id)]} {
		Log {warning xmpp} "Iq of type get has no id"
		set opt(id) ""
	}
	if {[info exists context(result)]} {
		[namespace tail $obj] send [xmpp::tag iq type result\
			id $opt(id) to $opt(from) $context(result)]
	}
	return -code break
} 0.7

handler xmpp:/iq(set) iq-set {obj name attrs val} {
	return -code break
} 0.7

# Skip Iq of unknown type with warning
handler xmpp:/iq(*) iq-noid {obj name attrs val} {
	array set aux $attrs
	Event Log {warning XMPP} "Unknown IQ type aux(type), skipping"
} 0.8

# Skip Iq without any type with warning
handler xmpp:/iq iq-unknown {obj name attrs val} {
	Event Log {warning XMPP} "IQ has no type, skipping"
}

# Generic 'query' handler - wrap result into incoming query tag.
# It has priority 0.4, thus specific handlers can either provide already
# wrapped result when having priority more than 0.4 (default), or provide 
# result which will be wrapped by this handler when having priority less
# than 0.4 (should be specified explicitly)
handler {xmpp:/iq(get)/*:query xmpp:/iq(get)/*:bind} Wrap {obj name args} {
	upvar 0 $obj context
	if {[info exists context(result)]} {
		set context(result) [tag [lindex $name end] $context(result)]
	}
} 0.4

handler xmpp:/*/*error onError {obj name attrs val} {
	array set aux $attrs
	array set $obj [list error $val code $aux(code)]
}

# If no other Iq error handler found, generate global error event
handler Iq:error:* DefaultError {obj args} {
	upvar 0 $obj context
	Event Error $context(code) $context(error)
} 0.9

# Default result handler - send responce if specified
handler Iq:result:* AutoResponce {obj args} {
	upvar 0 $obj context
	if {[info exists context(responce)]} { 
		[namespace tail $obj] send $context(responce) 
	}
} 0.9

# .......... Authentication and resource binding (xmpp-core).......... '''1
# Add DIGEST to the list of supported methods, if sha1 package is present
if {![catch { package require sha1} r]} {
	handler xmpp:/iq(result)/jabber:iq:auth:query/digest a/Digest {obj path args} {
		variable password
		AuthToken $obj digest [sha1::sha1 [[namespace tail $obj]\
			id][encoding convertto utf-8 $password]] 1
	}
} else { Event Log {warning XMPP auth} "Digest method is not supported: $r" }

# Password authentication method
handler xmpp:/iq(result)/jabber:iq:auth:query/password a/Pwd {obj path args} {
	variable password
	AuthToken $obj password $password 0
}

proc AuthToken {obj name value weight} {
	upvar 0 $obj context
	if {[info exists context(weight)] && $context(weight)>$weight} return
	puts "$name token ($weight) is passed"
	if {[info exists context(method)] &&
	    [info exists context($context(method))]} {
	    	unset context($context(method)) 
	}    
	array set context [list $name [escape $value]\
		weight $weight method $name]
}

# Resource binding
handler xmpp:/iq(result)/jabber:iq:auth:query/resource Resource {obj path args} {
	variable resource
	set ${obj}(resource) [escape $resource]
}

# Pass username back to responce 
handler xmpp:/iq(result)/jabber:iq:auth:query/username Username {obj path args} {
	variable user
	set ${obj}(username) [escape $user]
}

# Create authenitcation request
handler xmpp:/iq(result)/jabber:iq:auth:query AuthQuery {obj name args} {
	upvar 0 $obj context
	if {![info exists context(weight)]} {
		Event Log {error XMPP auth} "No authentication method!"
		return
	} else { unset context(weight) context(method) } 
	foreach {key val} [array get context] { append auth [tag $key $val] }
	set context(responce) [xmpp::tag iq type set id auth\
		[xmpp::tag {jabber:iq:auth query} $auth]]
}

# Authenticated sucessfully
handler Iq:result:auth AuthResult {obj args} {
	puts "Authorization passed: $obj"
	variable desired_status
	Presence $desired_status
	# Query roster
	[namespace tail $obj] get roster [tag {jabber:iq:roster query}]
	# Send messages we sent when offline
	variable queued
	if {[info exists queued]} {
		foreach item $queued { eval RealSend $item }
		unset queued
	}
}

handler Iq:error:auth AuthError {obj args} {
	#Event Error:auth [set context::${obj}(error)]
	puts "place auth code here"
	#return -code break
}	

# .......... Roster (xmpp-core) handling .......... '''1
variable hasRoster 0
handler xmpp:Disconnected noRoster {args} {
	variable hasRoster
	set hasRoster 0
}

handler Iq:result:roster InitialRoster {obj args} {
	upvar 0 $obj context
	variable hasRoster
	# Create new groups if needed
	foreach {uid val} [array get context Group:*] { new $uid $val }
	# Find contacts to add
	foreach uid [select Contact:xmpp] {
		if {![info exists context($uid)]} { append add [ItemTag $uid] }
	}
	# Sync contact with local ones
	foreach {uid val} [array get context Contact:*] {
		set ref [ref $uid]
		if {[info exists $ref]} {
			foreach {key val} $val {
				if {![info exists ${ref}($key)] ||
				     [set ${ref}($key)] != $val } { 
						set ${ref}($key) $val
				}
			}

		} else { new $uid $val }
	}
	# Add items
	if {[info exists add]} {
		[namespace tail $obj] set jabber-add [tag\
			{jabber:iq:roster query} $add]
	}
	set hasRoster 1
}

handler xmpp:/iq(result)/jabber:iq:roster:query/item RosterItem {obj p a val} {
	array set attr $a
	upvar 0 $obj context
	set uid Contact:xmpp:$attr(jid)
	if {[info exists attr(name)]} { 
		lappend context($uid) Alias $attr(name) 
	}
	lappend context($uid) subscription $attr(subscription)
	foreach {key val} [array get context {item *}] {
		lappend context($uid) [lindex $key end] $val
		unset context($key)
	}
	if {[info exists context(has-group)]} {
		unset context(has-group)
	} else {  lappend context($uid) Groups other }
}	

# Map group to one of existsing ones
handler xmpp:/iq(result)/jabber:iq:roster:query/item/group\
						ItemGroup {obj p a val} { 
	upvar 0 $obj context
	set g [select Group:common "\$Alias==\"$val\""]
	if {[llength $g]} { set val [lindex [split $g :] end]
	} else { set contect(Group:common:$val) [list Alias $val] }
	lappend {context(item Groups)} $val 
	set context(has-group) 1
}

# Add new item to roster
handler New:Contact:xmpp:* adder {uid} {
	variable hasRoster
	set [ref $uid](subscription) none
	if {$hasRoster} { ModifyRoster $uid }
	MonitorContact $uid
} 0.7

proc ModifyRoster {uid args} {
	variable hasRoster
	if {!$hasRoster} return
	jabber set roster-modify [tag {jabber:iq:roster query} [ItemTag $uid]]
}

proc ItemTag {uid} {
	upvar 0 [ref $uid] data
	set body ""
	set jid [lindex [split $uid :] end]
	puts "$uid: [array get data]"
	foreach x $data(Groups) { 
		if {$x=="other"} continue 
		append body [tag group [escape\
			[set [ref Group:common:${x}](Alias)]]]
	}
	tag item jid $jid subscription $data(subscription)\
		name [escape $data(Alias)] $body
}

proc DeleteRoster {ref args} {
	set jid [namespace tail $ref]
	jabber set roster-delete [xmpp::tag {jabber:iq:roster query}\
		[xmpp::tag item jid $jid subscription remove]]
}

# Check originator '''1
handler {xmpp:/message xmpp:/presence} Check-From {obj path attr val} {
	array set opt $attr
	if {[info exists opt(from)]} {
		set ${obj}(uid) [lindex\
			[split Contact:xmpp:[string tolower $opt(from)] /] 0]
	} else {
		Event Log warning "Originator is not given, skipping ($attr)"
		return -code break
	}
} 0.2

# .......... Basic messenging (xmpp-core) handling ..........'''1
handler xmpp:/message message {obj path attr val} {
	array set opt $attr
	if {![info exists opt(id)]} { set opt(id) 0 }
	upvar 0 $obj context
	# If message has body -display it
	if {[info exists context(body)]} {
		# If message does not have timestamp - take current time
		if {![info exists context(time)]} { 
			set context(time) [clock seconds]
		}
		Event Incoming text $context(uid) $context(time) $context(body) $opt(id)
	}
}

# Body - just store it in context
handler xmpp:/message/body message/body {obj path attr val} {
	set ${obj}(body) $val
}

# If message has jabber:x:delay x tag, take message time from it
handler xmpp:/message/jabber:x:delay:x stamp {obj path attr val} {
	array set opt $attr
	if {[info exists opt(stamp)]} {
		set ${obj}(time) [xmpp::stamp2time $opt(stamp)]
	}
}

# Prepare outgoing message to sending - wrap text to body tag
filter Send toRaw {type uid message} {
	if {![string match Contact:xmpp:* $uid] || $type!="text"} {
		return [list $type $uid $message] 
	}
	list raw $uid [tag body $message]
} 0.80


# .......... Presence (xmpp-core) handling .......... '''1
handler xmpp:/presence presence {obj path attr val} {
	array set opt $attr
	upvar 0 $obj context
	if {[info exists opt(type)] && $opt(type)=="subscribe"} {
		if {[info exists context(description)]} {
			set text $context(description)
		} else { set text "subsribe me" }
		Event Incoming authrequest $context(uid) [clock seconds] [list "" "" "" "" "" "" $text] 0
	} else {
		if {[info exist opt(type)] && $opt(type)=="unavailable"} { 
			set context(Status) offline
		}
		if {![info exists context(Status)]} { set context(Status) online}
		set ref [ref $context(uid)]
		unset context(uid)
		array set $ref [array get context]
	}	
}

handler xmpp:/presence/status presence/status {obj path attr val} {
	set ${obj}(description) $val
}

handler xmpp:/presence/show presence/show {obj path attr val} {
	if {[lsearch {away xa chat dnd} $val]==-1} { set val online }
	if {$val=="xa"} { set val na } elseif {$val=="chat"} { set val ffc}
	set ${obj}(Status) $val
}

# Alicq events handling '''1
handler Send Send {type uid message} {
	if {![string match Contact:xmpp:* $uid]} { return -code continue }
	set cmd message:$type
	if {[info commands $cmd]!=$cmd} {
		return -code error "Unknown message type $type" 
	}
	set msgid [format "%08x:%08x" [clock seconds] [clock clicks]]
	if {[jabber connected?]} { 
		after idle [nc RealSend $cmd $uid $message $msgid]
	} else {
		variable queued
		lappend queued [list $cmd $uid $message $msgid]
	}
	Event Outgoing $type $uid [clock seconds] $message $msgid
	set msgid
} 0.90

proc RealSend {cmd uid message msgid} {
	set jid [lindex [split $uid :] end]
	$cmd $jid $message $msgid
	Event $uid|Acknowledgement sent $uid $msgid
}

# Normal message
proc message:raw {jid message id} {
	jabber send [tag message id $id type chat to $jid $message]
}

# Ask subsription from contact
proc message:subscription {jid message args} {
	jabber send [tag presence type subscribe to $jid [tag status [escape $message]]]
}

# Grant subsription
proc message:authorization {jid args} {
	jabber send [tag presence type subscribed to $jid]
}

handler SetStatus SetStatus {status} {
	variable desired_status
	if {$status=="offline"} {
		jabber disconnect
		if {[info exists desired_status]} { unset desired_status }
	} else {
		if {[jabber connected?]} { Presence $status } else {
			set desired_status $status
			jabber connect
		}
	}
}

handler MessageTypes messagetypes {uid} {
	if {![string match Contact:xmpp:* $uid]} { return -code continue }
	set lst {text subscription}
}

handler ConfigLoaded onConfig {} {
	# Determine language code for current locale
	set lang [lindex [::msgcat::mcpreferences] end]
	# Accept only 2-character language codes to exlude locales such as POSIX
	if {[string length $lang]!=2} { set lang "" }
	xmpp::xmpp jabber -event [namespace code events] -lang $lang
	foreach x [info vars network::*] {
		jabber configure -[namespace tail $x] [set $x]
	}
	foreach x [select Contact:xmpp] { MonitorContact $x }
}

proc MonitorContact {uid} {
	trace variable [ref $uid](Alias) w [nc ModifyRoster $uid]
	trace variable [ref $uid](Groups) w [nc ModifyRoster $uid]
	trace variable [ref $uid](Groups) u [nc DeleteRoster]
}
