#  Alicq ICQ client: module for dealing with licq configuration files
#  Copyright (C) Ihar Viarheichyk 2001

#  This module is a part of Alicq ICQ client.

# This module allow use licq user database in alicq

parameter AllowChange no
# Retrieve user list 
proc GetLicqUsers {path} {
	global Contacts
	foreach file [glob -directory $path "*.uin"] {	
		set uid [file root [file tail $file]]
		set alias $uid
		set fd [open $file]
		while {![eof $fd]} {
			gets $fd ln
			if {[regexp {Groups.User *= *(.*)$} $ln s groupid]} {
				set gid $groupid 
			}
			if {[regexp {Alias *= *(.*)$} $ln s icqalias]} {
				set alias $icqalias 
			}
		}
		if {![info exists gid]} { set gid 0 }
		set gr {}
		for {set i 1} {$gid!=0} {set gid [expr $gid>>1]; incr i} {
			if {[expr $gid&1]} {
				lappend gr $i
			}
		}
		Contact $uid $alias $gr
	}
}

# Get owner's UIN and password
proc GetLicqOwner {filename} {
	global Contacts
	set fd [open $filename r]
	set attributes {Uin Password Alias}
	while {![eof $fd]} {
		gets $fd ln
		foreach attr $attributes {
			if {[regexp "$attr *= *(.*)$" $ln s value]} {
				set Contacts(me:$attr) $value
			}
		}
	}
}

proc GetLicqGroups {filename} {
	global ::Groups
	set fd [open $filename r]
	while {![eof $fd]} {
		gets $fd ln
		if {[regexp {^Group([0-9])+\.name *= *(.*)$} $ln s id name]} {
			set ::Groups($id) $name
		}
	}

}

# Save message to history
proc Message {type UIN time Message} {
	set fd [open "~/.licq/history/$UIN.history" a+]
	puts $fd "\[ $type | 0001 | 0270 | 0000 | $time \]"
	foreach ln [split $Message \n] {
		puts $fd ":$ln"
	}
	close $fd
}
proc ModifyLicqContacts {name1 name2 op} {
	upvar 1 $name1 Contacts
	if {$licq::AllowChange!="yes"} return
	foreach {uin tag} [split $name2 :] break
	set fname "~/.licq/users/$uin.uin"
	if {$op=="u"} {
		if {[file exists $fname]} { file delete $fname }
		set fd [open "~/.licq/users.conf" r]
		set num 0
		set s {}
		while {![eof $fd]} {
			gets $fd ln
			if {[regexp {^NumOfUsers\s*=\s*([0-9]*)} $ln s num]} {
				break
			}
		}
		close $fd
		incr num -1
	 	ChangeInfo "~/.licq/users.conf" {^NumOfUsers} "NumOfUsers = $num"
	 	ChangeInfo "~/.licq/users.conf" "$uin$" {}
		return

	}
	if {![file exists $fname]} {
		set fd [open $fname w]
		foreach item {"\[user\]" "History = default"\
				"Groups.System = 0" "Groups.User = 0"\
				"Ip = 0.0.0.0" "Port = 0" "LastOnline = 0"\
				"LastSent = 0" "LastRecv = 0"\
				"LastCheckedAR = 0" "AutoAccept = 0"\
				"StatusToUser = 65535" "CustomAutoRsp = "\
				"SendRealIp = 0" "Alias = no"} {
			puts $fd $item
		}
		foreach item {FirstName Email1 Email2 Email0\
			City State PhoneNumber FaxNumber Address\
			CellularNumber ZipCode Country Timezone\
			Authorization HideEmail Age Gender Homepage\
			BirthYear BirthMonth BirthDay Language1 Language2\
			Language3 CompanyCity CompanyState CompanyPhoneNumber\
			CompanyFaxNumber CompanyAddress CompanyName\
			CompanyDepartment CompanyPosition CompanyHomepage\
			About UserEncoding} {
			puts $fd "$item = "
		}
		close $fd
		set fd [open "~/.licq/users.conf" r]
		set num 0
		set s {}
		while {![eof $fd]} {
			gets $fd ln
			if {[regexp {^NumOfUsers\s*=\s*([0-9]*)} $ln s num]} {
				break
			}
		}
		close $fd
		incr num
	 	ChangeInfo "~/.licq/users.conf" {^NumOfUsers} "NumOfUsers = $num"
	 	ChangeInfo "~/.licq/users.conf" "^User$num" "User$num = $uin"		
	}
	if {$tag=="Alias"} {
		ChangeInfo $fname {^Alias} "Alias = $Contacts($uin:Alias)"
		return
	}
	if {$tag=="Groups"} {
		set gr $Contacts($uin:Groups)
		if {[set idx [lsearch $gr other]]!=-1} {
			set gr [lreplace $gr $idx $idx]
			puts $gr
		}
		ChangeInfo $fname {^Groups\.User} "Groups.User = [CalcBitmap $gr]"
		return
	}
}
proc CalcBitmap {groups} {
	set bitmap 0
	foreach item $groups {
		if {$item>16} continue
		set bitmap [expr $bitmap|(1<<($item-1))]
	}
	return $bitmap
}
proc GetLicqHistory {historybase uin var} {
		upvar 1 $var history
		set fname [file join $historybase ${uin}.history]
		if {[catch {set fd [open $fname r]}]} {
				return
		}
		set history ""
		while {![eof $fd]} {
				gets $fd ln
				if {[regexp {^\[ ([RS]).* ([0-9]+) \]$} $ln re dir utime]} {
					if {[info exists msg]} { 
						lappend history $msg
						set msg ""
					}
					if {$dir=="S"} {set dir outgoing}
					if {$dir=="R"} {set dir incoming}
					lappend history $dir $utime
					continue
				}
				if {[regexp {^:(.*)$} $ln re line]} {
					append msg $line "\n"
					continue
				}
		}
		if {[info exists msg]} { lappend history $msg }	
}

set licqbase [file join ~ .licq]

GetLicqGroups [file join $licqbase licq.conf]
GetLicqUsers [file join $licqbase users]
GetLicqOwner [file join $licqbase owner.uin]

Hook IncomingMessage "licq::Message R"
Hook OutgoingMessage "licq::Message S"
Hook History "licq::GetLicqHistory [file join $licqbase history]"
trace variable ::Contacts wu licq::ModifyLicqContacts

