# ---------------------------------------------------------------------------
# - net-0007.als                                                            -
# - aleph example : network library example                                 -
# ---------------------------------------------------------------------------
# - This program is free software;  you can redistribute it  and/or  modify -
# - it provided that this copyright notice is kept intact.                  -
# -                                                                         -
# - This program  is  distributed in  the hope  that it will be useful, but -
# - without  any  warranty;  without  even   the   implied    warranty   of -
# - merchantability or fitness for a particular purpose.  In no event shall -
# - the copyright holder be liable for any  direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.     -
# ---------------------------------------------------------------------------
# - copyright (c) 1999-2001 amaury darsch                                   -
# ---------------------------------------------------------------------------

# print some socket information

# get the network library
interp:library "aleph-net"

# get the daytime server port
const port (aleph:net:get-tcp-service "daytime")

# create a client socket and read the data
const print-socket-info (host) {
  # create a tcp client socket
  const s (aleph:net:TcpClient host port)
  # print socket address and port
  const saddr (s:get-socket-address)
  const sport (s:get-socket-port)
  println "socket ip address     : " (saddr:get-ip-address)
  println "socket canonical name : " (saddr:get-canonical-name)
  println "socket port           : " sport
  # print peer address and port
  const paddr (s:get-peer-address)
  const pport (s:get-peer-port)
  println "peer ip address       : " (paddr:get-ip-address)
  println "peer canonical name   : " (paddr:get-canonical-name)
  println "peer port             : " pport  
}

# check for one argument or use localhost
const host (if (== (interp:argv:length) 0) "localhost" (interp:argv:get 0))
print-socket-info host
