// ---------------------------------------------------------------------------
// - Iterator.cpp                                                            -
// - standard object library - iterator abstract class implementation        -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2001 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "String.hpp"
#include "Vector.hpp"
#include "Boolean.hpp"
#include "Iterator.hpp"

namespace aleph {
  
  // the iterator supported quarks
  static const long QUARK_END      = String::intern ("end");
  static const long QUARK_ENDP     = String::intern ("end-p");
  static const long QUARK_NEXT     = String::intern ("next");
  static const long QUARK_BEGIN    = String::intern ("begin");
  static const long QUARK_VALIDP   = String::intern ("valid-p");
  static const long QUARK_GETOBJ   = String::intern ("get-object");
  static const long QUARK_PREVIOUS = String::intern ("previous");

  // apply an iterator method with a set of arguments by quark

  Object* Iterator::apply (Runnable* robj, Nameset* nset, const long quark,
			   Vector* argv) {

    // get the number of arguments
    long argc = (argv == nilp) ? 0 : argv->length ();

    // dispatch 0 argument
    if (argc == 0) {
      if (quark == QUARK_GETOBJ) return getobj ();
      if (quark == QUARK_VALIDP) return new Boolean (valid ());
      if (quark == QUARK_ENDP)   return new Boolean (isend ());
      if (quark == QUARK_BEGIN) {
	begin ();
	return nilp;
      }
      if (quark == QUARK_END) {
	end ();
	return nilp;
      }
      if (quark == QUARK_NEXT) {
	next ();
	return nilp;
      }
      if (quark == QUARK_PREVIOUS) {
	prev ();
	return nilp;
      }
    }

    // call the object method
    return Object::apply (robj, nset, quark, argv);
  }
}
