// ---------------------------------------------------------------------------
// - Finalize.hpp                                                            -
// - standard object library - object finalizer class definition             -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2001 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  ALEPH_FINALIZE_HPP
#define  ALEPH_FINALIZE_HPP

#ifndef  ALEPH_OBJECT_HPP
#include "Object.hpp"
#endif

namespace aleph {
  
  /// The Finalize class is a reserved class used to finalize an object
  /// in a multi-threaded environment. The class is a circular fifo which
  /// holds the object and destroy them in a circular way. The class has
  /// also a mechanism which auto-lock itself during the final destruction.
  /// this class cannot be instanciated - it is only a friend of the Object
  /// class;
  /// @author amaury darsch

  class Finalize {
  private:
    /// the fifo size
    long d_size;
    /// the fifo pointer
    Object** p_fifo;
    /// the current position
    long d_pos;
    /// the locking destruction
    bool d_lock;

  public:
    /// create a new finalize class
    Finalize (void);

    /// destroy this finalizer
    ~Finalize (void);

    /// append an object for finalization
    /// @param object the object to finalize
    void append (Object* object);

  private:
    // make the copy constructor private
    Finalize (const Finalize&);
    // make the assignment operator private
    Finalize& operator = (const Finalize&);
  };
}

#endif
