# ---------------------------------------------------------------------------
# - net-0004.als                                                            -
# - aleph example : network library example                                 -
# ---------------------------------------------------------------------------
# - This program is free software;  you can redistribute it  and/or  modify -
# - it provided that this copyright notice is kept intact.                  -
# -                                                                         -
# - This program  is  distributed in  the hope  that it will be useful, but -
# - without  any  warranty;  without  even   the   implied    warranty   of -
# - merchantability or fitness for a particular purpose.  In no event shall -
# - the copyright holder be liable for any  direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.     -
# ---------------------------------------------------------------------------
# - copyright (c) 1999-2001 amaury darsch                                   -
# ---------------------------------------------------------------------------

# fetch an html page by host and page
# usage: aleph 3203.als [host] [page]

# get the network library
interp:library "aleph-net"
interp:library "aleph-sys"

# connect to the http server and issue a request
const send-http-request (host page) {
  # create a client sock on port 80
  const s     (aleph:net:TcpClient host 80)
  const saddr (s:get-socket-address)

  # format the request
  s:writeln "GET " page " HTTP/1.1"
  s:writeln "Host: " (saddr:get-canonical-name)
  s:writeln "Connection: close"
  s:writeln "User-Agent: aleph tcp client example"
  s:newline

  # write the result
  while (s:valid-p) (println (s:readln))
}

# get the argument
if (!= (interp:argv:length) 2) (aleph:sys:exit 1)
const host (interp:argv:get 0)
const page (interp:argv:get 1)

# send request
send-http-request host page

