//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

//Systemwide includes
#include <qdialog.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qtextedit.h>
#include <qfont.h>
#include <qpushbutton.h>
#include <qpixmap.h>

//Projectwide includes
#include "alertDialog.h"
#include "../../config.h"

//==============================================
AlertDialog::AlertDialog( QString message,
                                  QString description,
                                  QString alertIconName,
                                  QWidget* parent,
                                  const char* name ) :
                                  QDialog(parent, name, true )
{
  //-------------------------------
  //create widgets
  topFrame = new QFrame( this );

  alertText = new QLabel( topFrame );
  alertText->setText( message );
  
  QFont alertFont = alertText->font();
  alertFont.setWeight(QFont::Bold);
  alertText->setFont( alertFont );

  alertIcon = new QPixmap(QString(IMAGE_PATH)+alertIconName);
  alertIconLabel = new QLabel( topFrame );
  alertIconLabel->setPixmap( *alertIcon );

  descriptionText = new QTextEdit( this );
  descriptionText->setReadOnly(true);
  descriptionText->setText( description );

  bottomFrame = new QFrame( this );
  okButton = new QPushButton( tr("OK"), bottomFrame );
  okButton->setSizePolicy( QSizePolicy::Fixed, QSizePolicy::Fixed );
  okButton->setDefault(true);
  okButton->setFocus();

  connect( okButton, SIGNAL(clicked()), SLOT(accept()) );
  //-------------------------------
  //create grid and place widgets
  gridTop     = new QGridLayout( topFrame, 1, 2, 0);
  gridTop->addWidget( alertText, 0, 0 );
  gridTop->addWidget( alertIconLabel, 0, 1, Qt::AlignRight );

  gridBottom  = new QGridLayout( bottomFrame, 1, 1, 0);
  gridBottom->addWidget( okButton, 0, 0 );

  gridFull    = new QGridLayout( this, 3, 1, 0);
  gridFull->addWidget( topFrame, 0, 0);
  gridFull->addWidget( descriptionText, 1, 0);
  gridFull->addWidget( bottomFrame, 2, 0);

  gridFull->setRowStretch( 1, 1 );
  gridFull->setResizeMode( QLayout::FreeResize );
  gridFull->setMargin(WIDGET_SPACING);
  gridFull->setSpacing(WIDGET_SPACING);

  setMinimumWidth(300);
  setMaximumWidth(300);
  //-------------------------------
  //setup window title bar
  setCaption( message );
  //-------------------------------
  //set window to not be resizeable
  this->show();
  setFixedSize(size());
  //-------------------------------
}
//==============================================
AlertDialog::~AlertDialog()
{
  delete alertIcon;
}
//==============================================
