<xsl:stylesheet
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
     version="1.0">
     
<!-- ####################################### -->
<!-- ####################################### -->
<!-- Write thumbnail html pages -->
<xsl:template match="album" mode="contactsheets">
<xsl:variable name="albumAuthor" select="author"/>

<xsl:for-each select="subalbum">
    
  <xsl:if test="count(photo)">
  
  <xsl:variable name="subalbumNumber" select="position()"/>
  <xsl:document method="html" indent="yes" href="{concat($outputPath, '/subalbum_', string(position()), '_thumbs.html')}"> 
    <html>
      <head>
        <meta name="generator" content="Album Shaper (c.) Will Stokes"/>
        <meta name="theme" content="{$themeString}" />
	    <meta name="author" content="{$albumAuthor}" />

	    <link rel="stylesheet" href="resources/style.css" type="text/css" />

        <title><xsl:value-of select="name"/></title>
      </head>
     <body bgcolor="white" text="black" link="#0000FF" vlink="#0000FF" alink="#FF0000">
      <font face='Arial, sans-serif'>
        <center>
          <table border="0" cellpadding="0" cellspacing="0">

<!-- ################## -->
<!-- ### Top Border ### -->
<!-- ################## -->
<tr>
  <td style="background-image: url(resources/topLeft.png);" width="16" height="16"></td>
  <td style="background-image: url(resources/horizontal.png); background-repeat:repeat-x;" height="16"></td>
  <td style="background-image: url(resources/topRight.png);" width="16" height="16"></td>
</tr>

<!-- ################################# -->
<!-- ### Subalbum name and description -->
<!-- ################################# -->
<tr>
  <td style="background-image: url(resources/vertical.png); background-repeat:repeat-y;" width="16"></td>
  <td width="600" align="center">

<table border="0"><tr>
<td width="180"><div class="title"><xsl:value-of select="name"/></div></td>
<td><div class="subtitle"><xsl:value-of select="description"/></div></td>
</tr></table>

  </td>
  <td style="background-image: url(resources/vertical.png); background-repeat:repeat-y;" width="16"></td>
</tr>

<!-- ################# -->
<!-- ### Photos    ### -->
<!-- ################# -->
<tr>
  <td style="background-image: url(resources/vertical.png); background-repeat:repeat-y;" width="16"></td>
  <td>
  
          <table border="0">
            <tr>
              <xsl:for-each select="photo">
              <xsl:variable name="photoDescription" select="description"/>
              <td valign="top" width="220"><a name="{position()}"/>
                <center>
                <table border="0">
                  <tr>
                    <td valign="top">
                      <center>

                     <script type="text/javascript" language="JavaScript">
                     <![CDATA[
                     <!-- HIDE FROM OLD BROWSERS
                       document.write( "<a href='subalbum_]]><xsl:value-of select="$subalbumNumber"/><![CDATA[_slideshow.html?photo=]]><xsl:value-of select="position()"/><![CDATA['>" );
                       document.write( "<img border=\"2\" src='img/]]><xsl:value-of select="$subalbumNumber"/><![CDATA[/]]><xsl:value-of select="position()"/><![CDATA[_thumb.jpg' alt='$photoDescription'/>" );
                       document.write( "</a>" );
                     -->
                     ]]>
                     </script>

                      <noscript>
                        <xsl:if test="$smallWebExport=0">                                                                 
                          <a href="img/{$subalbumNumber}/{position()}.jpg"><img border="2" src="img/{$subalbumNumber}/{position()}_thumb.jpg" alt="$photoDescription"/></a>
                        </xsl:if>
                        <xsl:if test="$smallWebExport=1">                                                                 
                          <a href="img/{$subalbumNumber}/{position()}_slideshow.jpg"><img border="2" src="img/{$subalbumNumber}/{position()}_thumb.jpg" alt="$photoDescription"/></a>
                        </xsl:if>                
                      </noscript>


                      </center>
                    </td>
                  </tr>
                  <tr>
                    <td valign="bottom">
                      <center>

                     <script type="text/javascript" language="JavaScript">
                     <![CDATA[
                     <!-- HIDE FROM OLD BROWSERS
                       document.write( "<div class='item'><a href='subalbum_]]><xsl:value-of select="$subalbumNumber"/><![CDATA[_slideshow.html?photo=]]><xsl:value-of select="position()"/><![CDATA['>" );
                       document.write( "]]><xsl:variable name="photoDescription" select="description"/><xsl:call-template name="JavaScriptString"><xsl:with-param name="string" select="$photoDescription"/></xsl:call-template><![CDATA[" );
                       document.write( "</a></div>" );
                     -->
                     ]]>
                     </script>

                      <noscript>
                        <div class="item">
                        <xsl:if test="$smallWebExport=0">                                                                 
                          <a href="img/{$subalbumNumber}/{position()}.jpg"><xsl:value-of select="description"/></a>
                        </xsl:if>
                        <xsl:if test="$smallWebExport=1">                                                                 
                          <a href="img/{$subalbumNumber}/{position()}_slideshow.jpg"><xsl:value-of select="description"/></a>
                        </xsl:if>          
                        </div>      
                      </noscript>

                      </center>
                    </td>
                  </tr>
                </table>
              </center>
              </td>
              <xsl:if test="not(position() mod 3)">
                <xsl:text disable-output-escaping="yes"> &lt;/tr&gt;&lt;tr&gt;</xsl:text>
              </xsl:if>
              </xsl:for-each>
              <xsl:call-template name="endRow">
                <xsl:with-param name="cellsLeft" select="(3 - (count(photo) mod 3))"/>
              </xsl:call-template>
            </tr>
          </table>

  </td>
  <td style="background-image: url(resources/vertical.png); background-repeat:repeat-y;" width="16"></td>
</tr>

<!-- ################# -->
<!-- ### Separator ### -->
<!-- ################# -->
<tr>
  <td style="background-image: url(resources/leftJoint.png);" width="16" height="16"></td>
  <td style="background-image: url(resources/horizontal.png); background-repeat:repeat-x;" height="16"></td>
  <td style="background-image: url(resources/rightJoint.png);" width="16" height="16"></td>
</tr>

<!-- ##################################### -->
<!-- ### Links to other parts of album ### -->
<!-- ##################################### -->
<tr>
  <td style="background-image: url(resources/vertical.png); background-repeat:repeat-y;" width="16"></td>
  <td>
    <table width="100%" border="0"><tr>   

      <td width="64" valign="middle" align="center">  </td>

      <script type="text/javascript" language="JavaScript">
      <![CDATA[
      <!-- HIDE FROM OLD BROWSERS
      document.write("<td width=\"140\" valign=\"middle\" align=\"right\" cellpadding=\"10\">")
      document.write("  <table border=\"0\"><tr>")
      document.write("    <td><a href=\"subalbum_]]><xsl:value-of select="position()"/><![CDATA[_slideshow.html\">")
      document.write("      <img src=\"resources/otherLayout.png\" border=\"0\"/>")
      document.write("    </a></td>")
      document.write("    <td><div class=\"pageDetails\" valign=\"middle\" align=\"right\">")
      document.write("      <a href=\"subalbum_]]><xsl:value-of select="position()"/><![CDATA[_slideshow.html\">Slideshow</a>")
      document.write("    </div></td>")
      document.write("  </tr></table>")
      document.write("</td>")
      document.write("<td width=\"30\"> </td>")
      -->
      ]]>
      </script>

      <td width="140" valign="middle" align="left">
        <table border="0"><tr>
          <td><a href="Album.html">
            <img src="resources/contents.png" border="0"/>
          </a></td>
          <td><div class="pageDetails" valign="middle" align="right">
            <a href="Album.html">
            Album Index</a>
          </div></td>
        </tr></table>
      </td>

      <td valign="middle" align="center" width="64">
        <a href="http://albumshaper.sf.net" title="Generated by Album Shaper, Slick theme">
          <img src="resources/asLogo.png" border="0"/>
        </a>
      </td>

    </tr></table>
  </td>

  <td style="background-image: url(resources/vertical.png); background-repeat:repeat-y;" width="16"></td>
</tr>

<!-- ################# -->
<!-- ### Bottom Border -->
<!-- ################# -->
<tr>
  <td style="background-image: url(resources/bottomLeft.png);" width="16" height="16"></td>
  <td style="background-image: url(resources/horizontal.png); background-repeat:repeat-x;" height="16"></td>
  <td style="background-image: url(resources/bottomRight.png);" width="16" height="16"></td>
</tr>

</table>
</center>

      </font>
      </body>
    </html>
  </xsl:document>

</xsl:if>

</xsl:for-each>
</xsl:template>
<!-- ####################################### -->
<!-- ####################################### -->

</xsl:stylesheet>





