#
# Copyright 2001 by Object Craft P/L, Melbourne, Australia.
#
# LICENCE - see LICENCE file distributed with this software for details.
#
# 
# Test macros.
#
# $Id: macro.py 6253 2006-01-10 04:56:40Z andrewm $

import unittest
import albatross
import albatross_test

class MacroCase(albatross_test.AlbatrossTestCase):
    template_dir = "macro"

    def check_macro_0arg(self):
        self.html_test("0arg.html", "content\n")

    def check_macro_0arg_dup(self):
        self.html_test("0arg-dup.html", "content\ncontent\n")

    def check_macro_1arg(self):
        self.html_test("1arg.html", "xxx argument xxx\n")

    def check_macro_2arg(self):
        self.html_test("2arg.html", "xxx first second xxx\n")

    def check_macro_unnamed(self):
        self.html_test("unnamed.html", "xxx unnamed body xxx\n")

    def check_macro_unclosed(self):
        self.assertRaises(albatross.ApplicationError, self.html_test, "unclosed.html", "(none)")

    def check_macro_unclosedarg(self):
        self.assertRaises(albatross.ApplicationError, self.html_test, "unclosedarg.html", "(none)")

    def check_macro_missingarg(self):
        self.assertRaises(albatross.ApplicationError, self.html_test, "missingarg.html", "(none)")

class MacroSuite(unittest.TestSuite):
    test_list = (
        "check_macro_0arg",
        "check_macro_0arg_dup",
        "check_macro_1arg",
        "check_macro_2arg",
        "check_macro_unnamed",
        "check_macro_unclosed",
        "check_macro_unclosedarg",
        "check_macro_missingarg",
    )
    def __init__(self):
        unittest.TestSuite.__init__(self, map(MacroCase, self.test_list))

def suite():
    return MacroSuite()

if __name__ == '__main__':
    unittest.main(defaultTest='suite')
