#!/bin/sh
# 
# test the signing tools

unset AFFLIB_PASSPHRASE

BASE=`mktemp -t baseXXXXX`
AGENT_PEM=$BASE.agent.pem
ANALYST_PEM=$BASE.analyst.pem
ARCHIVES_PEM=$BASE.archives.pem
EVIDENCE=$BASE.evidence.aff
EVIDENCE2=$BASE.evidence2.aff
EVIDENCE3=$BASE.evidence3.aff

/bin/rm -f $AGENT_PEM $ANALYST_PEM $ARCHIVES_PEM $EVIDENCE $EVIDENCE2 $EVIDENCE3

echo === MAKING THE TEST FILES ===

export PATH=$srcdir:../tools:../../tools:.:$PATH
test_make_random_iso.sh rawevidence.iso


echo ==== AFSIGN TEST ===
echo Making X.509 keys

openssl req -x509 -newkey rsa:1024 -keyout $AGENT_PEM -out $AGENT_PEM -nodes -subj "/C=US/ST=California/L=Remote/O=Country Govt./OU=Sherif Dept/CN=Mr. Agent/emailAddress=agent@investiations.com"

 openssl req -x509 -newkey rsa:1024 -keyout $ANALYST_PEM -out $ANALYST_PEM -nodes -subj "/C=US/ST=California/L=Remote/O=State Police/OU=Forensics/CN=Ms. Analyst/emailAddress=analyst@investiations.com"
openssl req -x509 -newkey rsa:1024 -keyout $ARCHIVES_PEM -out $ARCHIVES_PEM -nodes -subj "/C=US/ST=CA/L=Remote/O=Archives/OU=Electronic/CN=Dr. Librarian/emailAddress=drbits@investiations.com"

echo Making an AFF file to sign
rm -f $EVIDENCE evidence?.aff
afconvert -o $EVIDENCE rawevidence.iso 
echo Initial AFF file
if ! afinfo -a $EVIDENCE ; then exit 1 ; fi

echo Signing AFF file...
echo afsign -k $AGENT_PEM $EVIDENCE 
if ! afsign -k $AGENT_PEM $EVIDENCE ; then echo afsign failed ; exit 1 ; fi 

echo Verifying Signature...
echo afverify $EVIDENCE 
if ! afverify $EVIDENCE ; then echo afverify failed ; exit 1 ; fi ; 

echo Signature test 1 passed

echo Testing chain-of-custody signatures
echo Copying original raw file to evidence1.aff

if ! afcopy -z -k $AGENT_PEM rawevidence.iso evidence1.aff ; then exit 1; fi
if ! afinfo -a evidence1.aff ; then exit 1 ; fi
if ! afcompare rawevidence.iso evidence1.aff ; then exit 1 ; fi
if ! afverify evidence1.aff ; then exit 1 ; fi

echo
echo Making the second generation copy
echo "This copy was made by the analyst" | afcopy -z -k $ANALYST_PEM -n evidence1.aff $EVIDENCE2
if ! afinfo -a $EVIDENCE2 ; then exit 1 ; fi
if ! afcompare rawevidence.iso $EVIDENCE2 ; then exit 1 ; fi
if ! afverify $EVIDENCE2 ; then exit 1 ; fi
echo
echo Making the third generation copy
echo "This copy was made by the archives" | afcopy -z -k $ARCHIVES_PEM -n $EVIDENCE2 $EVIDENCE3
if ! afinfo -a $EVIDENCE3 ; then exit 1 ; fi
if ! afcompare rawevidence.iso $EVIDENCE3 ; then exit 1 ; fi
if ! afverify $EVIDENCE3 ; then exit 1 ; fi


echo All tests passed successfully
echo Erasing temporary files.
rm -f $AGENT_PEM $ARCHIVES_PEM $ANALYST_PEM $EVIDENCE evidence.afm rawevidence.iso cevidence.iso $EVIDENCE2 $EVIDENCE3 $EVIDENCE
exit 0

