/*
   Project: UL

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/
#ifndef _ULANALYSER_
#define _ULANALYSER_
#include <AppKit/AppKit.h>
#include <AdunKernel/AdunDataSet.h>
#include <AdunKernel/AdunSimulationData.h>
#include <AdunKernel/AdunMemoryManager.h>
#include <MolTalk/MolTalk.h>
#include "ULFramework/ULIOManager.h"
#include "ULFramework/ULAnalysisManager.h"
#include "ULAnalyserDataSetView.h"
#include "ViewController.h"
#include "ULProgressPanel.h"
#include "ULOutlineViewDelegate.h"

/**
Main class for data analysis
\ingroup interface
*/

@interface ULAnalyser: NSObject
{
	@private
	int checkCount;
	BOOL threadError;
	id pluginList;
	id optionsView;
	id resultsLog;
	id window;
	id analysisManager;
	id mainViewController;
	id currentOptions;
	NSDictionary* pluginResults;
	NSError* pluginError;
	id selectedDataSet;		//!< The data set currently being displayed
	id pluginDataSets;		//!< Array of data sets returned by the last plugin
	NSMutableArray* openDataSets;	//!< Contains data sets currently open for display
	id outlineDelegate;
	ULProgressPanel* progressPanel;
	NSString* selectedPlugin;
	NSDictionary* classMap;		//!< Maps class names to user readable names
	id dataSetList;			//!< List showing data sets returned by a plugin
	id loadedObjectsTable;		//!< Table showing the currently loaded objects
	id loadedObjects;		//!< Array holding the currently loaded objects
	id loadableTypes;		//!< The types of object ULAnalyser can load
	id selectedObjects;		//!< The loaded objects that have been selected
	id dataView;			//!< Object that controls the display of data sets
	id toolbar;
	id reloadItem;			//!< The reload button on the toolbar
	id tabView;
	NSImage* saveImage;
	NSImage* applyImage;
	NSImage* reloadImage;
	NSImage* closeImage;
	//gnuplot
	BOOL gnuplotRunning;
	int historyDepth;
	int currentHistoryPosition;
	NSRange commandRange;
	NSRange gnuplotPrompt;
	id gnuplotInterface;
	NSString* gnuplotDir;
	NSFileHandle* gnuplotOutput;
	NSFileHandle* gnuplotError;
	NSTask* gnuplot;
	NSPipe* pipey;
	NSPipe* outPipe;
	NSMutableArray* history;
}
/**
Documentation forthcoming
*/
- (id) initWithModelViewController: (id) mVC;
/**
Documentation forthcoming
*/
- (void) open: (id) sender;
/**
Documentation forthcoming
*/
- (void) close: (id) sender;
/**
Documentation forthcoming
*/
- (void) analyse: (id) sender;
/**
Documentation forthcoming
*/
- (void) load: (id) sender;
/**
Documentation forthcoming
*/
- (void) display: (id) sender;
/**
Documentation forthcoming
*/
- (void) save: (id) sender;
/**
Documentation forthcoming
*/
- (void) remove: (id) sender;
/**
Documentation forthcoming
*/
- (void) logString: (NSString*) string;
/**
Documentation forthcoming
*/
- (void) setAvailableDataSets: (NSArray*) array;
/**
Called when a user selects a different data set in the view
*/
- (void) dataSetDidChange: (id) sender;
/**
Adds \e aDataSet to the opened data sets list.
Does nothing if the data set is already in the list.
*/
- (void) openDataSet: (AdDataSet*) aDataSet;
/**
Opens all the data sets in \e anArray, skipping any
that are opened already.
*/
- (void) openDataSets: (NSArray*) anArray;
/**
Removes \e aDataSet from the opened data sets list.
Does nothing if the data set is not in the list.
*/
- (void) closeDataSet: (AdDataSet*) aDataSet;
/**
Selects \e dataSet in the data set list and displays it.
Does nothing if the data set is not in the list.
*/
- (void) selectDataSet: (AdDataSet*) aDataSet;
@end

/**
Category containing methods which handle the 
gnuplot interface.
\ingroup interface
*/
@interface ULAnalyser (ULAnalyserGnuplotExtensions)
/**
Documentation forthcoming
*/
- (void) setupGnuplotInterface;
/**
Documentation forthcoming
*/
- (void) gnuplotDealloc;
/**
Creates the files used by gnuplot for plotting the data in \e aDataSet.
*/
- (void) createGnuplotFilesForDataSet: (AdDataSet*) aDataSet;
/**
Removed the files created by a call to \e createGnuplotFilesForDataSet.
*/
- (void) removeGnuplotFilesForDataSet: (AdDataSet*) aDataSet;
/**
Calls removeGnuplotFilesForDataSet:() for each dataSet in anArray.
*/
- (void) removeGnuplotFilesForDataSets: (NSArray*) anArray;
/**
Updates the file for the matrix currently displayed by the receivers ULAnalyserDataSetView instance.
This messages is usually called as a result of a ULAnalyserDataSetViewColumnOrderDidChangeNotification.
*/
- (void) updateFileForDisplayedMatrix: (NSNotification*) aNotification;
@end

/**
 ULAnalyser category containing methods related to
 displaying plugin options and applying plugins to data.
\ingroup interface
*/
@interface ULAnalyser (ULAnalyserPluginExtensions)

/**
Documentation forthcoming
*/
- (void) pluginChanged: (id) sender;
/**
Documentation forthcoming
*/
- (void) displayOptionsForPlugin;
/**
Documentation forthcoming
*/
- (void) applyCurrentPlugin: (id) sender;
/**
Documentation forthcoming
*/
- (void) outputPluginResults: (id) sender;
/**
Documentation forthcoming
*/
- (void) updateAvailablePlugins;
/**
Documentation forthcoming
*/
- (void) updatePluginOptions;
@end
#endif
