; For akcl (and gcl); couresy of Bill Schelter with only extremely minor
; modifications.  Loading this file makes it impossible to evaluate forms from
; within a break unless that feature is turned back on with :enable-eval T.

(in-package 'si)

(defvar *enable-eval-in-break* t)

(defun enable-eval (&rest l)
  (cond ((eql (length l) 1)
         (format *debug-io* "~&~a evaluation inside breaks."
                 (if (car l) "Enabling" "Disabling"))
         (setf *enable-eval-in-break* (car l)))
        (t (format *debug-io* "~&:enable-eval T to enable or :enable-eval nil to disable"))))

(enable-eval nil)

(setf (get :enable-eval 'break-command) 'enable-eval)

(defun break-level (at &optional env)
  (let* ((*break-message* (if (stringp at) at *break-message*))
	 (*quit-tags* (cons (cons *break-level* *quit-tag*) *quit-tags*))
         (*quit-tag* (cons nil nil))
         (*break-level* (if (not at) *break-level* (cons t *break-level*)))
         (*ihs-base* (1+ *ihs-top*))
         (*ihs-top* (1- (ihs-top)))
         (*current-ihs* *ihs-top*)
         (*frs-base* (or (sch-frs-base *frs-top* *ihs-base*) (1+ (frs-top))))
         (*frs-top* (frs-top))
         (*break-env* nil)
	 (be *break-enable*)
	 (*break-enable*
	  (progn 
	    (if (stringp at) nil be)))
					;(*standard-input* *terminal-io*)
         (*readtable* (or *break-readtable* *readtable*))
         (*read-suppress* nil)
         (+ +) (++ ++) (+++ +++)
         (- -)
         (* *) (** **) (*** ***)
         (/ /) (// //) (/// ///)
         )
					; (terpri *error-output*)
    (unless (or be (not (stringp at)))
      (simple-backtrace)
      (break-quit (length (cdr *break-level*))))
    (catch-fatal 1)
    (setq *interrupt-enable* t)
    (cond ((stringp at) (set-current)(terpri *error-output*)
	   (setq *no-prompt* nil)
	   )
	  (t (set-back at env)))
      (loop 
       (setq +++ ++ ++ + + -)
       (cond (*no-prompt* (setq *no-prompt* nil))
	     (t
	      (format *debug-io* "~&~a~a>~{~*>~}"
		      (if (stringp at) "" "dbl:")
		      (if (eq *package* (find-package 'user)) ""
			(package-name *package*))
		      *break-level*)))
       (when
	(catch 'step-continue
        (catch *quit-tag*
          (setq - (locally (declare (notinline read))
			   (dbl-read *debug-io* nil *top-eof*)))
          (when (eq - *top-eof*) (bye))
          (let* ( break-command
		 (values
		  (multiple-value-list
		  (LOCALLY (declare (notinline break-call evalhook))
			   (if (keywordp -)(setq - (cons - nil)))
			   (cond ((and (consp -) (keywordp (car -)))
				  (setq break-command t)
				  (break-call (car -)
                                              (cdr -)
                                              'si::break-command))

; Here is the patch suggested by wfs that implements :enable-eval.

				 (t (if *enable-eval-in-break* (evalhook - nil nil *break-env*)
                                       (format *debug-io* "~&Sorry, execution of top-level forms is disabled inside breaks.
Execute :enable-eval T if you want such evaluation enabled."))))))))
	    (and break-command (eq (car values) :resume )(return))
            (setq /// // // / / values *** ** ** * * (car /))
            (fresh-line *debug-io*)
            (dolist (val /)
		    (locally (declare (notinline prin1)) (prin1 val *debug-io*))
		    (terpri *debug-io*)))
          nil))
        (terpri *debug-io*)
        (break-current)))))


