(in-package "ACL2")

;don't include just this book unless you really mean it; this book contains no theorems about cat.  even the
;type-prescription lemma generated about binary-cat in this book is poor.

(defund fl (x)
  (declare (xargs :guard (real/rationalp x)))
  (floor x 1))

(defund bits (x i j)
  (declare (xargs :guard (rationalp x)))
  (if (or (not (integerp i))
          (not (integerp j)))
      0
    (fl (/ (mod x (expt 2 (1+ i))) (expt 2 j)))))

#|
;drop?
(defund ocat (x y n)
  (declare (xargs :guard t))
  (+ (* (expt 2 (nfix n)) (nfix x)) (nfix y)))
|#

; return 0 if m or n isn't a nat (change this bevahior?)
(defund binary-cat (x m y n)
  (declare (xargs :guard (and (rationalp x)
                              (acl2-numberp m)
                              (rationalp y)
                              (acl2-numberp n))))
  (if (or (not (integerp m))
          (< m 0)
          (not (integerp n))
          (< n 0)
          )
      0
    (+ (* (expt 2 n) (bits x (+ -1 m) 0))
       (bits y (+ -1 n) 0))))

;; The macro cat

(defun formal-+ (x y)
  (declare (xargs :guard t))
  (if (and (acl2-numberp x) (acl2-numberp y))
      (+ x y)
    (list '+ x y)))

(encapsulate
 ()
 (local ; for guard proof below
  (defthm fold-constants-in-+
    (implies (and (syntaxp (quotep x))
                  (syntaxp (quotep y)))
             (equal (+ x y z)
                    (+ (+ x y) z)))))

;X is a list of alternating data values and sizes.
;CAT-SIZE returns the sum of the sizes.
;X must contain at least 1 data/size pair, but we do not
;need to specify this in the guard for cat-size-fn (and,
;leaving it out of that guard simplifies the guard proof).
 (defun cat-size-fn (x)
   (declare (xargs :guard (and (true-listp x)
                               (evenp (length x)))))
   (if (endp (rest (rest x)))
       (second x)
     (formal-+ (second x)
               (cat-size-fn (rest (rest x)))))))

(defmacro cat-size (&rest x)
  (declare (xargs :guard (and (true-listp x)
                              (evenp (length x))
                              (>= (length x) 2))))
  (cat-size-fn x))

;data and sizes alternate thus: (cat x xsize y ysize z zsize ...)  
(defmacro cat (&rest x)
  (declare (xargs :guard (and (true-listp x) (evenp (length x)))))
  (cond ((endp x) ;special case 1
         `0)
        ((endp (rest (rest x))) ;special case 2
         `(bits ,(first x) ,(formal-+ -1 (second x)) 0))
        ((endp (rest (rest (rest (rest x))))) ;this is really the base case
         `(binary-cat ,@x))
        (t
         `(binary-cat ,(first x) 
                       ,(second x) 
                       (cat ,@(rest (rest x))) 
                       (cat-size ,@(rest (rest x)))))))

;Allows things like (in-theory (disable cat)) to refer to binary-cat.
(add-macro-alias cat binary-cat)

